/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextNode;
import org.neo4j.kernel.impl.core.NodeReadOperationsTest;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;

class ExecutionContextNodeReadOperationsTest
extends NodeReadOperationsTest {
    private final Map<Transaction, ExecutionContext> executionContexts = new HashMap<Transaction, ExecutionContext>();

    ExecutionContextNodeReadOperationsTest() {
    }

    @AfterEach
    void afterEach() {
        this.executionContexts.values().forEach(ExecutionContext::complete);
        IOUtils.closeAllUnchecked(this.executionContexts.values());
    }

    @Override
    PageCursorTracer reportCursorEventsAndGetTracer(Transaction tx) {
        ExecutionContext executionContext = this.getExecutionContext(tx);
        executionContext.report();
        ExecutionContextNodeReadOperationsTest.assertZeroTracer(executionContext.cursorContext());
        return executionContext.cursorContext().getCursorTracer();
    }

    @Override
    protected Node lookupNode(Transaction tx, String id) {
        ExecutionContext executionContext = this.getExecutionContext(tx);
        long internalId = executionContext.elementIdMapper().nodeId(id);
        return new ExecutionContextNode(internalId, executionContext);
    }

    private ExecutionContext getExecutionContext(Transaction tx) {
        return this.executionContexts.computeIfAbsent(tx, t -> {
            KernelTransaction ktx = ((InternalTransaction)t).kernelTransaction();
            try (Statement statement = ktx.acquireStatement();){
                ExecutionContext executionContext = ktx.createExecutionContext();
                return executionContext;
            }
        });
    }
}

