/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.MyRelTypes;

class Neo4jConstraintsTest
extends AbstractNeo4jTestCase {
    private final String key = "testproperty";

    Neo4jConstraintsTest() {
    }

    @Test
    void testDeleteReferenceNodeOrLastNodeIsOk() {
        ResourceIterable allNodes;
        for (int i = 0; i < 10; ++i) {
            this.createNode();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            allNodes = transaction.getAllNodes();
            try {
                for (Node node : allNodes) {
                    Iterables.forEach((Iterable)node.getRelationships(), Entity::delete);
                    node.delete();
                }
                transaction.commit();
            }
            finally {
                if (allNodes != null) {
                    allNodes.close();
                }
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            allNodes = transaction.getAllNodes();
            try {
                Assertions.assertThat((Iterable)allNodes).hasSize(0);
                transaction.commit();
            }
            finally {
                if (allNodes != null) {
                    allNodes.close();
                }
            }
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testDeleteNodeWithRel1() {
        Node node1 = this.createNode();
        Node node2 = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode1 = transaction.getNodeById(node1.getId());
            Node txNode2 = transaction.getNodeById(node2.getId());
            txNode1.createRelationshipTo(txNode2, (RelationshipType)MyRelTypes.TEST);
            txNode1.delete();
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> ((Transaction)transaction).commit());
        }
    }

    @Test
    void testDeleteNodeWithRel2() {
        Node node1 = this.createNode();
        Node node2 = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode1 = transaction.getNodeById(node1.getId());
            Node txNode2 = transaction.getNodeById(node2.getId());
            txNode1.createRelationshipTo(txNode2, (RelationshipType)MyRelTypes.TEST);
            txNode2.delete();
            txNode1.delete();
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> ((Transaction)transaction).commit());
        }
    }

    @Test
    void testDeleteNodeWithRel3() {
        Relationship rel1;
        Node txNode0;
        Node node0 = this.createNode();
        Node node1 = this.createNode();
        Node node2 = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            txNode0 = transaction.getNodeById(node0.getId());
            Node txNode1 = transaction.getNodeById(node1.getId());
            Node txNode2 = transaction.getNodeById(node2.getId());
            Relationship rel0 = txNode0.createRelationshipTo(txNode1, (RelationshipType)MyRelTypes.TEST);
            rel1 = txNode0.createRelationshipTo(txNode2, (RelationshipType)MyRelTypes.TEST);
            txNode1.delete();
            rel0.delete();
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            txNode0 = transaction.getNodeById(node0.getId());
            Node txNode2 = transaction.getNodeById(node2.getId());
            Relationship txRel1 = transaction.getRelationshipById(rel1.getId());
            txNode2.delete();
            txRel1.delete();
            txNode0.delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testCreateRelOnDeletedNode() {
        Node node1 = this.createNode();
        Node node2 = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeById(node1.getId());
            txNode.delete();
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> txNode.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST));
        }
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeById(node2.getId()).delete();
            transaction.getNodeById(node1.getId()).delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testAddPropertyDeletedNode() {
        Node node = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeById(node.getId());
            txNode.delete();
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> txNode.setProperty("testproperty", (Object)1));
        }
    }

    @Test
    void testRemovePropertyDeletedNode() {
        GraphDatabaseService database = this.getGraphDb();
        try (Transaction transaction = database.beginTx();){
            Node node = transaction.createNode();
            node.setProperty("testproperty", (Object)1);
            node.delete();
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
                node.removeProperty("testproperty");
                transaction.commit();
            });
        }
    }

    @Test
    void testChangePropertyDeletedNode() {
        Node node = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeById(node.getId());
            txNode.setProperty("testproperty", (Object)1);
            txNode.delete();
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
                txNode.setProperty("testproperty", (Object)2);
                transaction.commit();
            });
        }
    }

    @Test
    void testAddPropertyDeletedRelationship() {
        Node node1 = this.createNode();
        Node node2 = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode1 = transaction.getNodeById(node1.getId());
            Node txNode2 = transaction.getNodeById(node2.getId());
            Relationship rel = txNode1.createRelationshipTo(txNode2, (RelationshipType)MyRelTypes.TEST);
            rel.delete();
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
                rel.setProperty("testproperty", (Object)1);
                transaction.commit();
            });
            txNode1.delete();
            txNode2.delete();
            transaction.commit();
        }
    }

    @Test
    void testRemovePropertyDeletedRelationship() {
        Node node1 = this.createNode();
        Node node2 = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode1 = transaction.getNodeById(node1.getId());
            Node txNode2 = transaction.getNodeById(node2.getId());
            Relationship rel = txNode1.createRelationshipTo(txNode2, (RelationshipType)MyRelTypes.TEST);
            rel.setProperty("testproperty", (Object)1);
            rel.delete();
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
                rel.removeProperty("testproperty");
                transaction.commit();
            });
            txNode1.delete();
            txNode2.delete();
            transaction.commit();
        }
    }

    @Test
    void testChangePropertyDeletedRelationship() {
        Node node1 = this.createNode();
        Node node2 = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeById(node1.getId());
            Node txNode2 = transaction.getNodeById(node2.getId());
            Relationship rel = txNode.createRelationshipTo(txNode2, (RelationshipType)MyRelTypes.TEST);
            rel.setProperty("testproperty", (Object)1);
            rel.delete();
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
                rel.setProperty("testproperty", (Object)2);
                transaction.commit();
            });
            txNode.delete();
            txNode2.delete();
            transaction.commit();
        }
    }

    @Test
    void testMultipleDeleteNode() {
        Node node1 = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeById(node1.getId());
            txNode.delete();
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
                txNode.delete();
                transaction.commit();
            });
        }
    }

    @Test
    void testMultipleDeleteRelationship() {
        Node node1 = this.createNode();
        Node node2 = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode1 = transaction.getNodeById(node1.getId());
            Node txNode2 = transaction.getNodeById(node2.getId());
            Relationship rel = txNode1.createRelationshipTo(txNode2, (RelationshipType)MyRelTypes.TEST);
            rel.delete();
            txNode1.delete();
            txNode2.delete();
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
                rel.delete();
                transaction.commit();
            });
            transaction.commit();
        }
    }

    @Test
    void testIllegalPropertyType() {
        try (Transaction tx = this.getGraphDb().beginTx();){
            Node node1 = tx.createNode();
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> node1.setProperty("testproperty", new Object()));
        }
    }

    @Test
    void testNodeRelDeleteSemantics() {
        Relationship rel2;
        Relationship rel1;
        Node node1 = this.createNode();
        Node node2 = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeById(node1.getId());
            Node txNode2 = transaction.getNodeById(node2.getId());
            rel1 = txNode.createRelationshipTo(txNode2, (RelationshipType)MyRelTypes.TEST);
            rel2 = txNode.createRelationshipTo(txNode2, (RelationshipType)MyRelTypes.TEST);
            txNode.setProperty("key1", (Object)"value1");
            rel1.setProperty("key1", (Object)"value1");
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Node node = transaction.getNodeById(node1.getId());
            Node secondNode = transaction.getNodeById(node2.getId());
            Relationship relationshipOne = transaction.getRelationshipById(rel1.getId());
            Relationship relationshipTwo = transaction.getRelationshipById(rel2.getId());
            node.delete();
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> node.getProperty("key1"));
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> node.setProperty("key1", (Object)"value2"));
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> node.removeProperty("key1"));
            secondNode.delete();
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> ((Node)secondNode).delete());
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> node.getProperty("key1"));
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> node.setProperty("key1", (Object)"value2"));
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> node.removeProperty("key1"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"value1", (Object)relationshipOne.getProperty("key1"));
            relationshipOne.delete();
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> ((Relationship)relationshipOne).delete());
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> relationshipOne.getProperty("key1"));
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> relationshipOne.setProperty("key1", (Object)"value2"));
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> relationshipOne.removeProperty("key1"));
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> relationshipOne.getProperty("key1"));
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> relationshipOne.setProperty("key1", (Object)"value2"));
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> relationshipOne.removeProperty("key1"));
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> secondNode.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST));
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> secondNode.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST));
            org.junit.jupiter.api.Assertions.assertEquals((Object)node, (Object)relationshipOne.getStartNode());
            org.junit.jupiter.api.Assertions.assertEquals((Object)secondNode, (Object)relationshipTwo.getEndNode());
            Node[] nodes = relationshipOne.getNodes();
            org.junit.jupiter.api.Assertions.assertEquals((Object)node, (Object)nodes[0]);
            org.junit.jupiter.api.Assertions.assertEquals((Object)secondNode, (Object)nodes[1]);
            org.junit.jupiter.api.Assertions.assertEquals((Object)secondNode, (Object)relationshipOne.getOtherNode(node));
            relationshipTwo.delete();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }
}

