/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.IOException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.DatabaseEventListenerAdapter;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

class TestShutdownSequence {
    private DatabaseManagementService managementService;

    TestShutdownSequence() {
    }

    @BeforeEach
    void createGraphDb() {
        this.managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
    }

    @Test
    void canInvokeShutdownMultipleTimes() {
        this.managementService.shutdown();
        this.managementService.shutdown();
    }

    @Test
    void notifyEventListenersOnShutdown() {
        final MutableInt counter = new MutableInt();
        this.managementService.registerDatabaseEventListener((DatabaseEventListener)new DatabaseEventListenerAdapter(this){

            public void databaseShutdown(DatabaseEventContext eventContext) {
                counter.incrementAndGet();
            }
        });
        this.managementService.shutdown();
        this.managementService.shutdown();
        Assertions.assertEquals((int)2, (int)counter.intValue());
    }

    @Test
    void canRemoveFilesAndReinvokeShutdown() throws IOException {
        GraphDatabaseAPI databaseAPI = (GraphDatabaseAPI)this.managementService.database("neo4j");
        FileSystemAbstraction fileSystemAbstraction = TestShutdownSequence.getDatabaseFileSystem(databaseAPI);
        this.managementService.shutdown();
        fileSystemAbstraction.deleteRecursively(databaseAPI.databaseLayout().databaseDirectory());
        this.managementService.shutdown();
    }

    @Test
    void canInvokeShutdownFromShutdownListener() {
        this.managementService.registerDatabaseEventListener((DatabaseEventListener)new DatabaseEventListenerAdapter(){

            public void databaseShutdown(DatabaseEventContext eventContext) {
                TestShutdownSequence.this.managementService.shutdown();
            }
        });
        this.managementService.shutdown();
    }

    private static FileSystemAbstraction getDatabaseFileSystem(GraphDatabaseAPI databaseAPI) {
        return (FileSystemAbstraction)databaseAPI.getDependencyResolver().resolveDependency(FileSystemAbstraction.class);
    }
}

