/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class NodeAccessRequireTransactionIT {
    @Inject
    private GraphDatabaseAPI databaseAPI;
    private InternalTransaction transaction;

    @BeforeEach
    void setUp() {
        this.transaction = (InternalTransaction)this.databaseAPI.beginTx();
    }

    @AfterEach
    void tearDown() {
        if (this.transaction != null) {
            this.transaction.close();
        }
    }

    @Test
    void deleteNodeRequireTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Node)node).delete());
    }

    @Test
    void relationshipsAccessRequireTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Node)node).getRelationships());
    }

    @Test
    void hasRelationshipCheckRequireTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Node)node).hasRelationship());
    }

    @Test
    void hasRelationshipByTypeCheckRequireTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> node.hasRelationship(new RelationshipType[]{RelationshipType.withName((String)"any")}));
    }

    @Test
    void hasRelationshipByTypeAndDirectionRequireTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> node.hasRelationship(Direction.OUTGOING, new RelationshipType[]{RelationshipType.withName((String)"any")}));
    }

    @Test
    void relationshipsByTypeRequireTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> node.getRelationships(new RelationshipType[]{RelationshipType.withName((String)"any")}));
    }

    @Test
    void relationshipsByTypeAndDirectionRequireTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> node.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipType.withName((String)"any")}));
    }

    @Test
    void relationshipsByDirectionAccessRequireTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> node.getRelationships(Direction.BOTH));
    }

    @Test
    void singleRelationshipRequireTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> node.getSingleRelationship(RelationshipType.withName((String)"any"), Direction.BOTH));
    }

    @Test
    void createRelationshipRequireTransaction() {
        Node node = this.detachedNode();
        try (Transaction tx = this.databaseAPI.beginTx();){
            Assertions.assertThrows(NotInTransactionException.class, () -> node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"any")));
        }
    }

    @Test
    void degreeByRelTypeRequiresTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> node.getDegree(RelationshipType.withName((String)"any")));
    }

    @Test
    void degreeByDirectionRequiresTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> node.getDegree(Direction.OUTGOING));
    }

    @Test
    void degreeByDirectionAndRelTypeRequiresTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> node.getDegree(RelationshipType.withName((String)"any"), Direction.OUTGOING));
    }

    @Test
    void degreeRequiresTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Node)node).getDegree());
    }

    @Test
    void labelAddRequiresTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> node.addLabel(Label.label((String)"any")));
    }

    @Test
    void labelRemoveRequiresTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> node.removeLabel(Label.label((String)"any")));
    }

    @Test
    void labelCheckRequireTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> node.hasLabel(Label.label((String)"any")));
    }

    @Test
    void labelsAccessRequireTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Node)node).getLabels());
    }

    @Test
    void relTypesAccessRequireTransaction() {
        Node node = this.detachedNode();
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Node)node).getRelationshipTypes());
    }

    private Node detachedNode() {
        Node node = this.transaction.createNode();
        this.transaction.close();
        return node;
    }
}

