/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.ReadTestSupport;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
abstract class IndexProvidedValuesRange10Test
extends KernelAPIReadTestBase<ReadTestSupport> {
    private static final int N_ENTITIES = 10000;
    public static final String TOKEN = "Token";
    public static final String PROP = "prop";
    public static final String PRIP = "prip";
    public static final String PROP_INDEX = "propIndex";
    public static final String PROP_PRIP_INDEX = "propPripIndex";
    @Inject
    private RandomSupport randomRule;
    private List<Value> singlePropValues = new ArrayList<Value>();
    private List<ValueTuple> doublePropValues = new ArrayList<ValueTuple>();

    IndexProvidedValuesRange10Test() {
    }

    @Override
    public ReadTestSupport newTestSupport() {
        return new ReadTestSupport();
    }

    abstract EntityControl getEntityControl();

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            this.getEntityControl().createIndex(tx, TOKEN, PROP, PROP_INDEX);
            this.getEntityControl().createIndex(tx, TOKEN, PROP, PRIP, PROP_PRIP_INDEX);
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            RandomValues randomValues = this.randomRule.randomValues();
            ValueType[] allExceptNonSortable = RandomValues.excluding((ValueType[])new ValueType[]{ValueType.STRING, ValueType.STRING_ARRAY});
            for (int i = 0; i < 10000; ++i) {
                Entity node = this.getEntityControl().createEntity(tx, TOKEN);
                Value propValue = randomValues.nextValueOfTypes(allExceptNonSortable);
                node.setProperty(PROP, propValue.asObject());
                Value pripValue = randomValues.nextValueOfTypes(allExceptNonSortable);
                node.setProperty(PRIP, pripValue.asObject());
                this.singlePropValues.add(propValue);
                this.doublePropValues.add(ValueTuple.of((Value[])new Value[]{propValue, pripValue}));
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.singlePropValues.sort((Comparator<Value>)Values.COMPARATOR);
        this.doublePropValues.sort(ValueTuple.COMPARATOR);
    }

    @Test
    void shouldGetAllSinglePropertyValues() throws Exception {
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_INDEX));
        List<Value> values = this.getEntityControl().findValues(this.tx, this.cursors, index);
        ((ListAssert)Assertions.assertThat(values).as("index should return all single property values", new Object[0])).containsExactlyInAnyOrderElementsOf(this.singlePropValues);
    }

    @Test
    void shouldGetAllDoublePropertyValues() throws Exception {
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName(PROP_PRIP_INDEX));
        List<ValueTuple> values = this.getEntityControl().findValuePairs(this.tx, this.cursors, index);
        ((ListAssert)Assertions.assertThat(values).as("index should return all double property values", new Object[0])).containsExactlyInAnyOrderElementsOf(this.doublePropValues);
    }

    static enum EntityControl {
        NODE{

            @Override
            public void createIndex(Transaction tx, String token, String propertyKey, String indexName) {
                tx.schema().indexFor(Label.label((String)token)).on(propertyKey).withName(indexName).create();
            }

            @Override
            void createIndex(Transaction tx, String token, String propertyKey1, String propertyKey2, String indexName) {
                tx.schema().indexFor(Label.label((String)token)).on(propertyKey1).on(propertyKey2).withName(indexName).create();
            }

            @Override
            public List<Value> findValues(KernelTransaction tx, CursorFactory cursors, IndexReadSession index) throws KernelException {
                try (NodeValueIndexCursor cursor = cursors.allocateNodeValueIndexCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                    tx.dataRead().nodeIndexScan(index, cursor, IndexQueryConstraints.unorderedValues());
                    ArrayList<Value> values = new ArrayList<Value>();
                    while (cursor.next()) {
                        values.add(cursor.propertyValue(0));
                    }
                    ArrayList<Value> arrayList = values;
                    return arrayList;
                }
            }

            @Override
            public List<ValueTuple> findValuePairs(KernelTransaction tx, CursorFactory cursors, IndexReadSession index) throws KernelException {
                try (NodeValueIndexCursor cursor = cursors.allocateNodeValueIndexCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                    tx.dataRead().nodeIndexScan(index, cursor, IndexQueryConstraints.unorderedValues());
                    ArrayList<ValueTuple> values = new ArrayList<ValueTuple>();
                    while (cursor.next()) {
                        values.add(ValueTuple.of((Value[])new Value[]{cursor.propertyValue(0), cursor.propertyValue(1)}));
                    }
                    ArrayList<ValueTuple> arrayList = values;
                    return arrayList;
                }
            }

            @Override
            public Entity createEntity(Transaction tx, String token) {
                return tx.createNode(new Label[]{Label.label((String)token)});
            }
        }
        ,
        RELATIONSHIP{

            @Override
            public void createIndex(Transaction tx, String token, String propertyKey, String indexName) {
                tx.schema().indexFor(RelationshipType.withName((String)token)).on(propertyKey).withName(indexName).create();
            }

            @Override
            void createIndex(Transaction tx, String token, String propertyKey1, String propertyKey2, String indexName) {
                tx.schema().indexFor(RelationshipType.withName((String)token)).on(propertyKey1).on(propertyKey2).withName(indexName).create();
            }

            @Override
            public List<Value> findValues(KernelTransaction tx, CursorFactory cursors, IndexReadSession index) throws KernelException {
                try (RelationshipValueIndexCursor cursor = cursors.allocateRelationshipValueIndexCursor(CursorContext.NULL_CONTEXT, tx.memoryTracker());){
                    tx.dataRead().relationshipIndexScan(index, cursor, IndexQueryConstraints.unorderedValues());
                    ArrayList<Value> values = new ArrayList<Value>();
                    while (cursor.next()) {
                        values.add(cursor.propertyValue(0));
                    }
                    ArrayList<Value> arrayList = values;
                    return arrayList;
                }
            }

            @Override
            public List<ValueTuple> findValuePairs(KernelTransaction tx, CursorFactory cursors, IndexReadSession index) throws KernelException {
                try (RelationshipValueIndexCursor cursor = cursors.allocateRelationshipValueIndexCursor(CursorContext.NULL_CONTEXT, tx.memoryTracker());){
                    tx.dataRead().relationshipIndexScan(index, cursor, IndexQueryConstraints.unorderedValues());
                    ArrayList<ValueTuple> values = new ArrayList<ValueTuple>();
                    while (cursor.next()) {
                        values.add(ValueTuple.of((Value[])new Value[]{cursor.propertyValue(0), cursor.propertyValue(1)}));
                    }
                    ArrayList<ValueTuple> arrayList = values;
                    return arrayList;
                }
            }

            @Override
            public Entity createEntity(Transaction tx, String token) {
                return tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)token));
            }
        };


        abstract void createIndex(Transaction var1, String var2, String var3, String var4);

        abstract void createIndex(Transaction var1, String var2, String var3, String var4, String var5);

        abstract List<Value> findValues(KernelTransaction var1, CursorFactory var2, IndexReadSession var3) throws KernelException;

        public abstract List<ValueTuple> findValuePairs(KernelTransaction var1, CursorFactory var2, IndexReadSession var3) throws KernelException;

        abstract Entity createEntity(Transaction var1, String var2);
    }
}

