/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;

public abstract class LargeNodeCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static final List<Long> NODE_IDS = new ArrayList<Long>();
    private static final int N_NODES = 10000;
    private static final Random RANDOM = new Random();

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        ArrayList<Node> deleted = new ArrayList<Node>();
        try (Transaction tx = graphDb.beginTx();){
            for (int i = 0; i < 10000; ++i) {
                Node node = tx.createNode();
                if (RANDOM.nextBoolean()) {
                    NODE_IDS.add(node.getId());
                    continue;
                }
                deleted.add(node);
            }
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            for (Node node : deleted) {
                tx.getNodeById(node.getId()).delete();
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldScanNodes() {
        ArrayList<Long> ids = new ArrayList<Long>();
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);){
            this.read.allNodesScan(nodes);
            while (nodes.next()) {
                ids.add(nodes.nodeReference());
            }
        }
        Assertions.assertEquals(NODE_IDS, ids);
    }

    @Test
    void shouldAccessNodesByReference() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);){
            for (long id : NODE_IDS) {
                this.read.singleNode(id, nodes);
                Assertions.assertTrue((boolean)nodes.next(), (String)"should access defined node");
                Assertions.assertEquals((long)id, (long)nodes.nodeReference(), (String)"should access the correct node");
                Assertions.assertFalse((boolean)nodes.next(), (String)"should only access a single node");
            }
        }
    }
}

