/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.IndexTransactionStateWithApplyChangesTestBase;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class RelationshipIndexTransactionStateWithApplyChangesTest
extends IndexTransactionStateWithApplyChangesTestBase {
    private static final String DEFAULT_TYPE = "type";

    @Override
    IndexTransactionStateWithApplyChangesTestBase.EntityWithProps entityWithProps(KernelTransaction tx, Object val, Object val2) throws Exception {
        Write write = tx.dataWrite();
        long node = write.nodeCreate();
        int relType = tx.tokenWrite().relationshipTypeGetOrCreateForName(DEFAULT_TYPE);
        long rel = write.relationshipCreate(node, relType, node);
        return this.setPropsOnEntity(tx, rel, val, val2);
    }

    @Override
    void createIndex(IndexType indexType) {
        try (Transaction tx = this.graphDb.beginTx();){
            tx.schema().indexFor(RelationshipType.withName((String)DEFAULT_TYPE)).on("prop1").on("prop2").withIndexType(indexType).withName("myIndex").create();
            tx.commit();
        }
        tx = this.graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    void deleteEntity(KernelTransaction tx, long entity) throws Exception {
        tx.dataWrite().relationshipDelete(entity);
    }

    @Override
    void removeProperties(KernelTransaction tx, long entity) throws Exception {
        int prop1Key = tx.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        int prop2Key = tx.tokenWrite().propertyKeyGetOrCreateForName("prop2");
        MutableIntObjectMap propertiesToSet = IntObjectMaps.mutable.empty();
        propertiesToSet.put(prop1Key, (Object)Values.NO_VALUE);
        propertiesToSet.put(prop2Key, (Object)Values.NO_VALUE);
        tx.dataWrite().relationshipApplyChanges(entity, (IntObjectMap)propertiesToSet);
    }

    @Override
    IndexTransactionStateWithApplyChangesTestBase.EntityWithProps setProperties(KernelTransaction tx, long entity, Object val, Object val2) throws Exception {
        return this.setPropsOnEntity(tx, entity, val, val2);
    }

    private IndexTransactionStateWithApplyChangesTestBase.EntityWithProps setPropsOnEntity(KernelTransaction tx, long entity, Object val, Object val2) throws KernelException {
        int prop1Key = tx.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        int prop2Key = tx.tokenWrite().propertyKeyGetOrCreateForName("prop2");
        MutableIntObjectMap propertiesToSet = IntObjectMaps.mutable.empty();
        Value value1 = Values.of((Object)val);
        propertiesToSet.put(prop1Key, (Object)value1);
        Value value2 = Values.of((Object)val2);
        propertiesToSet.put(prop2Key, (Object)value2);
        tx.dataWrite().relationshipApplyChanges(entity, (IntObjectMap)propertiesToSet);
        return new IndexTransactionStateWithApplyChangesTestBase.EntityWithProps(entity, value1, value2);
    }

    @Override
    void assertEntityAndValueForScan(Set<IndexTransactionStateWithApplyChangesTestBase.EntityWithProps> expected, KernelTransaction tx, IndexDescriptor index, boolean needsValues, Object anotherValueFoundByQuery, Object anotherValueFoundByQuery2) throws Exception {
        IndexReadSession indexSession = tx.dataRead().indexReadSession(index);
        try (RelationshipValueIndexCursor rels = tx.cursors().allocateRelationshipValueIndexCursor(tx.cursorContext(), tx.memoryTracker());){
            tx.dataRead().relationshipIndexScan(indexSession, rels, IndexQueryConstraints.unordered((boolean)needsValues));
            this.assertEntityAndValue(expected, tx, needsValues, anotherValueFoundByQuery, anotherValueFoundByQuery2, new RelationshipCursorAdapter(rels));
        }
    }

    private static class RelationshipCursorAdapter
    implements IndexTransactionStateWithApplyChangesTestBase.EntityValueIndexCursor {
        private final RelationshipValueIndexCursor relationships;

        private RelationshipCursorAdapter(RelationshipValueIndexCursor relationships) {
            this.relationships = relationships;
        }

        @Override
        public boolean next() {
            return this.relationships.next();
        }

        @Override
        public Value propertyValue(int offset) {
            return this.relationships.propertyValue(offset);
        }

        @Override
        public long entityReference() {
            return this.relationships.relationshipReference();
        }
    }
}

