/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.junit.jupiter.api.Assertions;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.kernel.api.KernelTransaction;

class RelationshipTestSupport {
    private static final BiFunction<Transaction, Node, StartRelationship>[] SPARSE_DENSE_RELS = (BiFunction[])Iterators.array((Object[])new BiFunction[]{RelationshipTestSupport.loop("FOO"), RelationshipTestSupport.outgoing("FOO"), RelationshipTestSupport.outgoing("BAR"), RelationshipTestSupport.outgoing("BAR"), RelationshipTestSupport.incoming("FOO"), RelationshipTestSupport.outgoing("FOO"), RelationshipTestSupport.incoming("BAZ"), RelationshipTestSupport.incoming("BAR"), RelationshipTestSupport.outgoing("BAZ"), RelationshipTestSupport.loop("FOO")});

    private RelationshipTestSupport() {
    }

    static void someGraph(GraphDatabaseService graphDb) {
        Relationship dead;
        try (Transaction tx = graphDb.beginTx();){
            Node a = tx.createNode();
            Node b = tx.createNode();
            Node c = tx.createNode();
            Node d = tx.createNode();
            a.createRelationshipTo(a, RelationshipType.withName((String)"ALPHA"));
            a.createRelationshipTo(b, RelationshipType.withName((String)"BETA"));
            a.createRelationshipTo(c, RelationshipType.withName((String)"GAMMA"));
            a.createRelationshipTo(d, RelationshipType.withName((String)"DELTA"));
            tx.createNode().createRelationshipTo(a, RelationshipType.withName((String)"BETA"));
            a.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"BETA"));
            dead = a.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"BETA"));
            a.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"BETA"));
            Node clump = tx.createNode();
            clump.createRelationshipTo(clump, RelationshipType.withName((String)"REL"));
            clump.createRelationshipTo(clump, RelationshipType.withName((String)"REL"));
            clump.createRelationshipTo(clump, RelationshipType.withName((String)"REL"));
            clump.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"REL"));
            clump.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"REL"));
            clump.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"REL"));
            tx.createNode().createRelationshipTo(clump, RelationshipType.withName((String)"REL"));
            tx.createNode().createRelationshipTo(clump, RelationshipType.withName((String)"REL"));
            tx.createNode().createRelationshipTo(clump, RelationshipType.withName((String)"REL"));
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            dead = tx.getRelationshipById(dead.getId());
            Node node = dead.getEndNode();
            dead.delete();
            node.delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    static StartNode sparse(GraphDatabaseService graphDb) {
        Map<String, List<StartRelationship>> relationshipMap;
        Node node;
        try (Transaction tx = graphDb.beginTx();){
            node = tx.createNode();
            relationshipMap = RelationshipTestSupport.buildSparseDenseRels(tx, node);
            tx.commit();
        }
        return new StartNode(node.getId(), relationshipMap);
    }

    static StartNode dense(GraphDatabaseService graphDb) {
        Map<String, List<StartRelationship>> relationshipMap;
        Node node;
        try (Transaction tx = graphDb.beginTx();){
            node = tx.createNode();
            relationshipMap = RelationshipTestSupport.buildSparseDenseRels(tx, node);
            ArrayList<StartRelationship> bulk = new ArrayList<StartRelationship>();
            RelationshipType bulkType = RelationshipType.withName((String)"BULK");
            for (int i = 0; i < 200; ++i) {
                Relationship r = node.createRelationshipTo(tx.createNode(), bulkType);
                bulk.add(new StartRelationship(r.getId(), Direction.OUTGOING, bulkType));
            }
            String bulkKey = RelationshipTestSupport.computeKey("BULK", Direction.OUTGOING);
            relationshipMap.put(bulkKey, bulk);
            tx.commit();
        }
        return new StartNode(node.getId(), relationshipMap);
    }

    static Map<String, Integer> count(KernelTransaction transaction, RelationshipTraversalCursor relationship) throws KernelException {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        while (relationship.next()) {
            String key = RelationshipTestSupport.computeKey(transaction, relationship);
            counts.compute(key, (k, value) -> value == null ? 1 : value + 1);
        }
        return counts;
    }

    static void assertCount(KernelTransaction transaction, RelationshipTraversalCursor relationship, Map<String, Integer> expectedCounts, int expectedType, Direction direction) throws KernelException {
        String key = RelationshipTestSupport.computeKey(transaction.token().relationshipTypeName(expectedType), direction);
        int expectedCount = expectedCounts.getOrDefault(key, 0);
        int count = 0;
        while (relationship.next()) {
            Assertions.assertEquals((int)expectedType, (int)relationship.type(), (String)"same type");
            ++count;
        }
        Assertions.assertEquals((int)expectedCount, (int)count, (String)String.format("expected number of relationships for key '%s'", key));
    }

    static void assertCounts(Map<String, Integer> expectedCounts, Map<String, Integer> counts) {
        for (Map.Entry<String, Integer> expected : expectedCounts.entrySet()) {
            Assertions.assertEquals((Integer)expected.getValue(), (Integer)counts.get(expected.getKey()), (String)String.format("counts for relationship key '%s' are equal", expected.getKey()));
        }
    }

    private static Map<String, List<StartRelationship>> buildSparseDenseRels(Transaction transaction, Node node) {
        HashMap<String, List<StartRelationship>> relationshipMap = new HashMap<String, List<StartRelationship>>();
        for (BiFunction<Transaction, Node, StartRelationship> rel : SPARSE_DENSE_RELS) {
            StartRelationship r = rel.apply(transaction, node);
            List relsOfType = relationshipMap.computeIfAbsent(RelationshipTestSupport.computeKey(r), key -> new ArrayList());
            relsOfType.add(r);
        }
        return relationshipMap;
    }

    private static String computeKey(StartRelationship r) {
        return RelationshipTestSupport.computeKey(r.type.name(), r.direction);
    }

    private static String computeKey(KernelTransaction transaction, RelationshipTraversalCursor r) throws KernelException {
        Direction d = r.sourceNodeReference() == r.targetNodeReference() ? Direction.BOTH : (r.sourceNodeReference() == r.originNodeReference() ? Direction.OUTGOING : Direction.INCOMING);
        return RelationshipTestSupport.computeKey(transaction.token().relationshipTypeName(r.type()), d);
    }

    static String computeKey(String type, Direction direction) {
        return type + "-" + String.valueOf(direction);
    }

    private static BiFunction<Transaction, Node, StartRelationship> outgoing(String type) {
        return (tx, node) -> {
            RelationshipType relType = RelationshipType.withName((String)type);
            return new StartRelationship(node.createRelationshipTo(tx.createNode(), relType).getId(), Direction.OUTGOING, relType);
        };
    }

    private static BiFunction<Transaction, Node, StartRelationship> incoming(String type) {
        return (tx, node) -> {
            RelationshipType relType = RelationshipType.withName((String)type);
            return new StartRelationship(tx.createNode().createRelationshipTo(node, relType).getId(), Direction.INCOMING, relType);
        };
    }

    private static BiFunction<Transaction, Node, StartRelationship> loop(String type) {
        return (db, node) -> {
            RelationshipType relType = RelationshipType.withName((String)type);
            return new StartRelationship(node.createRelationshipTo(node, relType).getId(), Direction.BOTH, relType);
        };
    }

    static class StartNode {
        public final long id;
        public final Map<String, List<StartRelationship>> relationships;

        StartNode(long id, Map<String, List<StartRelationship>> relationships) {
            this.id = id;
            this.relationships = relationships;
        }

        Map<String, Integer> expectedCounts() {
            HashMap<String, Integer> expectedCounts = new HashMap<String, Integer>();
            for (Map.Entry<String, List<StartRelationship>> kv : this.relationships.entrySet()) {
                expectedCounts.put(kv.getKey(), this.relationships.get(kv.getKey()).size());
            }
            return expectedCounts;
        }
    }

    static class StartRelationship {
        public final long id;
        public final Direction direction;
        public final RelationshipType type;

        StartRelationship(long id, Direction direction, RelationshipType type) {
            this.id = id;
            this.type = type;
            this.direction = direction;
        }
    }
}

