/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.junit.jupiter.api.Assertions;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.WorkerContext;

public final class TestUtils {
    private TestUtils() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    static void assertDistinct(LongList ... lists) {
        TestUtils.assertDistinct(Arrays.asList(lists));
    }

    static void assertDistinct(List<LongList> lists) {
        TestUtils.assertDistinct(lists, "");
    }

    static void assertDistinct(List<LongList> lists, String errorMessage) {
        MutableLongSet seen = LongSets.mutable.empty();
        for (LongList list : lists) {
            list.forEach((LongProcedure & Serializable)item -> Assertions.assertTrue((boolean)seen.add(item), (String)String.format("%s was seen multiple times, %s", item, errorMessage)));
        }
    }

    static LongList concat(LongList ... lists) {
        return TestUtils.concat(Arrays.asList(lists));
    }

    static LongList concat(List<LongList> lists) {
        MutableLongList concat = LongLists.mutable.empty();
        lists.forEach(arg_0 -> ((MutableLongList)concat).addAll(arg_0));
        return concat;
    }

    static <T extends Cursor> List<WorkerContext<T>> createContexts(KernelTransaction tx, Function<CursorContext, T> cursorFactory, int numberOfWorkers) {
        ArrayList<WorkerContext<T>> workers = new ArrayList<WorkerContext<T>>(numberOfWorkers);
        for (int i = 0; i < numberOfWorkers; ++i) {
            Statement statement = tx.acquireStatement();
            ExecutionContext executionContext = tx.createExecutionContext();
            WorkerContext<Cursor> workerContext = new WorkerContext<Cursor>((Cursor)cursorFactory.apply(executionContext.cursorContext()), executionContext, tx, statement);
            workers.add(workerContext);
        }
        return workers;
    }

    static <T extends Cursor> Callable<LongList> singleBatchWorker(PartitionedScan<T> scan, WorkerContext<T> workerContext, ToLongFunction<T> producer) {
        return () -> {
            try {
                LongArrayList batch = new LongArrayList();
                Cursor cursor = (Cursor)workerContext.getCursor();
                ExecutionContext executionContext = workerContext.getContext();
                scan.reservePartition(cursor, executionContext);
                while (cursor.next()) {
                    batch.add(producer.applyAsLong(cursor));
                }
                LongArrayList longArrayList = batch;
                return longArrayList;
            }
            finally {
                workerContext.complete();
            }
        };
    }

    static <T extends Cursor> List<Callable<LongList>> createWorkers(PartitionedScan<T> scan, List<WorkerContext<T>> workerContexts, ToLongFunction<T> toLongFunction) {
        ArrayList<Callable<LongList>> workers = new ArrayList<Callable<LongList>>(workerContexts.size());
        for (int i = 0; i < scan.getNumberOfPartitions(); ++i) {
            workers.add(TestUtils.singleBatchWorker(scan, workerContexts.get(i), toLongFunction));
        }
        return workers;
    }

    static <T extends AutoCloseable> void closeWorkContexts(List<WorkerContext<T>> workers) {
        for (WorkerContext<T> worker : workers) {
            worker.close();
        }
    }

    static enum PartitionedScanAPI {
        NEW{

            @Override
            <CURSOR extends Cursor> boolean reservePartition(PartitionedScan<CURSOR> scan, CURSOR cursor, KernelTransaction tx, ExecutionContext executionContext) {
                return scan.reservePartition(cursor, executionContext);
            }
        }
        ,
        LEGACY{

            @Override
            <CURSOR extends Cursor> boolean reservePartition(PartitionedScan<CURSOR> scan, CURSOR cursor, KernelTransaction tx, ExecutionContext executionContext) {
                return scan.reservePartition(cursor, executionContext);
            }
        };


        abstract <CURSOR extends Cursor> boolean reservePartition(PartitionedScan<CURSOR> var1, CURSOR var2, KernelTransaction var3, ExecutionContext var4);
    }
}

