/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.description.Description;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.ProcessUtils;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.Race;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.RandomValues;

@TestDirectoryExtension
@ExtendWith(value={RandomExtension.class})
@Timeout(value=20L, unit=TimeUnit.MINUTES)
class ReuseStorageSpaceIT {
    private static final int DATA_SIZE_PER_TRANSACTION = 10;
    private static final int CREATION_THREADS = Runtime.getRuntime().availableProcessors();
    private static final int NUMBER_OF_TRANSACTIONS_PER_THREAD = 100;
    private static final int CUSTOM_EXIT_CODE = 99;
    private static final String[] TOKENS = new String[]{"One", "Two", "Three", "Four", "Five", "Six"};
    @Inject
    private TestDirectory directory;
    @Inject
    private RandomSupport random;

    ReuseStorageSpaceIT() {
    }

    @Test
    void shouldReuseStorageSpaceWhenCreatingDeletingAndRestarting() throws Exception {
        this.shouldReuseStorageSpace(Operation.CREATE_DELETE, Operation.CREATE_DELETE, ReuseStorageSpaceIT::sameProcess);
    }

    @Test
    void shouldReuseStorageSpaceWhenDeletingCreatingAndRestarting() throws Exception {
        this.shouldReuseStorageSpace(Operation.CREATE, Operation.DELETE_CREATE, ReuseStorageSpaceIT::sameProcess);
    }

    @Test
    void shouldReuseStorageSpaceWhenCreatingDeletingAndCrashing() throws Exception {
        this.shouldReuseStorageSpace(Operation.CREATE_DELETE, Operation.CREATE_DELETE, ReuseStorageSpaceIT::crashingChildProcess);
    }

    @Test
    void shouldReuseStorageSpaceWhenDeletingCreatingAndCrashing() throws Exception {
        this.shouldReuseStorageSpace(Operation.CREATE, Operation.DELETE_CREATE, ReuseStorageSpaceIT::crashingChildProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldPrioritizeFreelistWhenConcurrentlyAllocating() throws Exception {
        DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).setConfig(GraphDatabaseInternalSettings.force_small_id_cache, (Object)true).build();
        try {
            GraphDatabaseAPI db = (GraphDatabaseAPI)dbms.database("neo4j");
            int numNodes = 40000;
            MutableLongSet nodeIds = this.createNodes(db, numNodes);
            try (Transaction tx = db.beginTx();){
                nodeIds.forEach((LongProcedure & Serializable)nodeId -> tx.getNodeById(nodeId).delete());
                tx.commit();
            }
            ((IdController)db.getDependencyResolver().resolveDependency(IdController.class)).maintenance();
            int numThreads = 4;
            ArrayList<Callable<MutableLongSet>> allocators = new ArrayList<Callable<MutableLongSet>>();
            for (int i = 0; i < numThreads; ++i) {
                allocators.add(() -> this.createNodes(db, numNodes / numThreads));
            }
            try (ExecutorService executor = Executors.newFixedThreadPool(numThreads);){
                List results = executor.invokeAll(allocators);
                MutableLongSet reallocatedNodeIds = LongSets.mutable.withInitialCapacity(numNodes);
                for (Future result : results) {
                    reallocatedNodeIds.addAll((LongIterable)result.get());
                }
                ((ObjectAssert)Assertions.assertThat((Object)reallocatedNodeIds).as(this.diff(nodeIds, reallocatedNodeIds))).isEqualTo((Object)nodeIds);
            }
        }
        finally {
            dbms.shutdown();
        }
    }

    private Description diff(final MutableLongSet nodeIds, final MutableLongSet reallocatedNodeIds) {
        return new Description(this){

            public String value() {
                StringBuilder builder = new StringBuilder();
                nodeIds.forEach((LongProcedure & Serializable)nodeId -> {
                    if (!reallocatedNodeIds.contains(nodeId)) {
                        builder.append(String.format("%n<%d", nodeId));
                    }
                });
                reallocatedNodeIds.forEach((LongProcedure & Serializable)nodeId -> {
                    if (!nodeIds.contains(nodeId)) {
                        builder.append(String.format("%n>%d", nodeId));
                    }
                });
                return builder.toString();
            }
        };
    }

    private MutableLongSet createNodes(GraphDatabaseAPI db, int numNodes) {
        MutableLongSet nodeIds = LongSets.mutable.withInitialCapacity(numNodes);
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < numNodes; ++i) {
                Node node = tx.createNode();
                nodeIds.add(node.getId());
            }
            tx.commit();
        }
        return nodeIds;
    }

    private void shouldReuseStorageSpace(Operation initialState, Operation operation, Launcher launcher) throws Exception {
        Path storeDirectory = this.directory.homePath();
        long seed = this.random.seed();
        Sizes initialStoreSizes = ReuseStorageSpaceIT.withDb(storeDirectory, (ThrowingConsumer<GraphDatabaseAPI, Exception>)((ThrowingConsumer)db -> initialState.perform((GraphDatabaseAPI)db, seed)));
        int i = 0;
        while (i < 3) {
            Pair<Integer, Sizes> result = launcher.launch(storeDirectory, seed, operation);
            org.junit.jupiter.api.Assertions.assertEquals((int)99, (Integer)((Integer)result.getLeft()));
            Sizes storeFileSizesNow = (Sizes)result.getRight();
            Sizes diff = storeFileSizesNow.diffAgainst(initialStoreSizes);
            long storeFilesDiff = diff.sum();
            int round = i++;
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)storeFilesDiff, () -> String.format("Initial sizes %s%n%nStore sizes after operation (round %d)%s%n%nDiff between the two above %s%n", initialStoreSizes, round, storeFileSizesNow, diff));
        }
    }

    private static Pair<Integer, Sizes> sameProcess(Path storeDirectory, long seed, Operation operation) {
        return Pair.of((Object)99, (Object)ReuseStorageSpaceIT.withDb(storeDirectory, (ThrowingConsumer<GraphDatabaseAPI, Exception>)((ThrowingConsumer)db -> operation.perform((GraphDatabaseAPI)db, seed))));
    }

    private static Pair<Integer, Sizes> crashingChildProcess(Path storeDirectory, long seed, Operation operation) throws Exception {
        Process process = ProcessUtils.start((String[])new String[]{ReuseStorageSpaceIT.class.getCanonicalName(), storeDirectory.toAbsolutePath().toString(), String.valueOf(seed), operation.name()});
        int exitCode = process.waitFor();
        Sizes storeFileSizes = ReuseStorageSpaceIT.withDb(storeDirectory, (ThrowingConsumer<GraphDatabaseAPI, Exception>)((ThrowingConsumer)db -> {}));
        return Pair.of((Object)exitCode, (Object)storeFileSizes);
    }

    public static void main(String[] args) {
        Path storeDirectory = Path.of(args[0], new String[0]).toAbsolutePath();
        long seed = Long.parseLong(args[1]);
        Operation operation = Operation.valueOf(args[2]);
        ReuseStorageSpaceIT.withDb(storeDirectory, (ThrowingConsumer<GraphDatabaseAPI, Exception>)((ThrowingConsumer)db -> {
            operation.perform((GraphDatabaseAPI)db, seed);
            System.exit(99);
        }));
    }

    private static Sizes withDb(Path storeDir, ThrowingConsumer<GraphDatabaseAPI, Exception> transaction) {
        DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilder(storeDir).setConfig(GraphDatabaseInternalSettings.force_small_id_cache, (Object)true).setConfig(GraphDatabaseInternalSettings.strictly_prioritize_id_freelist, (Object)true).setConfig(GraphDatabaseInternalSettings.id_generator_log_enabled, (Object)true).build();
        try {
            GraphDatabaseAPI db = (GraphDatabaseAPI)dbms.database("neo4j");
            transaction.accept((Object)db);
            Sizes sizes = new Sizes(db);
            return sizes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            dbms.shutdown();
        }
    }

    private static void createStuff(GraphDatabaseService db, long seed) {
        Race race = new Race();
        AtomicLong createdNodes = new AtomicLong();
        AtomicLong createdRelationships = new AtomicLong();
        AtomicLong nextSeed = new AtomicLong(seed);
        race.addContestants(CREATION_THREADS, Race.throwing(() -> {
            RandomValues random = RandomValues.create((Random)new Random(nextSeed.getAndIncrement()));
            int nodeCount = 0;
            int relationshipCount = 0;
            for (int t = 0; t < 100; ++t) {
                try (Transaction tx = db.beginTx();){
                    Object[] nodes = new Node[10];
                    for (int n = 0; n < nodes.length; ++n) {
                        nodes[n] = tx.createNode(ReuseStorageSpaceIT.labels((String[])random.selection((Object[])TOKENS, 0, TOKENS.length, false)));
                        Node node = nodes[n];
                        ReuseStorageSpaceIT.setProperties(random, (Entity)node);
                        ++nodeCount;
                    }
                    for (int r = 0; r < nodes.length; ++r) {
                        Relationship relationship = ((Node)random.among(nodes)).createRelationshipTo((Node)random.among(nodes), RelationshipType.withName((String)((String)random.among((Object[])TOKENS))));
                        ReuseStorageSpaceIT.setProperties(random, (Entity)relationship);
                        ++relationshipCount;
                    }
                    tx.commit();
                    continue;
                }
            }
            createdNodes.addAndGet(nodeCount);
            createdRelationships.addAndGet(relationshipCount);
        }), 1);
        race.goUnchecked();
    }

    private static void deleteStuff(GraphDatabaseService db) {
        ReuseStorageSpaceIT.batchedDelete(db, Transaction::getAllRelationships, Entity::delete);
        ReuseStorageSpaceIT.batchedDelete(db, Transaction::getAllNodes, Node::delete);
    }

    private static <ENTITY> void batchedDelete(GraphDatabaseService db, Function<Transaction, ResourceIterable<ENTITY>> provider, Consumer<ENTITY> deleter) {
        int deleted;
        do {
            try (Transaction tx = db.beginTx();
                 ResourceIterable<ENTITY> entities = provider.apply(tx);
                 ResourceIterator iterator = entities.iterator();){
                for (deleted = 0; iterator.hasNext() && deleted < 10000; ++deleted) {
                    Object entity = iterator.next();
                    deleter.accept(entity);
                }
                tx.commit();
            }
        } while (deleted > 0);
    }

    private static void setProperties(RandomValues random, Entity entity) {
        for (String propertyKey : (String[])random.selection((Object[])TOKENS, 0, TOKENS.length, false)) {
            entity.setProperty(propertyKey, random.nextValue().asObject());
        }
    }

    private static Label[] labels(String[] names) {
        Label[] labels = new Label[names.length];
        for (int i = 0; i < names.length; ++i) {
            labels[i] = Label.label((String)names[i]);
        }
        return labels;
    }

    private static enum Operation {
        CREATE{

            @Override
            void perform(GraphDatabaseAPI db, long seed) {
                ReuseStorageSpaceIT.createStuff((GraphDatabaseService)db, seed);
            }
        }
        ,
        CREATE_DELETE{

            @Override
            public void perform(GraphDatabaseAPI db, long seed) {
                ReuseStorageSpaceIT.createStuff((GraphDatabaseService)db, seed);
                ReuseStorageSpaceIT.deleteStuff((GraphDatabaseService)db);
            }
        }
        ,
        DELETE_CREATE{

            @Override
            public void perform(GraphDatabaseAPI db, long seed) throws InterruptedException {
                ReuseStorageSpaceIT.deleteStuff((GraphDatabaseService)db);
                ((IdController)db.getDependencyResolver().resolveDependency(IdController.class)).maintenance();
                ReuseStorageSpaceIT.createStuff((GraphDatabaseService)db, seed);
            }
        };


        abstract void perform(GraphDatabaseAPI var1, long var2) throws Exception;
    }

    static interface Launcher {
        public Pair<Integer, Sizes> launch(Path var1, long var2, Operation var4) throws Exception;
    }

    private static class Sizes {
        private final Map<String, Long> sizes;

        Sizes(GraphDatabaseAPI db) {
            this.sizes = new HashMap<String, Long>();
            IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)db.getDependencyResolver().resolveDependency(IdGeneratorFactory.class);
            idGeneratorFactory.visit(idGenerator -> {
                if (idGenerator.hasOnlySingleIds()) {
                    this.sizes.put(idGenerator.idType().name(), idGenerator.getHighId());
                }
            });
        }

        private Sizes(Map<String, Long> sizes) {
            this.sizes = sizes;
        }

        Sizes diffAgainst(Sizes other) {
            HashMap<String, Long> diff = new HashMap<String, Long>();
            for (Map.Entry<String, Long> entry : this.sizes.entrySet()) {
                long diffSize;
                Long otherSize = other.sizes.get(entry.getKey());
                if (otherSize == null || (diffSize = entry.getValue() - otherSize) == 0L) continue;
                diff.put(entry.getKey(), diffSize);
            }
            return new Sizes(diff);
        }

        public String toString() {
            List nonEmptyEntries = this.sizes.entrySet().stream().filter(e -> (Long)e.getValue() != 0L).sorted(Map.Entry.comparingByKey()).toList();
            long sum = this.sum();
            return String.format("SUM %s(%d):%n%s", ByteUnit.bytesToString((long)sum), sum, StringUtils.join(nonEmptyEntries, (String)String.format("%n", new Object[0])));
        }

        long sum() {
            return this.sum(all -> true);
        }

        long sum(Predicate<String> filter) {
            return this.sizes.entrySet().stream().filter(e -> filter.test((String)e.getKey())).mapToLong(Map.Entry::getValue).sum();
        }
    }
}

