/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointLogSerializationHelper;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
public class CheckpointLogFileRotationIT {
    @Inject
    LogFiles logFiles;

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.checkpoint_logical_log_rotation_threshold, (Object)CheckpointLogSerializationHelper.CONFIG_ROTATION_THRESHOLD).setConfig(GraphDatabaseInternalSettings.checkpoint_logical_log_keep_threshold, (Object)100).setConfig(GraphDatabaseSettings.preallocate_logical_logs, (Object)this.preallocateLogs());
    }

    @Test
    void rotateCheckpointLogFiles() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        CheckpointLogSerializationHelper.fillWithCheckpoints((int)5, (CheckpointAppender)checkpointAppender);
        Object[] matchedFiles = checkpointFile.getMatchedFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(5);
        for (Object fileWithCheckpoints : matchedFiles) {
            Assertions.assertThat((long)fileWithCheckpoints.toFile().length()).isLessThanOrEqualTo(CheckpointLogSerializationHelper.getMaxCheckpointFileSize());
        }
    }

    @Test
    void doNotRotateWhileCheckpointsAreFitting() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        CheckpointLogSerializationHelper.fillWithCheckpoints((int)1, (CheckpointAppender)checkpointAppender);
        Assertions.assertThat((Object[])checkpointFile.getMatchedFiles()).hasSize(1);
        Path logFile = checkpointFile.getMatchedFiles()[0];
        Assertions.assertThat((long)logFile.toFile().length()).isLessThanOrEqualTo(CheckpointLogSerializationHelper.getMaxCheckpointFileSize());
        Assertions.assertThat((long)logFile.toFile().length()).isGreaterThanOrEqualTo(CheckpointLogSerializationHelper.getMaxCheckpointFileSize() - (long)CheckpointLogSerializationHelper.getCheckpointRecordLengthBytes());
    }

    @Test
    void afterRotationNewFileHaveHeader() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        CheckpointLogSerializationHelper.fillWithCheckpoints((int)1, (CheckpointAppender)checkpointAppender);
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, CheckpointLogSerializationHelper.TRANSACTION_ID, CheckpointLogSerializationHelper.TRANSACTION_ID.id() + 77L, LatestVersions.LATEST_KERNEL_VERSION, CheckpointLogSerializationHelper.LOG_POSITION, CheckpointLogSerializationHelper.LOG_POSITION, Instant.now(), "checkpoint for rotation test");
        Object[] matchedFiles = checkpointFile.getMatchedFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(2);
        boolean headerFileFound = false;
        for (Object matchedFile : matchedFiles) {
            if (checkpointFile.getLogVersion((Path)matchedFile) != 1L) continue;
            Assertions.assertThat((File)matchedFile.toFile()).hasSize(this.expectedNewFileSize());
            headerFileFound = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)headerFileFound);
    }

    protected long expectedNewFileSize() {
        return CheckpointLogSerializationHelper.expectedNewCheckpointFileSize();
    }

    protected boolean preallocateLogs() {
        return false;
    }
}

