/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointLogSerializationHelper;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
public class CheckpointLogPruningIT {
    @Inject
    private LogFiles logFiles;
    @Inject
    private CheckPointer checkPointer;

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.checkpoint_logical_log_rotation_threshold, (Object)CheckpointLogSerializationHelper.CONFIG_ROTATION_THRESHOLD).setConfig(GraphDatabaseInternalSettings.checkpoint_logical_log_keep_threshold, (Object)2);
    }

    @Test
    void pruneObsoleteCheckpointLogFiles() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointLogSerializationHelper.fillWithCheckpoints((int)4, (CheckpointAppender)checkpointFile.getCheckpointAppender());
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("checkpoint for rotation test"));
        Object[] matchedFiles = checkpointFile.getMatchedFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(2);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])matchedFiles).areAtLeastOne(CheckpointLogPruningIT.fileNameCondition("checkpoint.3"))).areAtLeastOne(CheckpointLogPruningIT.fileNameCondition("checkpoint.4"));
    }

    @Test
    void doNotPruneFilesUntilConfigured() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointLogSerializationHelper.fillWithCheckpoints((int)1, (CheckpointAppender)checkpointFile.getCheckpointAppender());
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("checkpoint for rotation test"));
        Object[] matchedFiles = checkpointFile.getMatchedFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(2);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])matchedFiles).areAtLeastOne(CheckpointLogPruningIT.fileNameCondition("checkpoint.0"))).areAtLeastOne(CheckpointLogPruningIT.fileNameCondition("checkpoint.1"));
    }

    @Test
    void pruneAsSoonAsHaveAnyEligibleFiles() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointLogSerializationHelper.fillWithCheckpoints((int)2, (CheckpointAppender)checkpointFile.getCheckpointAppender());
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("checkpoint for rotation test"));
        Object[] matchedFiles = checkpointFile.getMatchedFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(2);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])matchedFiles).areAtLeastOne(CheckpointLogPruningIT.fileNameCondition("checkpoint.1"))).areAtLeastOne(CheckpointLogPruningIT.fileNameCondition("checkpoint.2"));
    }

    private static Condition<Path> fileNameCondition(final String name) {
        return new Condition<Path>(){

            public boolean matches(Path file) {
                return name.equals(file.getFileName().toString());
            }
        };
    }
}

