/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.file.Path;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.recovery.RecoveryHelpers;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.SkipOnSpd;
import org.neo4j.test.extension.pagecache.PageCacheExtension;

@PageCacheExtension
@Neo4jLayoutExtension
@SkipOnSpd
public class RecoveryAppendIndexIT {
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private PageCache pageCache;
    @Inject
    private Neo4jLayout neo4jLayout;
    private DatabaseManagementService dbms;
    private DatabaseLayout databaseLayout;

    @BeforeEach
    void setUp() {
        this.databaseLayout = this.neo4jLayout.databaseLayout("neo4j");
    }

    @AfterEach
    void tearDown() {
        if (this.dbms != null) {
            this.dbms.shutdown();
            this.dbms = null;
        }
    }

    @Test
    void restartDatabaseWithCorrectAppendIndex() {
        this.dbms = this.buildDbms();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        RelationshipType marker = RelationshipType.withName((String)"marker");
        for (int i = 0; i < 10; ++i) {
            RecoveryAppendIndexIT.createNodesWithRelationship((GraphDatabaseService)db, marker);
        }
        long lastAppendIndex = ((MetadataProvider)db.getDependencyResolver().resolveDependency(MetadataProvider.class)).getLastAppendIndex();
        this.restartDbms();
        GraphDatabaseAPI restartedDb = (GraphDatabaseAPI)this.dbms.database("neo4j");
        long restartedLastAppendIndex = ((MetadataProvider)restartedDb.getDependencyResolver().resolveDependency(MetadataProvider.class)).getLastAppendIndex();
        Assertions.assertEquals((long)lastAppendIndex, (long)restartedLastAppendIndex);
    }

    @Test
    void recoveredFromTheStartDatabaseWithCorrectAppendIndex() throws IOException {
        this.dbms = this.buildDbms();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        RelationshipType marker = RelationshipType.withName((String)"marker");
        for (int i = 0; i < 10; ++i) {
            RecoveryAppendIndexIT.createNodesWithRelationship((GraphDatabaseService)db, marker);
        }
        long lastAppendIndex = ((MetadataProvider)db.getDependencyResolver().resolveDependency(MetadataProvider.class)).getLastAppendIndex();
        Path[] checkpointFiles = ((LogFiles)db.getDependencyResolver().resolveDependency(LogFiles.class)).getCheckpointFile().getMatchedFiles();
        this.restartDbms();
        for (Path checkpointFile : checkpointFiles) {
            this.fileSystem.deleteFile(checkpointFile);
        }
        GraphDatabaseAPI restartedDb = (GraphDatabaseAPI)this.dbms.database("neo4j");
        long restartedLastAppendIndex = ((MetadataProvider)restartedDb.getDependencyResolver().resolveDependency(MetadataProvider.class)).getLastAppendIndex();
        Assertions.assertEquals((long)lastAppendIndex, (long)restartedLastAppendIndex);
    }

    @Test
    void recoveredAppendIndexFromTheDatabaseWithTransactionsAfterTheLastCheckpoint() throws IOException {
        int i;
        this.dbms = this.buildDbms();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        RelationshipType marker = RelationshipType.withName((String)"marker");
        for (i = 0; i < 10; ++i) {
            RecoveryAppendIndexIT.createNodesWithRelationship((GraphDatabaseService)db, marker);
        }
        ((CheckPointer)db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test checkpoint"));
        for (i = 0; i < 10; ++i) {
            RecoveryAppendIndexIT.createNodesWithRelationship((GraphDatabaseService)db, marker);
        }
        long lastAppendIndex = ((MetadataProvider)db.getDependencyResolver().resolveDependency(MetadataProvider.class)).getLastAppendIndex();
        this.dbms.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.dbms = this.buildDbms();
        GraphDatabaseAPI restartedDb = (GraphDatabaseAPI)this.dbms.database("neo4j");
        long restartedLastAppendIndex = ((MetadataProvider)restartedDb.getDependencyResolver().resolveDependency(MetadataProvider.class)).getLastAppendIndex();
        Assertions.assertEquals((long)lastAppendIndex, (long)restartedLastAppendIndex);
    }

    @Test
    void appliedIndexFromDatabaseWithMissingLogsFiles() throws IOException {
        this.dbms = this.buildDbms();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        RelationshipType marker = RelationshipType.withName((String)"marker");
        for (int i = 0; i < 10; ++i) {
            RecoveryAppendIndexIT.createNodesWithRelationship((GraphDatabaseService)db, marker);
        }
        this.dbms.shutdown();
        this.fileSystem.delete(this.databaseLayout.getTransactionLogsDirectory());
        this.restartDbms();
        GraphDatabaseAPI restartedDb = (GraphDatabaseAPI)this.dbms.database("neo4j");
        long restartedLastAppendIndex = ((MetadataProvider)restartedDb.getDependencyResolver().resolveDependency(MetadataProvider.class)).getLastAppendIndex();
        Assertions.assertEquals((long)1L, (long)restartedLastAppendIndex);
    }

    @Test
    void appliedIndexFromDatabaseWithMissingLogsFilesAndData() throws IOException {
        this.dbms = this.buildDbms();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        RelationshipType marker = RelationshipType.withName((String)"marker");
        for (int i = 0; i < 10; ++i) {
            RecoveryAppendIndexIT.createNodesWithRelationship((GraphDatabaseService)db, marker);
        }
        this.dbms.shutdown();
        this.fileSystem.delete(this.databaseLayout.databaseDirectory());
        this.fileSystem.delete(this.databaseLayout.getTransactionLogsDirectory());
        this.restartDbms();
        GraphDatabaseAPI restartedDb = (GraphDatabaseAPI)this.dbms.database("neo4j");
        long restartedLastAppendIndex = ((MetadataProvider)restartedDb.getDependencyResolver().resolveDependency(MetadataProvider.class)).getLastAppendIndex();
        if ("record".equals(((StorageEngine)restartedDb.getDependencyResolver().resolveDependency(StorageEngine.class)).name())) {
            Assertions.assertEquals((long)3L, (long)restartedLastAppendIndex);
        } else {
            Assertions.assertEquals((long)2L, (long)restartedLastAppendIndex);
        }
    }

    private void restartDbms() {
        this.dbms.shutdown();
        this.dbms = this.buildDbms();
    }

    private static void createNodesWithRelationship(GraphDatabaseService db, RelationshipType marker) {
        try (Transaction transaction = db.beginTx();){
            Node start = transaction.createNode();
            Node end = transaction.createNode();
            start.createRelationshipTo(end, marker);
            transaction.commit();
        }
    }

    DatabaseManagementService buildDbms() {
        return new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(GraphDatabaseSettings.fail_on_missing_files, (Object)false).build();
    }
}

