/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.impl.locking.LockCountVisitor;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.locking.forseti.ForsetiClient;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
public class GraphDatabaseShutdownTest {
    private final OtherThreadExecutor t2 = new OtherThreadExecutor("T2");
    private final OtherThreadExecutor t3 = new OtherThreadExecutor("T3");
    @Inject
    private DatabaseManagementService managementService;
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private LockManager locks;

    @AfterEach
    void tearDown() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.t2, this.t3});
    }

    @Test
    void transactionShouldReleaseLocksWhenGraphDbIsBeingShutdown() {
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)GraphDatabaseShutdownTest.lockCount(this.locks));
        org.junit.jupiter.api.Assertions.assertThrows(TransactionTerminatedException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                Node node = tx.createNode();
                tx.acquireWriteLock((Entity)node);
                Assertions.assertThat((int)GraphDatabaseShutdownTest.lockCount(this.locks)).isGreaterThanOrEqualTo(1);
                this.managementService.shutdown();
                tx.createNode();
                tx.commit();
            }
        });
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.db.isAvailable());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)GraphDatabaseShutdownTest.lockCount(this.locks));
    }

    @Test
    void shouldBeAbleToShutdownWhenThereAreTransactionsWaitingForLocks() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        CountDownLatch nodeLockedLatch = new CountDownLatch(1);
        CountDownLatch shutdownCalled = new CountDownLatch(1);
        Future shutdownFuture = this.t2.executeDontWait(() -> {
            try (Transaction tx = this.db.beginTx();){
                tx.getNodeById(node.getId()).addLabel(Label.label((String)"ABC"));
                nodeLockedLatch.countDown();
                this.t3.waitUntilWaiting(details -> details.isAt(ForsetiClient.class, "acquireExclusive"));
                this.managementService.shutdown();
                shutdownCalled.countDown();
                tx.commit();
            }
            return null;
        });
        Future secondTxResult = this.t3.executeDontWait(() -> {
            try (Transaction tx = this.db.beginTx();){
                nodeLockedLatch.await();
                tx.getNodeById(node.getId()).addLabel(Label.label((String)"DEF"));
                shutdownCalled.await();
                tx.commit();
            }
            return null;
        });
        Assertions.assertThatThrownBy(() -> secondTxResult.get(60L, TimeUnit.SECONDS)).rootCause().isInstanceOfAny(new Class[]{TransactionTerminatedException.class, DatabaseShutdownException.class});
        Assertions.assertThatThrownBy(shutdownFuture::get).rootCause().isInstanceOf(DatabaseShutdownException.class);
    }

    private static int lockCount(LockManager locks) {
        LockCountVisitor lockCountVisitor = new LockCountVisitor();
        locks.accept((LockManager.Visitor)lockCountVisitor);
        return lockCountVisitor.getLockCount();
    }
}

