/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.StringSearchMode;
import org.neo4j.graphdb.TextIndexIT;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
public class RangeIndexStringContainsEnds {
    @Inject
    protected DatabaseLayout databaseLayout;
    private DatabaseManagementService dbms;

    @AfterEach
    void tearDown() {
        if (this.dbms != null) {
            this.dbms.shutdown();
        }
    }

    @Test
    void shouldFindNodesUsingRangeIndexIfNoTextIndex() {
        Label person = Label.label((String)"PERSON");
        TextIndexIT.IndexAccessMonitor monitor = new TextIndexIT.IndexAccessMonitor();
        this.dbms = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setMonitors(monitor.monitors()).build();
        GraphDatabaseService db = this.dbms.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.schema().indexFor(person).on("name").withIndexType(IndexType.RANGE).create();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.createNode(new Label[]{person}).setProperty("name", (Object)"David Smith Adams");
            tx.createNode(new Label[]{person}).setProperty("name", (Object)"Smith Evans");
            tx.createNode(new Label[]{person}).setProperty("name", (Object)"Smith James");
            tx.createNode(new Label[]{person}).setProperty("name", (Object)"Luke Smith");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        monitor.reset();
        tx = db.beginTx();
        try {
            Assertions.assertThat((long)Iterators.count((Iterator)tx.findNodes(person, "name", "Smith", StringSearchMode.CONTAINS))).isEqualTo(4L);
            Assertions.assertThat((long)Iterators.count((Iterator)tx.findNodes(person, "name", "Unknown", StringSearchMode.CONTAINS))).isEqualTo(0L);
            Assertions.assertThat((long)Iterators.count((Iterator)tx.findNodes(person, "name", "Smith", StringSearchMode.PREFIX))).isEqualTo(2L);
            Assertions.assertThat((long)Iterators.count((Iterator)tx.findNodes(person, "name", "Smith", StringSearchMode.SUFFIX))).isEqualTo(1L);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Assertions.assertThat((int)monitor.accessed(org.neo4j.internal.schema.IndexType.RANGE)).isEqualTo(4);
        this.dbms.shutdown();
    }

    @Test
    void shouldFindRelationshipsUsingRangeIndexIfNoTextIndex() {
        Label person = Label.label((String)"PERSON");
        RelationshipType relation = RelationshipType.withName((String)"FRIEND");
        TextIndexIT.IndexAccessMonitor monitor = new TextIndexIT.IndexAccessMonitor();
        this.dbms = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setMonitors(monitor.monitors()).build();
        GraphDatabaseService db = this.dbms.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.schema().indexFor(relation).on("since").withIndexType(IndexType.RANGE).create();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.createNode(new Label[]{person}).createRelationshipTo(tx.createNode(new Label[]{person}), relation).setProperty("since", (Object)"two years");
            tx.createNode(new Label[]{person}).createRelationshipTo(tx.createNode(new Label[]{person}), relation).setProperty("since", (Object)"five years, two months");
            tx.createNode(new Label[]{person}).createRelationshipTo(tx.createNode(new Label[]{person}), relation).setProperty("since", (Object)"three months");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        monitor.reset();
        tx = db.beginTx();
        try {
            Assertions.assertThat((long)Iterators.count((Iterator)tx.findRelationships(relation, "since", "years", StringSearchMode.CONTAINS))).isEqualTo(2L);
            Assertions.assertThat((long)Iterators.count((Iterator)tx.findRelationships(relation, "since", "unknown", StringSearchMode.CONTAINS))).isEqualTo(0L);
            Assertions.assertThat((long)Iterators.count((Iterator)tx.findRelationships(relation, "since", "five", StringSearchMode.PREFIX))).isEqualTo(1L);
            Assertions.assertThat((long)Iterators.count((Iterator)tx.findRelationships(relation, "since", "months", StringSearchMode.SUFFIX))).isEqualTo(2L);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Assertions.assertThat((int)monitor.accessed(org.neo4j.internal.schema.IndexType.RANGE)).isEqualTo(4);
        this.dbms.shutdown();
    }
}

