/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.net.InetAddress;
import java.net.URI;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.LabelsSupplier;
import org.neo4j.internal.kernel.api.RelTypeSupplier;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.PermissionState;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SelectedPropertiesProvider;
import org.neo4j.storageengine.api.PropertySelection;

public class TestAccessMode
implements AccessMode {
    private final boolean allowRead;
    private final boolean allowReadAll;
    private final boolean allowWrite;
    private final boolean allowSchema;
    private final boolean allowLoad;

    public TestAccessMode(boolean allowRead, boolean allowReadAll, boolean allowWrite, boolean allowSchema, boolean allowLoad) {
        this.allowRead = allowRead;
        this.allowReadAll = allowReadAll;
        this.allowWrite = allowWrite;
        this.allowSchema = allowSchema;
        this.allowLoad = allowLoad;
    }

    public boolean allowsWrites() {
        return this.allowWrite;
    }

    public PermissionState allowsTokenCreates(PrivilegeAction action) {
        return PermissionState.fromAllowList((boolean)this.allowWrite);
    }

    public boolean allowsSchemaWrites() {
        return this.allowSchema;
    }

    public PermissionState allowsSchemaWrites(PrivilegeAction action) {
        return PermissionState.fromAllowList((boolean)this.allowSchema);
    }

    public boolean allowsShowIndex() {
        return this.allowSchema;
    }

    public boolean allowsShowConstraint() {
        return this.allowSchema;
    }

    public boolean allowsTraverseAllLabels() {
        return this.allowReadAll;
    }

    public boolean allowsTraverseAllNodesWithLabel(int label) {
        return this.allowReadAll;
    }

    public boolean disallowsTraverseLabel(int label) {
        return !this.allowRead;
    }

    public boolean allowsTraverseNode(int ... labels) {
        return this.allowRead;
    }

    public boolean hasApplicableTraverseNodeAllowPropertyRules(int label) {
        return this.allowRead;
    }

    public boolean allowsTraverseNode(LabelsSupplier labels, SelectedPropertiesProvider selectedPropertiesProvider) {
        return this.allowRead;
    }

    public boolean allowsTraverseAllRelTypes() {
        return this.allowReadAll;
    }

    public boolean allowsTraverseRelType(int relType) {
        return this.allowRead;
    }

    public boolean allowsTraverseAllRelsWithType(int relType) {
        return this.allowRead;
    }

    public boolean disallowsTraverseRelType(int relType) {
        return !this.allowRead;
    }

    public boolean hasApplicableTraverseRelAllowPropertyRules(int type) {
        return this.allowRead;
    }

    public boolean allowsTraverseRelationship(int type, SelectedPropertiesProvider propertyProviderSupplier) {
        return this.allowRead;
    }

    public boolean allowsReadNodeProperties(LabelsSupplier labels, int[] propertyKeys, Supplier<SelectedPropertiesProvider> propertyProvider) {
        return this.allowRead;
    }

    public IntPredicate allowedToReadNodeProperties(LabelsSupplier labels, Supplier<SelectedPropertiesProvider> propertyProvider, PropertySelection selection) {
        return key -> this.allowRead;
    }

    public boolean allowsTraverseAndReadAllMatchingNodeProperties(int[] labels, int[] propertyKeys) {
        return this.allowRead;
    }

    public boolean allowsTraverseAndReadAllMatchingRelProperties(int[] relTypes, int[] propertyKeys) {
        return this.allowRead;
    }

    public boolean allowsReadRelProperties(RelTypeSupplier relType, int[] propertyKeys, Supplier<SelectedPropertiesProvider> propertyProvider) {
        return this.allowRead;
    }

    public IntPredicate allowedToReadRelationshipProperties(RelTypeSupplier relType, Supplier<SelectedPropertiesProvider> propertyProvider, PropertySelection selection) {
        return key -> this.allowRead;
    }

    public boolean allowsSeePropertyKeyToken(int propertyKey) {
        return this.allowRead;
    }

    public PermissionState allowsExecuteProcedure(int procedureId) {
        return PermissionState.EXPLICIT_GRANT;
    }

    public PermissionState allowExecuteAdminProcedures() {
        return PermissionState.EXPLICIT_GRANT;
    }

    public PermissionState shouldBoostProcedure(int procedureId) {
        return PermissionState.EXPLICIT_GRANT;
    }

    public PermissionState allowsExecuteFunction(int id) {
        return PermissionState.EXPLICIT_GRANT;
    }

    public PermissionState shouldBoostFunction(int id) {
        return PermissionState.EXPLICIT_GRANT;
    }

    public PermissionState allowsExecuteAggregatingFunction(int id) {
        return PermissionState.EXPLICIT_GRANT;
    }

    public PermissionState shouldBoostAggregatingFunction(int id) {
        return PermissionState.EXPLICIT_GRANT;
    }

    public PermissionState allowsShowSetting(String setting) {
        return PermissionState.EXPLICIT_GRANT;
    }

    public boolean allowsSetLabel(int labelId) {
        return this.allowWrite;
    }

    public boolean allowsRemoveLabel(int labelId) {
        return this.allowWrite;
    }

    public boolean allowsCreateNode(int[] labelIds) {
        return this.allowWrite;
    }

    public boolean allowsDeleteNode(Supplier<TokenSet> labelSupplier) {
        return this.allowWrite;
    }

    public boolean allowsCreateRelationship(int relType) {
        return this.allowWrite;
    }

    public boolean allowsDeleteRelationship(int relType) {
        return this.allowWrite;
    }

    public boolean allowsSetProperty(LabelsSupplier labels, int propertyKey) {
        return this.allowWrite;
    }

    public boolean allowsSetProperty(RelTypeSupplier relType, int propertyKey) {
        return this.allowWrite;
    }

    public PermissionState allowsLoadAllData() {
        return PermissionState.fromAllowList((boolean)this.allowLoad);
    }

    public PermissionState allowsLoadUri(URI url, InetAddress inetAddress) {
        return PermissionState.fromAllowList((boolean)this.allowLoad);
    }

    public String name() {
        return "Test";
    }
}

