/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.io.IOException;
import java.util.Iterator;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.api.DatabaseSizeServiceAvailableReservedSizeITBase;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.format.RecordFormats;

public abstract class RecordFormatDatabaseSizeServiceAvailableReservedSizeIT
extends DatabaseSizeServiceAvailableReservedSizeITBase {
    private NeoStores stores;

    @BeforeEach
    void getNeoStore() {
        this.stores = this.get(RecordStorageEngine.class).testAccessNeoStores();
    }

    protected RecordFormatDatabaseSizeServiceAvailableReservedSizeIT(RecordFormats recordFormats) {
        super(recordFormats.name());
    }

    @Test
    void shouldAccountForDeletedNodes() throws IOException {
        int nodeCount = 1000;
        try (Transaction tx2 = this.db.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                tx2.createNode(new Label[]{NODE_LABEL});
            }
            tx2.commit();
        }
        this.assertAvailableReservedSpaceChanged(tx -> {
            int deletedNodes = 0;
            for (Node node : tx.getAllNodes()) {
                deletedNodes += this.countDeletions(0.1, (Entity)node);
            }
            return (long)deletedNodes * this.nodeRecordSize();
        });
    }

    @Test
    void shouldAccountForDeletedRelationships() throws IOException {
        int relCount = 1000;
        try (Transaction tx2 = this.db.beginTx();){
            Node a = tx2.createNode(new Label[]{NODE_LABEL});
            Node b = tx2.createNode(new Label[]{NODE_LABEL});
            for (int i = 0; i < 1000; ++i) {
                a.createRelationshipTo(b, REL_TYPE);
            }
            tx2.commit();
        }
        this.assertAvailableReservedSpaceChanged(tx -> {
            Node node = tx.getNodeById(0L);
            int deletedRels = 0;
            for (Relationship rel : node.getRelationships()) {
                deletedRels += this.countDeletions(0.1, (Entity)rel);
            }
            return (long)deletedRels * this.relationshipRecordSize();
        });
    }

    @Test
    void shouldAccountForDeletedDenseNodeRelationships() throws IOException {
        RelationshipType type1 = RelationshipType.withName((String)"TYPE1");
        RelationshipType type2 = RelationshipType.withName((String)"TYPE2");
        int relCount = 1000;
        try (Transaction tx2 = this.db.beginTx();){
            Node a = tx2.createNode(new Label[]{NODE_LABEL});
            Node b = tx2.createNode(new Label[]{NODE_LABEL});
            for (int i = 0; i < 1000; ++i) {
                a.createRelationshipTo(b, i % 2 == 0 ? type1 : type2);
            }
            tx2.commit();
        }
        this.assertAvailableReservedSpaceChanged(tx -> {
            Node node = tx.getNodeById(0L);
            for (Relationship rel : node.getRelationships()) {
                rel.delete();
            }
            int relationshipTypes = 2;
            int relationshipGroups = 4;
            return 1000L * this.relationshipRecordSize() + 4L * this.relationshipGroupRecordSize();
        });
    }

    @Test
    void shouldAccountForDeletedLoopRelationships() throws IOException {
        int relCount = 1000;
        try (Transaction tx2 = this.db.beginTx();){
            Node a = tx2.createNode(new Label[]{NODE_LABEL});
            for (int i = 0; i < 1000; ++i) {
                a.createRelationshipTo(a, REL_TYPE);
            }
            tx2.commit();
        }
        this.assertAvailableReservedSpaceChanged(tx -> {
            Node node = tx.getNodeById(0L);
            int deletedRels = 0;
            for (Relationship rel : node.getRelationships()) {
                deletedRels += this.countDeletions(0.1, (Entity)rel);
            }
            return (long)deletedRels * this.relationshipRecordSize();
        });
    }

    @Test
    void shouldAccountForDeletedNodeIntProperties() throws IOException {
        this.shouldAccountForDeletedNodeProperties(1337, 0L);
    }

    @Test
    void shouldAccountForDeletedNodeStringProperties() throws IOException {
        String string = this.random.nextAlphaNumericString(128, 256);
        long dynamicBlocksPerString = this.requiredDynamicBlocksFor(string);
        this.shouldAccountForDeletedNodeProperties(string, dynamicBlocksPerString * this.dynamicStringRecordBlockSize());
    }

    private void shouldAccountForDeletedNodeProperties(Object propertyValue, long expectedFreedDynamicStoreBytes) throws IOException {
        long propCount = 25L * this.blocksPerPropertyRecord() + 1L;
        try (Transaction tx2 = this.db.beginTx();){
            Node node = tx2.createNode(new Label[]{NODE_LABEL});
            int i = 0;
            while ((long)i < propCount) {
                node.setProperty("property" + i, propertyValue);
                ++i;
            }
            tx2.commit();
        }
        this.assertAvailableReservedSpaceChanged(tx -> {
            Node node = tx.getNodeById(0L);
            int deletedPropRecords = 0;
            int deletedProps = 0;
            Iterator it = node.getPropertyKeys().iterator();
            while (it.hasNext()) {
                boolean lastRecordHadSingleProperty;
                boolean deleteWholeRecord = this.random.nextBoolean();
                boolean first = true;
                int i = 0;
                while ((long)i < this.blocksPerPropertyRecord() && it.hasNext()) {
                    String key = (String)it.next();
                    if (first || deleteWholeRecord) {
                        ++deletedProps;
                        node.removeProperty(key);
                        first = false;
                    }
                    ++i;
                }
                boolean bl = lastRecordHadSingleProperty = i == 1;
                if (!deleteWholeRecord && !lastRecordHadSingleProperty) continue;
                ++deletedPropRecords;
            }
            long freedPropRecordBytes = (long)deletedPropRecords * this.propertyRecordSize();
            long freedDynamicRecordBytes = (long)deletedProps * expectedFreedDynamicStoreBytes;
            return freedPropRecordBytes + freedDynamicRecordBytes;
        });
    }

    @Test
    void shouldAccountForLabelsRemovedFromHeavyNode() throws IOException {
        int labelCount = 165;
        try (Transaction tx2 = this.db.beginTx();){
            Node node = tx2.createNode();
            for (int i = 0; i < 165; ++i) {
                node.addLabel(Label.label((String)("Label" + i)));
            }
            tx2.commit();
        }
        this.assertAvailableReservedSpaceChanged(tx -> {
            Node node = tx.getNodeById(0L);
            long[] labelIds = new long[166];
            labelIds[0] = node.getId();
            int i = 1;
            for (Label label : node.getLabels()) {
                InternalTransaction itx = (InternalTransaction)tx;
                labelIds[i++] = itx.kernelTransaction().tokenRead().nodeLabel(label.name());
                node.removeLabel(label);
            }
            return this.requiredDynamicBlocksFor(labelIds) * this.dynamicLabelRecordBlockSize();
        });
    }

    long requiredDynamicBlocksFor(String str) {
        byte[] encoded = PropertyStore.encodeString((String)str);
        return Math.ceilDiv((long)encoded.length, this.dynamicStringRecordDataSize());
    }

    long requiredDynamicBlocksFor(long[] labelIds) {
        int requiredBytes = 3 + Math.ceilDiv(ShortArray.LONG.calculateRequiredBitsForArray((Object)labelIds, labelIds.length) * labelIds.length, 8);
        return Math.ceilDiv((long)requiredBytes, this.dynamicLabelRecordDataSize());
    }

    long nodeRecordSize() {
        return this.stores.getNodeStore().getRecordSize();
    }

    long propertyRecordSize() {
        return this.stores.getPropertyStore().getRecordSize();
    }

    long blocksPerPropertyRecord() {
        return 4L;
    }

    long relationshipRecordSize() {
        return this.stores.getRelationshipStore().getRecordSize();
    }

    long relationshipGroupRecordSize() {
        return this.stores.getRelationshipGroupStore().getRecordSize();
    }

    long dynamicStringRecordBlockSize() {
        return this.stores.getPropertyStore().getStringStore().getRecordSize();
    }

    long dynamicStringRecordDataSize() {
        return this.stores.getPropertyStore().getStringStore().getRecordDataSize();
    }

    long dynamicLabelRecordBlockSize() {
        return this.stores.getNodeStore().getDynamicLabelStore().getRecordSize();
    }

    long dynamicLabelRecordDataSize() {
        return this.stores.getNodeStore().getDynamicLabelStore().getRecordDataSize();
    }

    int countDeletions(double probability, Entity entity) {
        return this.random.withProbability(probability, () -> ((Entity)entity).delete()) ? 1 : 0;
    }
}

