/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.index.IndexAccessorCompatibility;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.index.PropertyIndexProviderCompatibilityTestSuite;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

abstract class SimpleRandomizedIndexAccessorCompatibility
extends IndexAccessorCompatibility {
    SimpleRandomizedIndexAccessorCompatibility(PropertyIndexProviderCompatibilityTestSuite testSuite) {
        super(testSuite, testSuite.indexPrototype());
    }

    @Test
    void testExactMatchOnRandomValues() throws Exception {
        ValueType[] types = this.randomSetOfSupportedTypes();
        List<Value> values = this.generateValuesFromType(types, new HashSet<Value>(), 30000);
        List<ValueIndexEntryUpdate> updates = this.generateUpdatesFromValues(values, new MutableLong());
        this.updateAndCommit(updates);
        for (ValueIndexEntryUpdate update : updates) {
            List<Long> hits = this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)update.values()[0])});
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)hits.size(), (String)hits.toString());
            Assertions.assertThat((Long)((Long)Iterables.single(hits))).isEqualTo(update.getEntityId());
        }
    }

    @Test
    void testRangeMatchInOrderOnRandomValues() throws Exception {
        Assumptions.assumeTrue((boolean)this.testSuite.supportsGranularCompositeQueries(), (String)"Assume support for granular composite queries");
        ValueType[] types = this.randomSetOfSupportedAndSortableTypes();
        HashSet<Value> uniqueValues = new HashSet<Value>();
        TreeSet<ValueAndId> sortedValues = new TreeSet<ValueAndId>((v1, v2) -> Values.COMPARATOR.compare(v1.value, v2.value));
        MutableLong nextId = new MutableLong();
        for (int i = 0; i < 5; ++i) {
            List<ValueIndexEntryUpdate> updates = new ArrayList<ValueIndexEntryUpdate>();
            if (i == 0) {
                updates = this.generateUpdatesFromValues(this.generateValuesFromType(types, uniqueValues, 20000), nextId);
                sortedValues.addAll(updates.stream().map(u -> new ValueAndId(u.values()[0], u.getEntityId())).toList());
            } else {
                for (int j = 0; j < 1000; ++j) {
                    ValueAndId existing;
                    int type = this.random.intBetween(0, 2);
                    if (type == 0) {
                        Value value = this.generateUniqueRandomValue(types, uniqueValues);
                        if (value == null) continue;
                        long id = nextId.getAndIncrement();
                        sortedValues.add(new ValueAndId(value, id));
                        updates.add(IndexQueryHelper.add((long)id, (IndexDescriptor)this.descriptor, (Object[])new Object[]{value}));
                        continue;
                    }
                    if (type == 1) {
                        existing = (ValueAndId)this.random.among((Object[])sortedValues.toArray(new ValueAndId[0]));
                        Value newValue = this.generateUniqueRandomValue(types, uniqueValues);
                        if (newValue == null) continue;
                        sortedValues.remove(existing);
                        uniqueValues.remove(existing.value);
                        sortedValues.add(new ValueAndId(newValue, existing.id));
                        updates.add(IndexEntryUpdate.change((long)existing.id, (IndexDescriptor)this.descriptor, (Value)existing.value, (Value)newValue));
                        continue;
                    }
                    existing = (ValueAndId)this.random.among((Object[])sortedValues.toArray(new ValueAndId[0]));
                    sortedValues.remove(existing);
                    uniqueValues.remove(existing.value);
                    updates.add(IndexQueryHelper.remove((long)existing.id, (IndexDescriptor)this.descriptor, (Object[])new Object[]{existing.value}));
                }
            }
            this.updateAndCommit(updates);
            this.verifyRandomRanges(types, sortedValues);
        }
    }

    private void verifyRandomRanges(ValueType[] types, TreeSet<ValueAndId> sortedValues) throws Exception {
        for (int i = 0; i < 100; ++i) {
            Value to;
            ValueType type = (ValueType)this.random.among((Object[])types);
            Value from = this.random.randomValues().nextValueOfType(type);
            if (Values.COMPARATOR.compare(from, to = this.random.randomValues().nextValueOfType(type)) > 0) {
                Value tmp = from;
                from = to;
                to = tmp;
            }
            boolean fromInclusive = this.random.nextBoolean();
            boolean toInclusive = this.random.nextBoolean();
            PropertyIndexQuery.RangePredicate predicate = PropertyIndexQuery.range((int)0, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive);
            List<Long> expectedIds = SimpleRandomizedIndexAccessorCompatibility.expectedIds(sortedValues, from, to, fromInclusive, toInclusive);
            if (!this.descriptor.getCapability().supportsOrdering()) continue;
            List<Long> actualIds = this.assertInOrder(IndexOrder.ASCENDING, new PropertyIndexQuery[]{predicate});
            actualIds.sort(Long::compare);
            Assertions.assertThat(actualIds).isEqualTo(expectedIds);
            actualIds = this.assertInOrder(IndexOrder.DESCENDING, new PropertyIndexQuery[]{predicate});
            actualIds.sort(Long::compare);
            Assertions.assertThat(actualIds).isEqualTo(expectedIds);
        }
    }

    private static List<Long> expectedIds(TreeSet<ValueAndId> sortedValues, Value from, Value to, boolean fromInclusive, boolean toInclusive) {
        return sortedValues.subSet(new ValueAndId(from, 0L), fromInclusive, new ValueAndId(to, 0L), toInclusive).stream().map(v -> v.id).sorted(Long::compare).collect(Collectors.toList());
    }

    private List<Value> generateValuesFromType(ValueType[] types, Set<Value> duplicateChecker, int count) {
        ArrayList<Value> values = new ArrayList<Value>();
        for (long i = 0L; i < (long)count; ++i) {
            Value value = this.generateUniqueRandomValue(types, duplicateChecker);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    private Value generateUniqueRandomValue(ValueType[] types, Set<Value> duplicateChecker) {
        Value value;
        long maxTries = 0L;
        do {
            value = this.random.randomValues().nextValueOfTypes(types);
            if (maxTries++ != 1000L) continue;
            return null;
        } while (!duplicateChecker.add(value));
        return value;
    }

    private List<ValueIndexEntryUpdate> generateUpdatesFromValues(List<Value> values, MutableLong nextId) {
        ArrayList<ValueIndexEntryUpdate> updates = new ArrayList<ValueIndexEntryUpdate>();
        for (Value value : values) {
            ValueIndexEntryUpdate update = IndexQueryHelper.add((long)nextId.getAndIncrement(), (IndexDescriptor)this.descriptor, (Object[])new Object[]{value});
            updates.add(update);
        }
        return updates;
    }

    private static class ValueAndId {
        private final Value value;
        private final long id;

        ValueAndId(Value value, long id) {
            this.value = value;
            this.id = id;
        }
    }
}

