/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.TxLogValidationUtils;
import org.neo4j.kernel.database.TransactionLogsUpgradeIT;
import org.neo4j.kernel.impl.api.tracer.DefaultDatabaseTracer;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.LogSegments;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.recovery.RecoveryHelpers;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.UpgradeTestUtil;
import org.neo4j.test.extension.SkipOnSpd;

@SkipOnSpd(reason="The transaction stream looks different in SPD")
class TransactionLogsUpgradeFromNonEnvelopesIT
extends TransactionLogsUpgradeIT {
    TransactionLogsUpgradeFromNonEnvelopesIT() {
    }

    @Override
    protected TestDatabaseManagementServiceBuilder configureStartUp(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)((long)LogSegments.DEFAULT_LOG_SEGMENT_SIZE * 3L));
        builder.setConfig(GraphDatabaseInternalSettings.latest_kernel_version, (Object)LatestVersions.LATEST_KERNEL_VERSION_WITHOUT_ENVELOPES.version());
        builder.setConfig(GraphDatabaseInternalSettings.latest_runtime_version, (Object)LatestVersions.LATEST_RUNTIME_VERSION_WITHOUT_ENVELOPES.getVersion());
        return builder;
    }

    @Override
    protected KernelVersion headerVersionForStartingVersion() {
        return null;
    }

    @Override
    protected KernelVersion startingKernelVersion() {
        return LatestVersions.LATEST_KERNEL_VERSION_WITHOUT_ENVELOPES;
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void canFindNextLogFileIfHaveFileWithJustHeader(boolean useQueueAppender) throws Throwable {
        DefaultDatabaseTracer defaultDatabaseTracer = (DefaultDatabaseTracer)this.testDb.getDependencyResolver().resolveDependency(DefaultDatabaseTracer.class);
        while ((double)defaultDatabaseTracer.appendedBytes() < (double)LogSegments.DEFAULT_LOG_SEGMENT_SIZE * 2.2) {
            UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)this.testDb);
        }
        Assertions.assertThat((long)defaultDatabaseTracer.numberOfLogRotations()).isEqualTo(0L);
        long nodeCountBeforeTxTriggeringUpgrade = this.getNodeCount(this.testDb);
        long lastClosedTransactionIdBeforeUpgrade = ((TransactionIdStore)this.testDb.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
        this.shutdownDbms();
        this.startDbms(builder -> this.configureGloriousFutureAsLatest(builder).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)((long)LogSegments.DEFAULT_LOG_SEGMENT_SIZE * 2L)).setConfig(GraphDatabaseInternalSettings.dedicated_transaction_appender, (Object)useQueueAppender));
        UpgradeTestUtil.upgradeDatabase((DatabaseManagementService)this.managementService, (GraphDatabaseAPI)this.testDb, (KernelVersion)this.startingKernelVersion(), (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        DatabaseLayout dbLayout = this.testDb.databaseLayout();
        DefaultDatabaseTracer tracer = (DefaultDatabaseTracer)((GraphDatabaseAPI)this.managementService.database("neo4j")).getDependencyResolver().resolveDependency(DefaultDatabaseTracer.class);
        Assertions.assertThat((long)tracer.numberOfLogRotations()).isEqualTo(2L);
        this.shutdownDbms();
        Config config = Config.newBuilder().set(GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.GLORIOUS_FUTURE.version()).build();
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem, (Config)config);
        Assertions.assertThat((Comparable)RecoveryHelpers.getLatestCheckpoint((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem, (Config)config).kernelVersion()).isEqualTo((Object)this.startingKernelVersion());
        this.startDbms(builder -> this.configureGloriousFutureAsLatest(builder).setConfig(GraphDatabaseInternalSettings.dedicated_transaction_appender, (Object)useQueueAppender));
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.testDb, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        Assertions.assertThat((long)this.getNodeCount(this.testDb)).isEqualTo(nodeCountBeforeTxTriggeringUpgrade + 1L);
        LogFiles logFiles = (LogFiles)this.testDb.getDependencyResolver().resolveDependency(LogFiles.class);
        TxLogValidationUtils.assertLogHeaderExpectedVersion((FileSystemAbstraction)this.fileSystem, (LogFiles)logFiles, (long)0L, (KernelVersion)this.headerVersionForStartingVersion(), (long)1L);
        TxLogValidationUtils.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion((LogFile)logFiles.getLogFile(), (long)0L, (KernelVersion)this.startingKernelVersion(), (int)((int)(lastClosedTransactionIdBeforeUpgrade + 1L - 1L)), (CommandReaderFactory)this.commandReaderFactory);
        TxLogValidationUtils.assertLogHeaderExpectedVersion((FileSystemAbstraction)this.fileSystem, (LogFiles)logFiles, (long)1L, (KernelVersion)this.headerVersionForStartingVersion(), (long)(lastClosedTransactionIdBeforeUpgrade + 1L));
        Assertions.assertThat((long)this.fileSystem.getFileSize(logFiles.getLogFile().getLogFileForVersion(1L))).isEqualTo((long)LogFormat.fromKernelVersion((KernelVersion)this.startingKernelVersion()).getHeaderSize());
        TxLogValidationUtils.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion((LogFile)logFiles.getLogFile(), (long)1L, (KernelVersion)this.startingKernelVersion(), (int)0, (CommandReaderFactory)this.commandReaderFactory);
        TxLogValidationUtils.assertLogHeaderExpectedVersion((FileSystemAbstraction)this.fileSystem, (LogFiles)logFiles, (long)2L, (KernelVersion)KernelVersion.GLORIOUS_FUTURE, (long)(lastClosedTransactionIdBeforeUpgrade + 1L));
        TxLogValidationUtils.assertWholeTransactionsWithCorrectVersionInSpecificLogVersion((LogFile)logFiles.getLogFile(), (long)2L, (KernelVersion)KernelVersion.GLORIOUS_FUTURE, (int)1, (CommandReaderFactory)this.commandReaderFactory);
    }

    @Test
    void shouldReadOverFormatSwitch() throws Exception {
        this.shutdownDbms();
        this.startDbms(this::configureGloriousFutureAsLatest);
        UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)this.testDb);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.testDb, (KernelVersion)this.startingKernelVersion());
        UpgradeTestUtil.upgradeDatabase((DatabaseManagementService)this.managementService, (GraphDatabaseAPI)this.testDb, (KernelVersion)this.startingKernelVersion(), (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)this.testDb);
        LogFiles logFiles = (LogFiles)this.testDb.getDependencyResolver().resolveDependency(LogFiles.class);
        Assertions.assertThat((int)TxLogValidationUtils.assertWholeTransactionsIn((LogFile)logFiles.getLogFile(), (long)0L, startEntry -> {}, commitEntry -> {}, (CommandReaderFactory)this.commandReaderFactory, (LogVersionBridge)ReaderLogVersionBridge.forFile((LogFile)logFiles.getLogFile()))).isBetween(Integer.valueOf(5), Integer.valueOf(6));
    }
}

