/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
abstract class RelationshipReadOperationsTest {
    private final String PROPERTY_KEY = "PROPERTY_KEY";
    @Inject
    static GraphDatabaseAPI db;

    RelationshipReadOperationsTest() {
    }

    @Test
    void testElementId() {
        String relId;
        RelationshipType type = RelationshipType.withName((String)"type-1");
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode();
            relId = node.createRelationshipTo(node, type).getElementId();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            Relationship rel = this.lookupRelationship(tx, relId);
            Assertions.assertThat((String)rel.getElementId()).isEqualTo(relId);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void testTypeLookup() {
        String relId;
        RelationshipType type = RelationshipType.withName((String)"type-1");
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode();
            relId = node.createRelationshipTo(node, type).getElementId();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            Relationship rel = this.lookupRelationship(tx, relId);
            Assertions.assertThat((Object)rel.getType()).isEqualTo((Object)type);
            Assertions.assertThat((boolean)rel.isType(type)).isTrue();
            Assertions.assertThat((boolean)rel.isType(RelationshipType.withName((String)"another"))).isFalse();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void testNodeLookup() {
        String relId;
        String node2Id;
        String node1Id;
        try (Transaction tx = db.beginTx();){
            Node node1 = tx.createNode();
            node1Id = node1.getElementId();
            Node node2 = tx.createNode();
            node2Id = node2.getElementId();
            relId = node1.createRelationshipTo(node2, RelationshipType.withName((String)"type-1")).getElementId();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            Relationship rel = this.lookupRelationship(tx, relId);
            Assertions.assertThat((String)rel.getStartNode().getElementId()).isEqualTo(node1Id);
            Assertions.assertThat((String)rel.getEndNode().getElementId()).isEqualTo(node2Id);
            Assertions.assertThat((Object[])rel.getNodes()).containsExactlyInAnyOrder((Object[])new Node[]{rel.getStartNode(), rel.getEndNode()});
            Assertions.assertThat((String)rel.getOtherNode(rel.getStartNode()).getElementId()).isEqualTo(node2Id);
            Assertions.assertThat((String)rel.getOtherNode(rel.getEndNode()).getElementId()).isEqualTo(node1Id);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void testPropertyLookup() {
        String relId;
        String prop1 = "prop1";
        String value1 = "value1";
        String prop2 = "prop2";
        String value2 = "value2";
        String prop3 = "prop3";
        String value3 = "value3";
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode();
            Relationship rel = node.createRelationshipTo(node, RelationshipType.withName((String)"type-1"));
            relId = rel.getElementId();
            rel.setProperty(prop1, (Object)value1);
            rel.setProperty(prop2, (Object)value2);
            rel.setProperty(prop3, (Object)value3);
            tx.commit();
        }
        tx = db.beginTx();
        try {
            Relationship rel = this.lookupRelationship(tx, relId);
            Assertions.assertThat((Map)rel.getAllProperties()).containsExactlyInAnyOrderEntriesOf(Map.of(prop1, value1, prop2, value2, prop3, value3));
            Assertions.assertThat((Map)rel.getProperties(new String[]{prop1, prop3})).containsExactlyInAnyOrderEntriesOf(Map.of(prop1, value1, prop3, value3));
            Assertions.assertThat((Map)rel.getProperties(new String[]{prop1, "another", prop3})).containsExactlyInAnyOrderEntriesOf(Map.of(prop1, value1, prop3, value3));
            Assertions.assertThat((Object)rel.getProperty(prop1)).isEqualTo((Object)value1);
            Assertions.assertThat((Object)rel.getProperty(prop1, (Object)"default value")).isEqualTo((Object)value1);
            Assertions.assertThat((Object)rel.getProperty("another", (Object)"default value")).isEqualTo((Object)"default value");
            Assertions.assertThat((boolean)rel.hasProperty(prop1)).isTrue();
            Assertions.assertThat((boolean)rel.hasProperty("another")).isFalse();
            Assertions.assertThat((Iterable)rel.getPropertyKeys()).containsExactlyInAnyOrder((Object[])new String[]{prop1, prop2, prop3});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThrowHumaneExceptionsWhenPropertyDoesNotExist() {
        String relId;
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode();
            Relationship rel = node.createRelationshipTo(node, RelationshipType.withName((String)"type-1"));
            rel.setProperty("PROPERTY_KEY", (Object)1);
            tx.commit();
        }
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode();
            relId = node.createRelationshipTo(node, RelationshipType.withName((String)"type-1")).getElementId();
            tx.commit();
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (Transaction tx = db.beginTx();){
                Relationship rel = this.lookupRelationship(tx, relId);
                rel.getProperty("PROPERTY_KEY");
            }
        }).isInstanceOf(NotFoundException.class)).hasMessageContaining("No such property, 'PROPERTY_KEY");
    }

    @Test
    void shouldThrowHumaneExceptionsWhenPropertyKeyDoesNotExist() {
        String relId;
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode();
            relId = node.createRelationshipTo(node, RelationshipType.withName((String)"type-1")).getElementId();
            tx.commit();
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (Transaction tx = db.beginTx();){
                Relationship rel = this.lookupRelationship(tx, relId);
                rel.getProperty("PROPERTY_KEY");
            }
        }).isInstanceOf(NotFoundException.class)).hasMessageContaining("No such property, 'PROPERTY_KEY");
    }

    protected abstract Relationship lookupRelationship(Transaction var1, String var2);
}

