/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.DatabaseEventListenerAdapter;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.SkipOnSpd;

class DatabaseEventsTest {
    private DatabaseManagementService managementService;

    DatabaseEventsTest() {
    }

    @BeforeEach
    void setUp() {
        this.managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void registerUnregisterHandlers() {
        DummyDatabaseEventListener handler1 = new DummyDatabaseEventListener();
        DummyDatabaseEventListener handler2 = new DummyDatabaseEventListener();
        Assertions.assertThrows(IllegalStateException.class, () -> this.lambda$registerUnregisterHandlers$0((DatabaseEventListener)handler1));
        this.managementService.registerDatabaseEventListener((DatabaseEventListener)handler1);
        this.managementService.registerDatabaseEventListener((DatabaseEventListener)handler1);
        this.managementService.unregisterDatabaseEventListener((DatabaseEventListener)handler1);
        Assertions.assertThrows(IllegalStateException.class, () -> this.lambda$registerUnregisterHandlers$1((DatabaseEventListener)handler1));
        this.managementService.registerDatabaseEventListener((DatabaseEventListener)handler1);
        this.managementService.registerDatabaseEventListener((DatabaseEventListener)handler2);
        this.managementService.unregisterDatabaseEventListener((DatabaseEventListener)handler1);
        this.managementService.unregisterDatabaseEventListener((DatabaseEventListener)handler2);
    }

    @SkipOnSpd(reason="Shutdown count is off in SPD, since there are more dbs")
    @Test
    void shutdownEvents() {
        DummyDatabaseEventListener handler1 = new DummyDatabaseEventListener();
        DummyDatabaseEventListener handler2 = new DummyDatabaseEventListener();
        this.managementService.registerDatabaseEventListener((DatabaseEventListener)handler1);
        this.managementService.registerDatabaseEventListener((DatabaseEventListener)handler2);
        this.managementService.shutdown();
        Assertions.assertEquals((int)2, (int)handler2.getShutdownCounter());
        Assertions.assertEquals((int)2, (int)handler1.getShutdownCounter());
    }

    private /* synthetic */ void lambda$registerUnregisterHandlers$1(DatabaseEventListener handler1) throws Throwable {
        this.managementService.unregisterDatabaseEventListener(handler1);
    }

    private /* synthetic */ void lambda$registerUnregisterHandlers$0(DatabaseEventListener handler1) throws Throwable {
        this.managementService.unregisterDatabaseEventListener(handler1);
    }

    private static class DummyDatabaseEventListener
    extends DatabaseEventListenerAdapter {
        private int shutdownCounter;

        private DummyDatabaseEventListener() {
        }

        public void databaseShutdown(DatabaseEventContext eventContext) {
            ++this.shutdownCounter;
        }

        int getShutdownCounter() {
            return this.shutdownCounter;
        }
    }
}

