/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.event.TransactionEventListenerAdapter;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.kernel.api.security.StaticAccessMode;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.database.PrivilegeDatabaseReference;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.event.ExpectedTransactionData;
import org.neo4j.kernel.impl.event.VerifyingTransactionEventListener;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.SkipOnSpd;
import org.neo4j.util.concurrent.BinaryLatch;

@ExtendWith(value={RandomExtension.class})
@ImpermanentDbmsExtension
class TransactionEventsIT {
    @Inject
    private DatabaseManagementService dbms;
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private RandomSupport random;

    TransactionEventsIT() {
    }

    @Test
    void createAdditionalDataInTransactionOnBeforeCommit() {
        Label additionalLabel = Label.label((String)"additional");
        Label mainLabel = Label.label((String)"main");
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)new BeforeCommitNodeCreator(additionalLabel));
        try (Transaction transaction = this.db.beginTx();){
            transaction.createNode(new Label[]{mainLabel});
            transaction.commit();
        }
        transaction = this.db.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)Iterators.count((Iterator)transaction.findNodes(additionalLabel)));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @SkipOnSpd(reason="SPD doesn't quite get existing property values when changing properties, and so the tx state and by extension tx event listeners won't get the 'prev' values")
    @Test
    void shouldSeeExpectedTransactionData() {
        int i;
        Graph state = new Graph(this.random);
        ExpectedTransactionData expected = new ExpectedTransactionData(true);
        VerifyingTransactionEventListener listener = new VerifyingTransactionEventListener(expected);
        try (Transaction tx = this.db.beginTx();){
            for (i = 0; i < 100; ++i) {
                Operation.createNode.perform(tx, state, expected);
            }
            for (i = 0; i < 20; ++i) {
                Operation.createRelationship.perform(tx, state, expected);
            }
            tx.commit();
        }
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)listener);
        Operation[] operations = Operation.values();
        for (i = 0; i < 1000; ++i) {
            expected.clear();
            try (Transaction tx = this.db.beginTx();){
                int transactionSize = this.random.intBetween(1, 20);
                for (int j = 0; j < transactionSize; ++j) {
                    ((Operation)((Object)this.random.among((Object[])operations))).perform(tx, state, expected);
                }
                tx.commit();
                continue;
            }
        }
    }

    @Test
    void transactionIdAndCommitTimeAccessibleAfterCommit() {
        TransactionIdCommitTimeTracker commitTimeTracker = new TransactionIdCommitTimeTracker();
        this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)commitTimeTracker);
        this.runTransaction();
        long firstTransactionId = commitTimeTracker.getTransactionIdAfterCommit();
        long firstTransactionCommitTime = commitTimeTracker.getCommitTimeAfterCommit();
        org.junit.jupiter.api.Assertions.assertTrue((firstTransactionId > 0L ? 1 : 0) != 0, (String)"Should be positive tx id.");
        org.junit.jupiter.api.Assertions.assertTrue((firstTransactionCommitTime > 0L ? 1 : 0) != 0, (String)"Should be positive.");
        this.runTransaction();
        long secondTransactionId = commitTimeTracker.getTransactionIdAfterCommit();
        long secondTransactionCommitTime = commitTimeTracker.getCommitTimeAfterCommit();
        org.junit.jupiter.api.Assertions.assertTrue((secondTransactionId > 0L ? 1 : 0) != 0, (String)"Should be positive tx id.");
        org.junit.jupiter.api.Assertions.assertTrue((secondTransactionCommitTime > 0L ? 1 : 0) != 0, (String)"Should be positive commit time value.");
        org.junit.jupiter.api.Assertions.assertTrue((secondTransactionId > firstTransactionId ? 1 : 0) != 0, (String)"Second tx id should be higher then first one.");
        org.junit.jupiter.api.Assertions.assertTrue((secondTransactionCommitTime >= firstTransactionCommitTime ? 1 : 0) != 0, (String)"Second commit time should be higher or equals then first one.");
    }

    @Test
    void transactionIdNotAccessibleBeforeCommit() {
        this.dbms.registerTransactionEventListener("neo4j", TransactionEventsIT.getBeforeCommitListener(TransactionData::getTransactionId));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(this::runTransaction).rootCause().isInstanceOf(IllegalStateException.class)).hasMessage("Transaction id is not assigned yet. It will be assigned during transaction commit.");
    }

    @Test
    void commitTimeNotAccessibleBeforeCommit() {
        this.dbms.registerTransactionEventListener("neo4j", TransactionEventsIT.getBeforeCommitListener(TransactionData::getCommitTime));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(this::runTransaction).rootCause().isInstanceOf(IllegalStateException.class)).hasMessage("Transaction commit time is not assigned yet. It will be assigned during transaction commit.");
    }

    @Test
    void shouldGetEmptyUsernameOnAuthDisabled() {
        this.dbms.registerTransactionEventListener("neo4j", TransactionEventsIT.getBeforeCommitListener(txData -> {
            ((AbstractStringAssert)Assertions.assertThat((String)txData.username()).as("Should have no username", new Object[0])).isEqualTo("");
            ((MapAssert)Assertions.assertThat((Map)txData.metaData()).as("Should have no metadata", new Object[0])).isEqualTo(Collections.emptyMap());
        }));
        this.runTransaction();
    }

    @Test
    void shouldGetSpecifiedUsernameAndMetaDataInTXData() {
        AtomicReference usernameRef = new AtomicReference();
        AtomicReference metaDataRef = new AtomicReference();
        this.dbms.registerTransactionEventListener("neo4j", TransactionEventsIT.getBeforeCommitListener(txData -> {
            usernameRef.set(txData.username());
            metaDataRef.set(txData.metaData());
        }));
        AuthSubject subject = (AuthSubject)Mockito.mock(AuthSubject.class);
        Mockito.when((Object)subject.executingUser()).thenReturn((Object)"Christof");
        LoginContext loginContext = new LoginContext(this, subject, ClientConnectionInfo.EMBEDDED_CONNECTION){

            public SecurityContext authorize(LoginContext.IdLookup idLookup, PrivilegeDatabaseReference dbName, AbstractSecurityLog securityLog) {
                return new SecurityContext(this.subject, (AccessMode)StaticAccessMode.WRITE, ClientConnectionInfo.EMBEDDED_CONNECTION, dbName.name());
            }
        };
        Map metadata = MapUtil.genericMap((Object[])new Object[]{"username", "joe"});
        this.runTransaction(loginContext, metadata);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)usernameRef.get())).as("Should have specified username", new Object[0])).isEqualTo("Christof");
        ((MapAssert)Assertions.assertThat((Map)((Map)metaDataRef.get())).as("Should have metadata with specified username", new Object[0])).isEqualTo((Object)metadata);
    }

    @Test
    void exceptionMessageShouldGetPassedThrough() {
        String message = "some message from a transaction event handler";
        this.dbms.registerTransactionEventListener("neo4j", TransactionEventsIT.getBeforeCommitListener(transactionData -> {
            throw new RuntimeException(message);
        }));
        TransactionFailureException e = (TransactionFailureException)org.junit.jupiter.api.Assertions.assertThrows(TransactionFailureException.class, this::runTransaction);
        Assertions.assertThat((Throwable)e).hasRootCauseMessage(message);
    }

    @Test
    void registerUnregisterWithConcurrentTransactions() throws Exception {
        try (ExecutorService executor = Executors.newFixedThreadPool(2);){
            long relNodeId;
            AtomicInteger runningCounter = new AtomicInteger();
            AtomicInteger doneCounter = new AtomicInteger();
            BinaryLatch startLatch = new BinaryLatch();
            RelationshipType relationshipType = RelationshipType.withName((String)"REL");
            CountingTransactionEventListener[] handlers = new CountingTransactionEventListener[20];
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i] = new CountingTransactionEventListener();
            }
            try (Transaction tx = this.db.beginTx();){
                relNodeId = tx.createNode().getId();
                tx.commit();
            }
            Future<?> nodeCreator = executor.submit(() -> {
                try {
                    runningCounter.incrementAndGet();
                    startLatch.await();
                    for (int i = 0; i < 2000; ++i) {
                        try (Transaction tx = this.db.beginTx();){
                            tx.createNode();
                            if (!ThreadLocalRandom.current().nextBoolean()) continue;
                            tx.commit();
                            continue;
                        }
                    }
                }
                finally {
                    doneCounter.incrementAndGet();
                }
            });
            Future<?> relationshipCreator = executor.submit(() -> {
                try {
                    runningCounter.incrementAndGet();
                    startLatch.await();
                    for (int i = 0; i < 1000; ++i) {
                        try (Transaction tx = this.db.beginTx();){
                            Node relNode = tx.getNodeById(relNodeId);
                            relNode.createRelationshipTo(relNode, relationshipType);
                            if (!ThreadLocalRandom.current().nextBoolean()) continue;
                            tx.commit();
                            continue;
                        }
                    }
                }
                finally {
                    doneCounter.incrementAndGet();
                }
            });
            while (runningCounter.get() < 2) {
                Thread.yield();
            }
            int i = 0;
            this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)handlers[i]);
            CountingTransactionEventListener currentlyRegistered = handlers[i];
            ++i;
            startLatch.release();
            while (doneCounter.get() < 2) {
                this.dbms.registerTransactionEventListener("neo4j", (TransactionEventListener)handlers[i]);
                if (++i == handlers.length) {
                    i = 0;
                }
                this.dbms.unregisterTransactionEventListener("neo4j", (TransactionEventListener)currentlyRegistered);
                currentlyRegistered = handlers[i];
            }
            nodeCreator.get();
            relationshipCreator.get();
            for (CountingTransactionEventListener handler : handlers) {
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)handler.get());
            }
        }
    }

    private static TransactionEventListenerAdapter<Object> getBeforeCommitListener(final Consumer<TransactionData> dataConsumer) {
        return new TransactionEventListenerAdapter<Object>(){

            public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) throws Exception {
                dataConsumer.accept(data);
                return super.beforeCommit(data, transaction, databaseService);
            }
        };
    }

    private void runTransaction() {
        this.runTransaction((LoginContext)AnonymousContext.write(), Collections.emptyMap());
    }

    private void runTransaction(LoginContext loginContext, Map<String, Object> metaData) {
        try (InternalTransaction transaction = this.db.beginTransaction(KernelTransaction.Type.EXPLICIT, loginContext);){
            KernelTransaction kernelTransaction = transaction.kernelTransaction();
            kernelTransaction.setMetaData(metaData);
            transaction.createNode();
            transaction.commit();
        }
    }

    private static class BeforeCommitNodeCreator
    extends TransactionEventListenerAdapter<Void> {
        private final Label additionalLabel;

        BeforeCommitNodeCreator(Label additionalLabel) {
            this.additionalLabel = additionalLabel;
        }

        public Void beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) throws Exception {
            transaction.createNode(new Label[]{this.additionalLabel});
            return null;
        }
    }

    private static class Graph {
        private static final String[] TOKENS = new String[]{"A", "B", "C", "D", "E"};
        private final RandomSupport random;
        private final List<Node> nodes = new ArrayList<Node>();
        private final List<Relationship> relationships = new ArrayList<Relationship>();

        Graph(RandomSupport random) {
            this.random = random;
        }

        private <E> E random(List<E> entities) {
            return entities.isEmpty() ? null : (E)entities.get(this.random.nextInt(entities.size()));
        }

        Node randomNode() {
            return this.random(this.nodes);
        }

        Relationship randomRelationship() {
            return this.random(this.relationships);
        }

        Node createNode(Transaction tx) {
            Node node = tx.createNode();
            this.nodes.add(node);
            return node;
        }

        void deleteRelationship(Relationship relationship) {
            relationship.delete();
            this.relationships.remove(relationship);
        }

        void deleteNode(Node node) {
            node.delete();
            this.nodes.remove(node);
        }

        private String randomToken() {
            return (String)this.random.among((Object[])TOKENS);
        }

        Label randomLabel() {
            return Label.label((String)this.randomToken());
        }

        RelationshipType randomRelationshipType() {
            return RelationshipType.withName((String)this.randomToken());
        }

        String randomPropertyKey() {
            return this.randomToken();
        }

        Object randomPropertyValue() {
            return this.random.nextValueAsObject();
        }

        int nodeCount() {
            return this.nodes.size();
        }

        Relationship createRelationship(Node node1, Node node2, RelationshipType type) {
            Relationship relationship = node1.createRelationshipTo(node2, type);
            this.relationships.add(relationship);
            return relationship;
        }
    }

    static enum Operation {
        createNode{

            @Override
            void perform(Transaction tx, Graph graph, ExpectedTransactionData expectations) {
                Node node = graph.createNode(tx);
                expectations.createdNode(node);
                this.debug(node);
            }
        }
        ,
        deleteNode{

            @Override
            void perform(Transaction tx, Graph graph, ExpectedTransactionData expectations) {
                Node node = graph.randomNode();
                if (node != null) {
                    node = tx.getNodeById(node.getId());
                    Iterables.forEach((Iterable)node.getRelationships(), relationship -> {
                        graph.deleteRelationship((Relationship)relationship);
                        expectations.deletedRelationship(relationship);
                        this.debug(relationship);
                    });
                    graph.deleteNode(node);
                    expectations.deletedNode(node);
                    this.debug(node);
                }
            }
        }
        ,
        assignLabel{

            @Override
            void perform(Transaction tx, Graph graph, ExpectedTransactionData expectations) {
                Label label;
                Node node = graph.randomNode();
                if (node != null && !(node = tx.getNodeById(node.getId())).hasLabel(label = graph.randomLabel())) {
                    node.addLabel(label);
                    expectations.assignedLabel(node, label);
                    this.debug(String.valueOf(node) + " " + String.valueOf(label));
                }
            }
        }
        ,
        removeLabel{

            @Override
            void perform(Transaction tx, Graph graph, ExpectedTransactionData expectations) {
                Label label;
                Node node = graph.randomNode();
                if (node != null && (node = tx.getNodeById(node.getId())).hasLabel(label = graph.randomLabel())) {
                    node.removeLabel(label);
                    expectations.removedLabel(node, label);
                    this.debug(String.valueOf(node) + " " + String.valueOf(label));
                }
            }
        }
        ,
        setNodeProperty{

            @Override
            void perform(Transaction tx, Graph graph, ExpectedTransactionData expectations) {
                Node node = graph.randomNode();
                if (node != null) {
                    node = tx.getNodeById(node.getId());
                    String key = graph.randomPropertyKey();
                    Object valueBefore = node.getProperty(key, null);
                    Object value = graph.randomPropertyValue();
                    node.setProperty(key, value);
                    expectations.assignedProperty(node, key, value, valueBefore);
                    this.debug(String.valueOf(node) + " " + key + "=" + String.valueOf(value) + " prev " + String.valueOf(valueBefore));
                }
            }
        }
        ,
        removeNodeProperty{

            @Override
            void perform(Transaction tx, Graph graph, ExpectedTransactionData expectations) {
                Node node = graph.randomNode();
                if (node != null) {
                    String key = graph.randomPropertyKey();
                    if ((node = tx.getNodeById(node.getId())).hasProperty(key)) {
                        Object valueBefore = node.removeProperty(key);
                        expectations.removedProperty(node, key, valueBefore);
                        this.debug(String.valueOf(node) + " " + key + "=" + String.valueOf(valueBefore));
                    }
                }
            }
        }
        ,
        setRelationshipProperty{

            @Override
            void perform(Transaction tx, Graph graph, ExpectedTransactionData expectations) {
                Relationship relationship = graph.randomRelationship();
                if (relationship != null) {
                    relationship = tx.getRelationshipById(relationship.getId());
                    String key = graph.randomPropertyKey();
                    Object valueBefore = relationship.getProperty(key, null);
                    Object value = graph.randomPropertyValue();
                    relationship.setProperty(key, value);
                    expectations.assignedProperty(relationship, key, value, valueBefore);
                    this.debug(String.valueOf(relationship) + " " + key + "=" + String.valueOf(value) + " prev " + String.valueOf(valueBefore));
                }
            }
        }
        ,
        removeRelationshipProperty{

            @Override
            void perform(Transaction tx, Graph graph, ExpectedTransactionData expectations) {
                String key;
                Relationship relationship = graph.randomRelationship();
                if (relationship != null && (relationship = tx.getRelationshipById(relationship.getId())).hasProperty(key = graph.randomPropertyKey())) {
                    Object valueBefore = relationship.removeProperty(key);
                    expectations.removedProperty(relationship, key, valueBefore);
                    this.debug(String.valueOf(relationship) + " " + key + "=" + String.valueOf(valueBefore));
                }
            }
        }
        ,
        createRelationship{

            @Override
            void perform(Transaction tx, Graph graph, ExpectedTransactionData expectations) {
                while (graph.nodeCount() < 2) {
                    createNode.perform(tx, graph, expectations);
                }
                Node node1 = tx.getNodeById(graph.randomNode().getId());
                Node node2 = tx.getNodeById(graph.randomNode().getId());
                Relationship relationship = graph.createRelationship(node1, node2, graph.randomRelationshipType());
                expectations.createdRelationship(relationship);
                this.debug(relationship);
            }
        }
        ,
        deleteRelationship{

            @Override
            void perform(Transaction tx, Graph graph, ExpectedTransactionData expectations) {
                Relationship relationship = graph.randomRelationship();
                if (relationship != null) {
                    relationship = tx.getRelationshipById(relationship.getId());
                    graph.deleteRelationship(relationship);
                    expectations.deletedRelationship(relationship);
                    this.debug(relationship);
                }
            }
        };


        abstract void perform(Transaction var1, Graph var2, ExpectedTransactionData var3);

        void debug(Object value) {
        }
    }

    private static class TransactionIdCommitTimeTracker
    extends TransactionEventListenerAdapter<Object> {
        private long transactionIdAfterCommit;
        private long commitTimeAfterCommit;

        private TransactionIdCommitTimeTracker() {
        }

        public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) throws Exception {
            return super.beforeCommit(data, transaction, databaseService);
        }

        public void afterCommit(TransactionData data, Object state, GraphDatabaseService databaseService) {
            this.commitTimeAfterCommit = data.getCommitTime();
            this.transactionIdAfterCommit = data.getTransactionId();
            super.afterCommit(data, state, databaseService);
        }

        long getTransactionIdAfterCommit() {
            return this.transactionIdAfterCommit;
        }

        long getCommitTimeAfterCommit() {
            return this.commitTimeAfterCommit;
        }
    }

    private static class CountingTransactionEventListener
    extends AtomicInteger
    implements TransactionEventListener<CountingTransactionEventListener> {
        private CountingTransactionEventListener() {
        }

        public CountingTransactionEventListener beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
            this.getAndIncrement();
            return this;
        }

        public void afterCommit(TransactionData data, CountingTransactionEventListener state, GraphDatabaseService databaseService) {
            this.getAndDecrement();
            Assertions.assertThat((AtomicInteger)state).isSameAs((Object)this);
        }

        public void afterRollback(TransactionData data, CountingTransactionEventListener state, GraphDatabaseService databaseService) {
            this.getAndDecrement();
            Assertions.assertThat((AtomicInteger)state).isSameAs((Object)this);
        }
    }
}

