/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi.parallel;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectAssertions;
import org.neo4j.gqlstatus.GqlExceptionLikeAssert;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.TransactionExecutionStatistic;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SkipOnSpd;
import org.neo4j.time.Clocks;
import org.neo4j.util.concurrent.Futures;

@DbmsExtension
public class ExecutionContextIT {
    private static final int NUMBER_OF_WORKERS = 20;
    @Inject
    private GraphDatabaseAPI databaseAPI;
    private ExecutorService executors;

    @BeforeEach
    void setUp() {
        this.executors = Executors.newFixedThreadPool(20);
    }

    @AfterEach
    void tearDown() {
        this.executors.shutdown();
    }

    @RepeatedTest(value=10)
    void contextMemoryTracking() throws ExecutionException {
        try (Transaction transaction = this.databaseAPI.beginTx();){
            KernelTransactionImplementation ktx = (KernelTransactionImplementation)((InternalTransaction)transaction).kernelTransaction();
            try (KernelStatement statement = ktx.acquireStatement();){
                ArrayList futures = new ArrayList(20);
                ArrayList<ExecutionContext> contexts = new ArrayList<ExecutionContext>(20);
                for (int i = 0; i < 20; ++i) {
                    ExecutionContext executionContext = ktx.createExecutionContext();
                    futures.add(this.executors.submit(() -> {
                        for (int j = 0; j < 5; ++j) {
                            executionContext.memoryTracker().allocateHeap(10L);
                        }
                        executionContext.complete();
                    }));
                    contexts.add(executionContext);
                }
                Futures.getAll(futures);
                KernelTransactions kernelTransactions = (KernelTransactions)this.databaseAPI.getDependencyResolver().resolveDependency(KernelTransactions.class);
                KernelTransactionHandle transactionHandle = kernelTransactions.activeTransactions().stream().filter(tx -> tx.isUnderlyingTransaction((KernelTransaction)ktx)).findFirst().orElseThrow();
                org.junit.jupiter.api.Assertions.assertEquals((long)ByteUnit.kibiBytes((long)2560L), (Long)transactionHandle.transactionStatistic().getEstimatedUsedHeapMemory());
                org.junit.jupiter.api.Assertions.assertEquals((long)0L, (Long)transactionHandle.transactionStatistic().getNativeAllocatedBytes());
                IOUtils.closeAllUnchecked(contexts);
                org.junit.jupiter.api.Assertions.assertEquals((long)ByteUnit.bytes((long)1000L), (Long)transactionHandle.transactionStatistic().getEstimatedUsedHeapMemory());
                org.junit.jupiter.api.Assertions.assertEquals((long)0L, (Long)transactionHandle.transactionStatistic().getNativeAllocatedBytes());
                transaction.close();
                TransactionExecutionStatistic statistic = new TransactionExecutionStatistic(ktx, Clocks.nanoClock(), 0L);
                org.junit.jupiter.api.Assertions.assertEquals((long)0L, (Long)statistic.getEstimatedUsedHeapMemory());
                org.junit.jupiter.api.Assertions.assertEquals((long)0L, (Long)statistic.getNativeAllocatedBytes());
            }
        }
    }

    @RepeatedTest(value=10)
    void contextAccessNodeExist() throws ExecutionException {
        int numberOfNodes = 1024;
        long[] nodeIds = new long[numberOfNodes];
        try (Transaction transaction = this.databaseAPI.beginTx();){
            for (int i = 0; i < numberOfNodes; ++i) {
                Node node = transaction.createNode();
                nodeIds[i] = node.getId();
            }
            transaction.commit();
        }
        transaction = this.databaseAPI.beginTx();
        try {
            KernelTransaction ktx = ((InternalTransaction)transaction).kernelTransaction();
            try (Statement statement = ktx.acquireStatement();){
                ArrayList futures = new ArrayList(20);
                ArrayList<ExecutionContext> contexts = new ArrayList<ExecutionContext>(20);
                for (int i = 0; i < 20; ++i) {
                    ExecutionContext executionContext = ktx.createExecutionContext();
                    futures.add(this.executors.submit(() -> {
                        for (long nodeId : nodeIds) {
                            org.junit.jupiter.api.Assertions.assertTrue((boolean)executionContext.dataRead().nodeExists(nodeId));
                        }
                        executionContext.complete();
                    }));
                    contexts.add(executionContext);
                }
                Futures.getAll(futures);
                IOUtils.closeAllUnchecked(contexts);
            }
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @RepeatedTest(value=10)
    void contextAccessRelationshipExist() throws ExecutionException {
        int numberOfRelationships = 1024;
        long[] relIds = new long[numberOfRelationships];
        try (Transaction transaction = this.databaseAPI.beginTx();){
            for (int i = 0; i < numberOfRelationships; ++i) {
                Node start = transaction.createNode();
                Node end = transaction.createNode();
                Relationship relationship = start.createRelationshipTo(end, RelationshipType.withName((String)"maker"));
                relIds[i] = relationship.getId();
            }
            transaction.commit();
        }
        transaction = this.databaseAPI.beginTx();
        try {
            KernelTransaction ktx = ((InternalTransaction)transaction).kernelTransaction();
            try (Statement statement = ktx.acquireStatement();){
                ArrayList futures = new ArrayList(20);
                ArrayList<ExecutionContext> contexts = new ArrayList<ExecutionContext>(20);
                for (int i = 0; i < 20; ++i) {
                    ExecutionContext executionContext = ktx.createExecutionContext();
                    futures.add(this.executors.submit(() -> {
                        for (long relId : relIds) {
                            org.junit.jupiter.api.Assertions.assertTrue((boolean)executionContext.dataRead().relationshipExists(relId));
                        }
                        executionContext.complete();
                    }));
                    contexts.add(executionContext);
                }
                Futures.getAll(futures);
                IOUtils.closeAllUnchecked(contexts);
            }
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @SkipOnSpd(reason="Page cache tracing is different in SPD")
    @RepeatedTest(value=10)
    void contextPeriodicReport() throws ExecutionException {
        int numberOfNodes = 32768;
        long[] nodeIds = new long[numberOfNodes];
        try (Transaction transaction = this.databaseAPI.beginTx();){
            for (int i = 0; i < numberOfNodes; ++i) {
                Node node = transaction.createNode();
                nodeIds[i] = node.getId();
            }
            transaction.commit();
        }
        int nodeSize = this.databaseAPI.databaseLayout() instanceof RecordDatabaseLayout ? 15 : 128;
        int nodesPerPage = 8192 / nodeSize;
        int numPages = (int)Math.ceil((double)numberOfNodes / (double)nodesPerPage);
        int numPins = numPages * 20;
        try (Transaction transaction = this.databaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)transaction).kernelTransaction();
            try (Statement statement = ktx.acquireStatement();){
                ArrayList futures = new ArrayList(20);
                ArrayList<ExecutionContext> contexts = new ArrayList<ExecutionContext>(20);
                for (int i = 0; i < 20; ++i) {
                    ExecutionContext executionContext = ktx.createExecutionContext();
                    futures.add(this.executors.submit(() -> {
                        for (long nodeId : nodeIds) {
                            org.junit.jupiter.api.Assertions.assertTrue((boolean)executionContext.dataRead().nodeExists(nodeId));
                            if (nodeId % 100L != 0L) continue;
                            executionContext.report();
                        }
                        executionContext.complete();
                    }));
                    contexts.add(executionContext);
                }
                Futures.getAll(futures);
                IOUtils.closeAllUnchecked(contexts);
                PageCursorTracer tracer = ktx.cursorContext().getCursorTracer();
                org.junit.jupiter.api.Assertions.assertEquals((long)numPins, (long)tracer.pins());
                org.junit.jupiter.api.Assertions.assertEquals((long)numPins, (long)tracer.unpins());
                org.junit.jupiter.api.Assertions.assertEquals((long)numPins, (long)tracer.hits());
            }
        }
    }

    @Test
    void closingExecutionContextDoNotLeakCursors() {
        for (int i = 0; i < 1024; ++i) {
            try (Transaction transaction = this.databaseAPI.beginTx();){
                KernelTransaction ktx = ((InternalTransaction)transaction).kernelTransaction();
                try (Statement statement = ktx.acquireStatement();
                     ExecutionContext executionContext = ktx.createExecutionContext();){
                    executionContext.complete();
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testTransactionTerminationCheck() {
        try (Transaction transaction = this.databaseAPI.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)transaction).kernelTransaction();
            try (Statement statement = ktx.acquireStatement();
                 ExecutionContext executionContext = ktx.createExecutionContext();){
                try {
                    Read read = executionContext.dataRead();
                    ktx.markForTermination((Status)Status.Transaction.Terminated);
                    ((GqlExceptionLikeAssert)((GqlExceptionLikeAssert)((GqlExceptionLikeAssert)ErrorGqlStatusObjectAssertions.assertThatThrownBy(() -> read.nodeExists(1L)).isInstanceOf(TransactionTerminatedException.class)).hasMessageContaining("The transaction has been terminated.")).hasGqlStatus(GqlStatusInfoCodes.STATUS_25N14)).hasStatusDescription("error: invalid transaction state - transaction termination client error. The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. Reason: Explicitly terminated by the user.");
                }
                finally {
                    executionContext.complete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldDetectWhenExecutionContextOutlivesItsTransaction() {
        ExecutionContext executionContext;
        KernelTransaction originalKtx;
        try (Transaction transaction = this.databaseAPI.beginTx();){
            originalKtx = ((InternalTransaction)transaction).kernelTransaction();
            try (Statement statement = originalKtx.acquireStatement();){
                executionContext = originalKtx.createExecutionContext();
            }
        }
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        try {
            Transaction transaction;
            KernelTransaction ktx;
            do {
                if (transactions.size() > 100) {
                    org.junit.jupiter.api.Assertions.fail((String)"Failed to get the original kernel transactions");
                }
                transaction = this.databaseAPI.beginTx();
                transactions.add(transaction);
            } while (originalKtx != (ktx = ((InternalTransaction)transaction).kernelTransaction()));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> executionContext.dataRead().nodeExists(1L)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Execution context used after transaction close");
        }
        finally {
            transactions.forEach(Transaction::close);
            executionContext.complete();
            executionContext.close();
        }
    }

    @Test
    void shouldFailToCrateExecutionContextForTransactionWithState() {
        try (Transaction transaction = this.databaseAPI.beginTx();){
            transaction.createNode();
            KernelTransaction ktx = ((InternalTransaction)transaction).kernelTransaction();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((KernelTransaction)ktx).createExecutionContext()).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Execution context cannot be used for transactions with non-empty transaction state");
        }
    }

    @Test
    void executionContextShouldManageResources() throws Exception {
        try (Transaction transaction = this.databaseAPI.beginTx();){
            KernelTransaction kts = ((InternalTransaction)transaction).kernelTransaction();
            try (Statement statement = kts.acquireStatement();){
                ExecutionContext executionContext = kts.createExecutionContext();
                AutoCloseable resource1 = (AutoCloseable)Mockito.mock(AutoCloseable.class);
                AutoCloseable resource2 = (AutoCloseable)Mockito.mock(AutoCloseable.class);
                AutoCloseable resource3 = (AutoCloseable)Mockito.mock(AutoCloseable.class);
                executionContext.registerCloseableResource(resource1);
                executionContext.registerCloseableResource(resource2);
                executionContext.registerCloseableResource(resource3);
                executionContext.unregisterCloseableResource(resource2);
                executionContext.complete();
                executionContext.close();
                ((AutoCloseable)Mockito.verify((Object)resource1)).close();
                ((AutoCloseable)Mockito.verify((Object)resource2, (VerificationMode)Mockito.never())).close();
                ((AutoCloseable)Mockito.verify((Object)resource3)).close();
            }
        }
    }

    @Test
    void shouldFailToCloseIfNotCompleted() {
        try (Transaction transaction = this.databaseAPI.beginTx();){
            KernelTransaction kts = ((InternalTransaction)transaction).kernelTransaction();
            try (Statement statement = kts.acquireStatement();){
                ExecutionContext executionContext = kts.createExecutionContext();
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ExecutionContext)executionContext).close()).isInstanceOf(IllegalStateException.class)).hasMessage("Execution context closed before it was marked as completed.");
            }
        }
    }

    @Test
    void testStateCheckWhenTransactionClosed() {
        try (Transaction transaction = this.databaseAPI.beginTx();){
            KernelTransaction kts = ((InternalTransaction)transaction).kernelTransaction();
            try (Statement statement = kts.acquireStatement();){
                ExecutionContext executionContext = kts.createExecutionContext();
                executionContext.performCheckBeforeOperation();
                Assertions.assertThat((boolean)executionContext.isTransactionOpen()).isTrue();
                transaction.close();
                Assertions.assertThat((boolean)executionContext.isTransactionOpen()).isFalse();
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ExecutionContext)executionContext).performCheckBeforeOperation()).isInstanceOf(NotInTransactionException.class)).hasMessage("This transaction has already been closed.");
            }
        }
    }

    @Test
    void testStateCheckWhenTransactionTerminated() {
        try (Transaction transaction = this.databaseAPI.beginTx();){
            KernelTransaction kts = ((InternalTransaction)transaction).kernelTransaction();
            try (Statement statement = kts.acquireStatement();){
                ExecutionContext executionContext = kts.createExecutionContext();
                executionContext.performCheckBeforeOperation();
                Assertions.assertThat((boolean)executionContext.isTransactionOpen()).isTrue();
                transaction.terminate();
                Assertions.assertThat((boolean)executionContext.isTransactionOpen()).isFalse();
                ((GqlExceptionLikeAssert)((GqlExceptionLikeAssert)((GqlExceptionLikeAssert)ErrorGqlStatusObjectAssertions.assertThatThrownBy(() -> ((ExecutionContext)executionContext).performCheckBeforeOperation()).isInstanceOf(TransactionTerminatedException.class)).hasMessageContaining("The transaction has been terminated")).hasGqlStatus(GqlStatusInfoCodes.STATUS_25N14)).hasStatusDescription("error: invalid transaction state - transaction termination client error. The transaction has been terminated. Retry your operation in a new transaction, and you should see a successful result. Reason: Explicitly terminated by the user.");
            }
        }
    }
}

