/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.transaction.TransactionCountersChecker;
import org.neo4j.kernel.impl.transaction.stats.TransactionCounters;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class TransactionMonitorTest {
    @Inject
    private GraphDatabaseAPI db;
    private TransactionCounters counts;

    TransactionMonitorTest() {
    }

    @BeforeEach
    void setup() {
        this.counts = (TransactionCounters)this.db.getDependencyResolver().resolveDependency(TransactionCounters.class);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldCountCommittedTransactions(String name, boolean isWriteTx, Consumer<Transaction> txConsumer) {
        TransactionCountersChecker checker = this.checker();
        TransactionCountersChecker.ExpectedDifference.NONE.verifyWith(checker);
        try (Transaction tx = this.db.beginTx();){
            TransactionCountersChecker.ExpectedDifference.NONE.withStarted(1).withActive(1).verifyWith(checker);
            txConsumer.accept(tx);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)TransactionMonitorTest.hasTxStateWithChanges(tx)).as(TransactionMonitorTest.shouldHaveTxStateWithChanges(isWriteTx))).isEqualTo(isWriteTx);
            TransactionCountersChecker.ExpectedDifference.NONE.withStarted(1).withActive(1).isWriteTx(isWriteTx).verifyWith(checker);
            tx.commit();
        }
        TransactionCountersChecker.ExpectedDifference.NONE.withStarted(1).isWriteTx(isWriteTx).withCommitted(1).verifyWith(checker);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldCountRolledBackTransactions(String name, boolean isWriteTx, Consumer<Transaction> txConsumer) {
        TransactionCountersChecker checker = this.checker();
        TransactionCountersChecker.ExpectedDifference.NONE.verifyWith(checker);
        try (Transaction tx = this.db.beginTx();){
            TransactionCountersChecker.ExpectedDifference.NONE.withStarted(1).withActive(1).verifyWith(checker);
            txConsumer.accept(tx);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)TransactionMonitorTest.hasTxStateWithChanges(tx)).as(TransactionMonitorTest.shouldHaveTxStateWithChanges(isWriteTx))).isEqualTo(isWriteTx);
            TransactionCountersChecker.ExpectedDifference.NONE.withStarted(1).withActive(1).isWriteTx(isWriteTx).verifyWith(checker);
            tx.rollback();
        }
        TransactionCountersChecker.ExpectedDifference.NONE.withStarted(1).withRolledBack(1).isWriteTx(isWriteTx).verifyWith(checker);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldCountTerminatedTransactions(String name, boolean isWriteTx, Consumer<Transaction> txConsumer) {
        TransactionCountersChecker checker = this.checker();
        TransactionCountersChecker.ExpectedDifference.NONE.verifyWith(checker);
        try (Transaction tx = this.db.beginTx();){
            TransactionCountersChecker.ExpectedDifference.NONE.withStarted(1).withActive(1).verifyWith(checker);
            txConsumer.accept(tx);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)TransactionMonitorTest.hasTxStateWithChanges(tx)).as(TransactionMonitorTest.shouldHaveTxStateWithChanges(isWriteTx))).isEqualTo(isWriteTx);
            TransactionCountersChecker.ExpectedDifference.NONE.withStarted(1).withActive(1).isWriteTx(isWriteTx).verifyWith(checker);
            tx.terminate();
        }
        TransactionCountersChecker.ExpectedDifference.NONE.withStarted(1).withRolledBack(1).withTerminated(1).isWriteTx(isWriteTx).verifyWith(checker);
    }

    @Test
    void shouldHandleEffectiveNoOpWrite() {
        TransactionCountersChecker checker = this.checker();
        TransactionCountersChecker.ExpectedDifference.NONE.verifyWith(checker);
        try (Transaction tx = this.db.beginTx();){
            TransactionCountersChecker.ExpectedDifference.NONE.withStarted(1).withActive(1).verifyWith(checker);
            tx.createNode().delete();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)TransactionMonitorTest.hasTxStateWithChanges(tx)).as(TransactionMonitorTest.shouldHaveTxStateWithChanges(true))).isTrue();
            TransactionCountersChecker.ExpectedDifference.NONE.withStarted(1).withActive(1).isWriteTx(true).verifyWith(checker);
            tx.commit();
        }
        TransactionCountersChecker.ExpectedDifference.NONE.withStarted(1).withCommitted(1).isWriteTx(true).verifyWith(checker);
    }

    @ParameterizedTest(name="terminate on fail: {argumentsWithNames}")
    @ValueSource(booleans={false, true})
    void shouldHandleErrorOnWrite(boolean terminate) {
        String nodeId;
        TransactionCountersChecker checker = this.checker();
        TransactionCountersChecker.ExpectedDifference.NONE.verifyWith(checker);
        try (Transaction tx = this.db.beginTx();){
            nodeId = tx.createNode().getElementId();
            tx.commit();
        }
        TransactionCountersChecker.ExpectedDifference.NONE.withStarted(1).withCommitted(1).isWriteTx(true).verifyWith(checker);
        checker = this.checker();
        TransactionCountersChecker.ExpectedDifference.NONE.verifyWith(checker);
        try (Transaction successfulTx2 = this.db.beginTx();
             Transaction unsuccessfulTx = this.db.beginTx();){
            TransactionCountersChecker.ExpectedDifference.NONE.withStarted(2).withActive(2).verifyWith(checker);
            Node nodeToSuccessfullyDelete = successfulTx2.getNodeByElementId(nodeId);
            Node nodeToUnsuccessfullyDelete = unsuccessfulTx.getNodeByElementId(nodeId);
            nodeToSuccessfullyDelete.delete();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)TransactionMonitorTest.hasTxStateWithChanges(successfulTx2)).as(TransactionMonitorTest.shouldHaveTxStateWithChanges(true))).isTrue();
            successfulTx2.commit();
            try {
                ((RethrowableThrowableAssert)((RethrowableThrowableAssert)Assertions.assertThatThrownBy(() -> ((Node)nodeToUnsuccessfullyDelete).delete(), (String)"node should be deleted", (Object[])new Object[0]).asInstanceOf(RethrowableThrowableAssert.factory(NotFoundException.class))).hasMessageContainingAll(new CharSequence[]{"Unable to delete Node", "since it has already been deleted"})).rethrow();
            }
            catch (NotFoundException error) {
                TransactionCountersChecker.ExpectedDifference.NONE.withStarted(2).withActive(1).withCommitted(1).isWriteTx(true).verifyWith(checker);
                if (!terminate) {
                    throw error;
                }
                unsuccessfulTx.terminate();
                unsuccessfulTx.commit();
            }
        }
        catch (NotFoundException successfulTx2) {
        }
        catch (RuntimeException e) {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).as("transaction failure exception", new Object[0])).hasRootCauseInstanceOf(TransactionTerminatedException.class);
        }
        TransactionCountersChecker.ExpectedDifference.NONE.withStarted(2).withCommitted(1).withRolledBack(1).withTerminated(terminate ? 1 : 0).isWriteTx(true).verifyWith(checker);
    }

    private TransactionCountersChecker checker() {
        return TransactionCountersChecker.checkerFor((TransactionCounters)this.counts);
    }

    private static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{"read", false, tx -> {}}), Arguments.of((Object[])new Object[]{"write", true, Transaction::createNode}));
    }

    private static boolean hasTxStateWithChanges(Transaction tx) {
        return ((KernelTransactionImplementation)((InternalTransaction)tx).kernelTransaction()).hasTxStateWithChanges();
    }

    private static Description shouldHaveTxStateWithChanges(boolean isWriteTx) {
        String type = isWriteTx ? "write" : "read";
        String negation = isWriteTx ? "" : " not";
        return new TextDescription("%s transaction should%s have state with changes", new Object[]{type, negation});
    }

    private static class RethrowableThrowableAssert<T extends Throwable>
    extends AbstractThrowableAssert<RethrowableThrowableAssert<T>, T> {
        static <T extends Throwable> InstanceOfAssertFactory<T, RethrowableThrowableAssert<T>> factory(Class<T> throwable) {
            return new InstanceOfAssertFactory(throwable, RethrowableThrowableAssert::new);
        }

        RethrowableThrowableAssert(T throwable) {
            super(throwable, RethrowableThrowableAssert.class);
        }

        void rethrow() throws T {
            throw (Throwable)this.actual;
        }
    }
}

