/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointLogFileRotationIT;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointLogSerializationHelper;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.test.LatestVersions;

@EnabledOnOs(value={OS.LINUX})
class PreallocatedCheckpointLogFileRotationIT
extends CheckpointLogFileRotationIT {
    PreallocatedCheckpointLogFileRotationIT() {
    }

    @Override
    protected boolean preallocateLogs() {
        return true;
    }

    @Override
    protected long expectedNewFileSize() {
        return CheckpointLogSerializationHelper.ACTUAL_ROTATION_THRESHOLD;
    }

    @Test
    void writeCheckpointsIntoPreallocatedFile() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        LogPosition logPosition = new LogPosition(1000L, 12345L);
        TransactionId transactionId = new TransactionId(100L, 101L, LatestVersions.LATEST_KERNEL_VERSION, 101, 102L, 103L);
        String reason = "checkpoints in preallocated file";
        for (int i = 0; i < 2; ++i) {
            checkpointAppender.checkPoint(LogCheckPointEvent.NULL, transactionId, transactionId.id() + 7L, LatestVersions.LATEST_KERNEL_VERSION, logPosition, logPosition, Instant.now(), reason);
        }
        Object[] matchedFiles = checkpointFile.getMatchedFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(1);
    }

    @Test
    void writeCheckpointsIntoSeveralPreallocatedFiles() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        checkpointFile.rotate();
        CheckpointLogSerializationHelper.fillWithCheckpointsWithCallback((int)5, (CheckpointAppender)checkpointAppender, index -> ((ObjectArrayAssert)Assertions.assertThat((Object[])this.getMatchedFilesUnchecked(checkpointFile)).hasSize(index + 2)).allMatch(this::sizeEqualsToPreallocatedFile));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])checkpointFile.getMatchedFiles()).hasSize(6)).allMatch(this::sizeEqualsToPreallocatedFile);
    }

    private Path[] getMatchedFilesUnchecked(CheckpointFile checkpointFile) {
        try {
            return checkpointFile.getMatchedFiles();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private boolean sizeEqualsToPreallocatedFile(Path path) {
        try {
            return Files.size(path) <= CheckpointLogSerializationHelper.getMaxCheckpointFileSize();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

