/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryHelpers;
import org.neo4j.kernel.recovery.RecoveryToFutureOverUpgradedVersionsIT;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.UpgradeTestUtil;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
public class LogFormatSwitchRecoveryIT {
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private Neo4jLayout neo4jLayout;
    private DatabaseManagementService managementService;
    private GraphDatabaseAPI systemDb;

    @BeforeEach
    void setUp() {
        this.startDbms(this::configureLegacyLogsAsLatest, false);
    }

    @AfterEach
    void tearDown() {
        this.shutdownDbms();
    }

    private void startDbms(RecoveryToFutureOverUpgradedVersionsIT.Configuration configuration, boolean allowAutomaticUpgrade) {
        this.managementService = configuration.configure(new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(GraphDatabaseSettings.preallocate_logical_logs, (Object)false).setConfig(GraphDatabaseSettings.keep_logical_logs, (Object)"keep_all").setConfig(GraphDatabaseInternalSettings.automatic_upgrade_enabled, (Object)allowAutomaticUpgrade)).build();
        this.systemDb = (GraphDatabaseAPI)this.managementService.database("system");
    }

    private void shutdownDbms() {
        if (this.managementService != null) {
            this.managementService.shutdown();
            this.managementService = null;
        }
    }

    private static DbmsRuntimeVersion findDbmsVersionMatchingKernelVersion(KernelVersion version) {
        for (DbmsRuntimeVersion dbmsRuntimeVersion : DbmsRuntimeVersion.VERSIONS) {
            if (dbmsRuntimeVersion.kernelVersion() != version) continue;
            return dbmsRuntimeVersion;
        }
        throw new IllegalArgumentException("No matching Dbms version found for " + version.toString());
    }

    private TestDatabaseManagementServiceBuilder configureLegacyLogsAsLatest(TestDatabaseManagementServiceBuilder builder) {
        return builder.setConfig(GraphDatabaseInternalSettings.latest_runtime_version, (Object)LatestVersions.LATEST_RUNTIME_VERSION_WITHOUT_ENVELOPES.getVersion()).setConfig(GraphDatabaseInternalSettings.latest_kernel_version, (Object)LatestVersions.LATEST_KERNEL_VERSION_WITHOUT_ENVELOPES.version());
    }

    private TestDatabaseManagementServiceBuilder configureEnvelopedLogsAsLatest(TestDatabaseManagementServiceBuilder builder) {
        return builder.setConfig(GraphDatabaseInternalSettings.latest_runtime_version, (Object)LogFormatSwitchRecoveryIT.findDbmsVersionMatchingKernelVersion(KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED).getVersion()).setConfig(GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED.version());
    }

    private void writeGraph(GraphDatabaseAPI testDb, int generation) {
        int baseLinkCount = generation * (generation - 1) / 2 + 1;
        try (Transaction tx = testDb.beginTx();){
            String generationName = "gen" + generation;
            Label generationLabel = Label.label((String)generationName);
            Node node1 = tx.createNode(new Label[]{generationLabel});
            node1.setProperty("name", (Object)(generationName + "_1"));
            Node node2 = tx.createNode(new Label[]{generationLabel});
            node2.setProperty("name", (Object)(generationName + "_2"));
            String linkName = "link" + baseLinkCount++;
            Relationship rel = node1.createRelationshipTo(node2, RelationshipType.withName((String)linkName));
            rel.setProperty("name", (Object)linkName);
            for (int prevGeneration = 1; prevGeneration < generation; ++prevGeneration) {
                String prevGenerationName = "gen" + prevGeneration;
                Label prevGenerationLabel = Label.label((String)prevGenerationName);
                Node oldNode = tx.findNode(prevGenerationLabel, "name", (Object)(prevGenerationName + "_1"));
                linkName = "link" + baseLinkCount++;
                Relationship rel2 = oldNode.createRelationshipTo(node2, RelationshipType.withName((String)linkName));
                rel2.setProperty("name", (Object)linkName);
            }
            tx.commit();
        }
    }

    private void verifyGraph(GraphDatabaseAPI testDb, int generation) {
        int linkCount = 1;
        try (Transaction tx = testDb.beginTx();){
            Assertions.assertEquals((long)(2L * (long)generation), (long)Iterables.count((Iterable)tx.getAllNodes()));
            Assertions.assertEquals((long)((long)generation * ((long)generation + 1L) / 2L), (long)Iterables.count((Iterable)tx.getAllRelationships()));
            for (int currentGeneration = 1; currentGeneration <= generation; ++currentGeneration) {
                String generationName = "gen" + currentGeneration;
                Label generationLabel = Label.label((String)generationName);
                Assertions.assertNotNull((Object)tx.findNode(generationLabel, "name", (Object)(generationName + "_1")));
                Assertions.assertNotNull((Object)tx.findNode(generationLabel, "name", (Object)(generationName + "_2")));
                for (int prevGeneration = 1; prevGeneration < currentGeneration; ++prevGeneration) {
                    String linkName = "link" + linkCount++;
                    Assertions.assertNotNull((Object)tx.findRelationship(RelationshipType.withName((String)linkName), "name", (Object)linkName));
                }
            }
        }
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)testDb, (KernelVersion)KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED);
    }

    private DatabaseAndSnapshot prepareUpgradedDatabaseAndSnapshot(String dbName) throws Exception {
        GraphDatabaseAPI testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        this.writeGraph(testDb, 1);
        DatabaseLayout layout = this.neo4jLayout.databaseLayout(dbName);
        this.shutdownDbms();
        Path initialState = layout.databaseDirectory().getParent().resolve("original");
        this.fileSystem.copyRecursively(layout.databaseDirectory(), initialState);
        this.startDbms(builder -> builder, false);
        testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        this.writeGraph(testDb, 2);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)testDb, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION_WITHOUT_ENVELOPES);
        this.shutdownDbms();
        this.startDbms(this::configureEnvelopedLogsAsLatest, false);
        testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        UpgradeTestUtil.manuallyUpgrade((GraphDatabaseService)this.systemDb);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)testDb, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION_WITHOUT_ENVELOPES);
        this.writeGraph(testDb, 3);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)testDb, (KernelVersion)KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED);
        return new DatabaseAndSnapshot(testDb, initialState, layout);
    }

    private void restoreDBSnapshot(DatabaseAndSnapshot databaseAndSnapshot) throws Exception {
        this.fileSystem.deleteRecursively(databaseAndSnapshot.layout.databaseDirectory());
        this.fileSystem.copyRecursively(databaseAndSnapshot.snapshot, databaseAndSnapshot.layout.databaseDirectory());
        TransactionLogFilesHelper checkpointMatcher = TransactionLogFilesHelper.forCheckpoints((FileSystemAbstraction)this.fileSystem, (Path)databaseAndSnapshot.layout.getTransactionLogsDirectory());
        this.fileSystem.deleteRecursively(databaseAndSnapshot.layout.getTransactionLogsDirectory(), arg_0 -> ((TransactionLogFilesHelper)checkpointMatcher).isLogFile(arg_0));
    }

    private void verifyRecovery(String dbName, boolean allowCorruption) throws Exception {
        Config config = Config.newBuilder().set(GraphDatabaseInternalSettings.latest_runtime_version, (Object)LogFormatSwitchRecoveryIT.findDbmsVersionMatchingKernelVersion(KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED).getVersion()).set(GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED.version()).set(GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)(!allowCorruption ? 1 : 0)).build();
        DatabaseLayout layout = this.neo4jLayout.databaseLayout(dbName);
        Assertions.assertTrue((boolean)RecoveryHelpers.runRecovery((DatabaseLayout)layout, (FileSystemAbstraction)this.fileSystem, (Config)config));
        Assertions.assertFalse((boolean)Recovery.isRecoveryRequired((FileSystemAbstraction)this.fileSystem, (DatabaseLayout)layout, (Config)config, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
        this.startDbms(this::configureEnvelopedLogsAsLatest, false);
        GraphDatabaseAPI testDb = (GraphDatabaseAPI)this.managementService.database(dbName);
        this.verifyGraph(testDb, 3);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)testDb, (KernelVersion)KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED);
    }

    @Test
    void recoveryShouldReRunOverOldAndNew() throws Exception {
        String dbName = "neo4j";
        DatabaseAndSnapshot databaseAndSnapshot = this.prepareUpgradedDatabaseAndSnapshot(dbName);
        this.verifyGraph(databaseAndSnapshot.testDb, 3);
        this.shutdownDbms();
        this.restoreDBSnapshot(databaseAndSnapshot);
        this.verifyRecovery(dbName, false);
    }

    @Test
    void recoveryWithUpgradeAndCorruptedItems() throws Exception {
        String dbName = "neo4j";
        DatabaseAndSnapshot databaseAndSnapshot = this.prepareUpgradedDatabaseAndSnapshot(dbName);
        LogFile logFile = ((LogFiles)databaseAndSnapshot.testDb.getDependencyResolver().resolveDependency(LogFiles.class)).getLogFile();
        logFile.rotate();
        Path lastLog = logFile.getLogFileForVersion(logFile.getCurrentLogVersion());
        this.writeGraph(databaseAndSnapshot.testDb, 4);
        this.verifyGraph(databaseAndSnapshot.testDb, 4);
        this.shutdownDbms();
        this.restoreDBSnapshot(databaseAndSnapshot);
        try (StoreFileChannel logChannel = this.fileSystem.write(lastLog);){
            logChannel.position(131072L);
            ByteBuffer zeros = ByteBuffer.allocate(10);
            logChannel.write(zeros);
            logChannel.flush();
        }
        this.verifyRecovery(dbName, true);
    }

    @Test
    void recoveryWithUpgradeAndTruncation() throws Exception {
        String dbName = "neo4j";
        DatabaseAndSnapshot databaseAndSnapshot = this.prepareUpgradedDatabaseAndSnapshot(dbName);
        LogFile logFile = ((LogFiles)databaseAndSnapshot.testDb.getDependencyResolver().resolveDependency(LogFiles.class)).getLogFile();
        LogPosition position = logFile.getTransactionLogWriter().getCurrentPosition();
        Path currentLogFile = logFile.getLogFileForVersion(logFile.getCurrentLogVersion());
        this.writeGraph(databaseAndSnapshot.testDb, 4);
        this.verifyGraph(databaseAndSnapshot.testDb, 4);
        this.shutdownDbms();
        this.restoreDBSnapshot(databaseAndSnapshot);
        this.fileSystem.truncate(currentLogFile, position.getByteOffset());
        this.verifyRecovery(dbName, false);
    }

    private record DatabaseAndSnapshot(GraphDatabaseAPI testDb, Path snapshot, DatabaseLayout layout) {
    }
}

