/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.test.Race;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class ConsistentPropertyReadsIT {
    @Inject
    private GraphDatabaseService db;

    ConsistentPropertyReadsIT() {
    }

    @Test
    void shouldReadConsistentPropertyValues() throws Throwable {
        Node[] nodes = new Node[10];
        String[] keys = new String[]{"1", "2", "3"};
        String[] values = new String[]{ConsistentPropertyReadsIT.longString('a'), ConsistentPropertyReadsIT.longString('b'), ConsistentPropertyReadsIT.longString('c')};
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = tx.createNode();
                for (String key : keys) {
                    nodes[i].setProperty(key, (Object)values[0]);
                }
            }
            tx.commit();
        }
        int numUpdaters = 2;
        AtomicLong updatesDone = new AtomicLong();
        AtomicLong readsDone = new AtomicLong();
        Race race = new Race().withEndCondition(new BooleanSupplier[]{() -> updatesDone.get() > 1000L && readsDone.get() > 100000L});
        race.addContestants(numUpdaters, () -> {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            Node node = nodes[random.nextInt(nodes.length)];
            String key = keys[random.nextInt(keys.length)];
            try (Transaction tx = this.db.beginTx();){
                tx.getNodeById(node.getId()).removeProperty(key);
                tx.commit();
            }
            tx = this.db.beginTx();
            try {
                tx.getNodeById(node.getId()).setProperty(key, (Object)values[random.nextInt(values.length)]);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            updatesDone.incrementAndGet();
        });
        int numReaders = Integer.max(2, Runtime.getRuntime().availableProcessors() - numUpdaters);
        race.addContestants(numReaders, () -> {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            try (Transaction tx = this.db.beginTx();){
                String value = (String)tx.getNodeById(nodes[random.nextInt(nodes.length)].getId()).getProperty(keys[random.nextInt(keys.length)], null);
                Assertions.assertTrue((value == null || ArrayUtil.contains((Object[])values, (Object)value) ? 1 : 0) != 0, (String)value);
                tx.commit();
            }
            readsDone.incrementAndGet();
        });
        race.go();
    }

    private static String longString(char c) {
        char[] chars = new char[ThreadLocalRandom.current().nextInt(800, 1000)];
        Arrays.fill(chars, c);
        return new String(chars);
    }
}

