/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.ZippedStoreCommunity;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.UpgradeTestUtil;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class LogFormatSelectionIT {
    @Inject
    private Neo4jLayout neo4jLayout;
    private TestDatabaseManagementServiceBuilder builder;
    private DatabaseManagementService managementService;

    LogFormatSelectionIT() {
    }

    @AfterEach
    void shutdown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
            this.managementService = null;
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j", "system"})
    void logFormatProviderShouldBeUpdatedOnUpgrade(String dbName) throws Throwable {
        ZippedStoreCommunity.REC_AF11_V50_ALL.unzip(this.neo4jLayout.homeDirectory());
        this.createBuilderNoAutomaticUpgrade();
        this.managementService = this.builder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database(dbName);
        this.assertKernelVersionAndLogFormat(db, KernelVersion.V5_0);
        UpgradeTestUtil.upgradeDatabase((DatabaseManagementService)this.managementService, (GraphDatabaseAPI)db, (KernelVersion)KernelVersion.V5_0, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
        this.assertKernelVersionAndLogFormat(db, LatestVersions.LATEST_KERNEL_VERSION);
        LogFiles logFiles = (LogFiles)db.getDependencyResolver().resolveDependency(LogFiles.class);
        this.shutdown();
        LogFormatSelectionIT.checkLogFormatOfLatestFiles(logFiles, LatestVersions.LATEST_KERNEL_VERSION);
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j", "system"})
    void upgradeToFuture(String dbName) throws IOException {
        this.createBuilder();
        this.managementService = this.builder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database(dbName);
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        this.managementService.shutdown();
        this.createBuilderNoAutomaticUpgrade();
        this.managementService = this.configureGloriousFutureAsLatest(this.builder).build();
        db = (GraphDatabaseAPI)this.managementService.database(dbName);
        this.assertKernelVersionAndLogFormat(db, LatestVersions.LATEST_KERNEL_VERSION);
        UpgradeTestUtil.upgradeDatabase((DatabaseManagementService)this.managementService, (GraphDatabaseAPI)db, (KernelVersion)LatestVersions.LATEST_KERNEL_VERSION, (KernelVersion)KernelVersion.GLORIOUS_FUTURE);
        this.assertKernelVersionAndLogFormat(db, KernelVersion.GLORIOUS_FUTURE);
        LogFiles logFiles = (LogFiles)db.getDependencyResolver().resolveDependency(LogFiles.class);
        this.shutdown();
        LogFormatSelectionIT.checkLogFormatOfLatestFiles(logFiles, KernelVersion.GLORIOUS_FUTURE);
    }

    private static void checkLogFormatOfLatestFiles(LogFiles logFiles, KernelVersion gloriousFuture) throws IOException {
        Assertions.assertThat((Comparable)logFiles.getLogFile().extractHeader(logFiles.getLogFile().getLogRangeInfo().highestVersion()).getLogFormatVersion()).isEqualTo((Object)LogFormat.fromKernelVersion((KernelVersion)gloriousFuture));
        Assertions.assertThat((Comparable)logFiles.getCheckpointFile().extractHeader(logFiles.getCheckpointFile().getLogRangeInfo().highestVersion()).getLogFormatVersion()).isEqualTo((Object)LogFormat.fromKernelVersion((KernelVersion)gloriousFuture));
    }

    private TestDatabaseManagementServiceBuilder configureGloriousFutureAsLatest(TestDatabaseManagementServiceBuilder builder) {
        return builder.setConfig(GraphDatabaseInternalSettings.latest_runtime_version, (Object)DbmsRuntimeVersion.GLORIOUS_FUTURE.getVersion()).setConfig(GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.GLORIOUS_FUTURE.version());
    }

    void assertKernelVersionAndLogFormat(GraphDatabaseAPI db, KernelVersion expectedKernelVersion) {
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)db, (KernelVersion)expectedKernelVersion);
        Assertions.assertThat((Comparable)((LogFormatVersionProvider)db.getDependencyResolver().resolveDependency(LogFormatVersionProvider.class)).getCurrentLogFormat()).isEqualTo((Object)LogFormat.fromKernelVersion((KernelVersion)expectedKernelVersion));
    }

    private void createBuilder() {
        if (this.builder == null) {
            this.builder = new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(GraphDatabaseSettings.preallocate_logical_logs, (Object)false).setConfig(GraphDatabaseSettings.keep_logical_logs, (Object)"keep_all");
        }
    }

    private void createBuilderNoAutomaticUpgrade() {
        if (this.builder == null) {
            this.builder = new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(GraphDatabaseSettings.preallocate_logical_logs, (Object)false).setConfig(GraphDatabaseSettings.keep_logical_logs, (Object)"keep_all").setConfig(GraphDatabaseInternalSettings.automatic_upgrade_enabled, (Object)false);
        }
    }
}

