/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.id.IdController;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.TransactionIdSequence;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class TransactionIdIT {
    @Inject
    private GraphDatabaseAPI databaseAPI;

    TransactionIdIT() {
    }

    @Test
    void sequenceNumberIncreasing() {
        DependencyResolver dependencyResolver = this.databaseAPI.getDependencyResolver();
        TransactionIdSequence transactionIdSequence = (TransactionIdSequence)dependencyResolver.resolveDependency(TransactionIdSequence.class);
        long currentBase = transactionIdSequence.currentValue();
        for (int i = 0; i < 100; ++i) {
            try (TransactionImpl transaction = (TransactionImpl)this.databaseAPI.beginTx();){
                long sequenceNumber = transaction.kernelTransaction().getTransactionSequenceNumber();
                Assertions.assertThat((long)sequenceNumber).isGreaterThan(currentBase);
                currentBase = sequenceNumber;
                continue;
            }
        }
    }

    @Test
    void transactionReuseCriteriaBasedOnSequenceNumber() {
        IdController.TransactionSnapshot snapshot;
        DependencyResolver dependencyResolver = this.databaseAPI.getDependencyResolver();
        KernelTransactions kernelTransactions = (KernelTransactions)dependencyResolver.resolveDependency(KernelTransactions.class);
        try (TransactionImpl oldTransaction = (TransactionImpl)this.databaseAPI.beginTx();){
            long sequenceNumber = oldTransaction.kernelTransaction().getTransactionSequenceNumber();
            snapshot = new IdController.TransactionSnapshot(sequenceNumber, 1L, 1L);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)kernelTransactions.eligibleForFreeing(snapshot));
            for (int i = 0; i < 100; ++i) {
                Transaction transaction = this.databaseAPI.beginTx();
                if (transaction == null) continue;
                transaction.close();
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)kernelTransactions.eligibleForFreeing(snapshot));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)kernelTransactions.eligibleForFreeing(snapshot));
    }

    @Test
    void oldestActiveTransactionLookup() {
        long sequenceNumber;
        DependencyResolver dependencyResolver = this.databaseAPI.getDependencyResolver();
        KernelTransactions kernelTransactions = (KernelTransactions)dependencyResolver.resolveDependency(KernelTransactions.class);
        try (TransactionImpl oldTransaction = (TransactionImpl)this.databaseAPI.beginTx();){
            sequenceNumber = oldTransaction.kernelTransaction().getTransactionSequenceNumber();
            for (int i = 0; i < 100; ++i) {
                Transaction transaction = this.databaseAPI.beginTx();
                if (transaction == null) continue;
                transaction.close();
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)sequenceNumber, (long)kernelTransactions.oldestActiveTransactionSequenceNumber());
        }
        org.junit.jupiter.api.Assertions.assertNotEquals((long)sequenceNumber, (long)kernelTransactions.oldestActiveTransactionSequenceNumber());
    }
}

