/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexAccessorCompatibility;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.PropertyIndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleEntityValueClient;
import org.neo4j.test.InMemoryTokens;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

abstract class CompositeIndexAccessorCompatibility
extends IndexAccessorCompatibility {
    CompositeIndexAccessorCompatibility(PropertyIndexProviderCompatibilityTestSuite testSuite, IndexPrototype prototype) {
        super(testSuite, prototype);
    }

    @Test
    void testIndexScan() throws Exception {
        List<Long> ids = LongStream.rangeClosed(1L, 10L).boxed().toList();
        RandomValues rv = RandomValues.create((Random)this.random.random(), (RandomValues.Configuration)RandomValues.defaults().maxVectorNumBytes(4037));
        Supplier<Value> randomValue = () -> rv.nextValueOfTypes(this.testSuite.supportedValueTypes());
        this.updateAndCommit(ids.stream().map(id -> CompositeIndexAccessorCompatibility.add((long)id, this.descriptor, (Value)randomValue.get(), (Value)randomValue.get())).collect(Collectors.toUnmodifiableList()));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()})).isEqualTo(ids);
    }

    @Test
    void testIndexScanAndSeekExactWithExactByString() throws Exception {
        this.testIndexScanAndSeekExactWithExact("a", "b");
    }

    @Test
    void testIndexScanAndSeekExactWithExactByNumber() throws Exception {
        this.testIndexScanAndSeekExactWithExact(333, 101);
    }

    @Test
    void testIndexScanAndSeekExactWithExactByBoolean() throws Exception {
        this.testIndexScanAndSeekExactWithExact(true, false);
    }

    @Test
    void testIndexScanAndSeekExactWithExactByTemporal() throws Exception {
        this.testIndexScanAndSeekExactWithExact((Value)DateValue.epochDate((long)303L), (Value)DateValue.epochDate((long)101L));
    }

    @Test
    void testIndexScanAndSeekExactWithExactByStringArray() throws Exception {
        this.testIndexScanAndSeekExactWithExact(new String[]{"a", "c"}, new String[]{"b", "c"});
    }

    @Test
    void testIndexScanAndSeekExactWithExactByNumberArray() throws Exception {
        this.testIndexScanAndSeekExactWithExact(new int[]{333, 900}, new int[]{101, 900});
    }

    @Test
    void testIndexScanAndSeekExactWithExactByBooleanArray() throws Exception {
        this.testIndexScanAndSeekExactWithExact(new boolean[]{true, true}, new boolean[]{false, true});
    }

    @Test
    void testIndexScanAndSeekExactWithExactByTemporalArray() throws Exception {
        this.testIndexScanAndSeekExactWithExact((Value)CompositeIndexAccessorCompatibility.dateArray(333, 900), (Value)CompositeIndexAccessorCompatibility.dateArray(101, 900));
    }

    private void testIndexScanAndSeekExactWithExact(Object a, Object b) throws Exception {
        this.testIndexScanAndSeekExactWithExact(Values.of((Object)a), Values.of((Object)b));
    }

    private void testIndexScanAndSeekExactWithExact(Value a, Value b) throws Exception {
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor, a, a), CompositeIndexAccessorCompatibility.add(2L, this.descriptor, b, b), CompositeIndexAccessorCompatibility.add(3L, this.descriptor, a, b)));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)a), PropertyIndexQuery.exact((int)1, (Object)a)})).isEqualTo(Collections.singletonList(1L));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)b), PropertyIndexQuery.exact((int)1, (Object)b)})).isEqualTo(Collections.singletonList(2L));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)a), PropertyIndexQuery.exact((int)1, (Object)b)})).isEqualTo(Collections.singletonList(3L));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)1)})).isEqualTo(Arrays.asList(1L, 2L, 3L));
    }

    @Test
    void testIndexScanAndSeekExactWithExactByPoint() throws Exception {
        Assumptions.assumeTrue((boolean)this.testSuite.supportsSpatial(), (String)"Assume support for spatial");
        PointValue gps = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{12.6, 56.7});
        PointValue car = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{12.6, 56.7});
        PointValue gps3d = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84_3D, (double[])new double[]{12.6, 56.7, 100.0});
        PointValue car3d = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN_3D, (double[])new double[]{12.6, 56.7, 100.0});
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor, (Value)gps, (Value)gps), CompositeIndexAccessorCompatibility.add(2L, this.descriptor, (Value)car, (Value)car), CompositeIndexAccessorCompatibility.add(3L, this.descriptor, (Value)gps, (Value)car), CompositeIndexAccessorCompatibility.add(4L, this.descriptor, (Value)gps3d, (Value)gps3d), CompositeIndexAccessorCompatibility.add(5L, this.descriptor, (Value)car3d, (Value)car3d), CompositeIndexAccessorCompatibility.add(6L, this.descriptor, (Value)gps, (Value)car3d)));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)gps), PropertyIndexQuery.exact((int)1, (Object)gps)})).isEqualTo(Collections.singletonList(1L));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)car), PropertyIndexQuery.exact((int)1, (Object)car)})).isEqualTo(Collections.singletonList(2L));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)gps), PropertyIndexQuery.exact((int)1, (Object)car)})).isEqualTo(Collections.singletonList(3L));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)gps3d), PropertyIndexQuery.exact((int)1, (Object)gps3d)})).isEqualTo(Collections.singletonList(4L));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)car3d), PropertyIndexQuery.exact((int)1, (Object)car3d)})).isEqualTo(Collections.singletonList(5L));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)gps), PropertyIndexQuery.exact((int)1, (Object)car3d)})).isEqualTo(Collections.singletonList(6L));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)1)})).isEqualTo(Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L));
    }

    @Test
    void testIndexSeekExactWithRangeByString() throws Exception {
        this.testIndexSeekExactWithRange(Values.of((Object)"a"), Values.of((Object)"b"), Values.of((Object)"Anabelle"), Values.of((Object)"Anna"), Values.of((Object)"Bob"), Values.of((Object)"Harriet"), Values.of((Object)"William"));
    }

    @Test
    void testIndexSeekExactWithRangeByNumber() throws Exception {
        this.testIndexSeekExactWithRange(Values.of((Object)303), Values.of((Object)101), Values.of((Object)111), Values.of((Object)222), Values.of((Object)333), Values.of((Object)444), Values.of((Object)555));
    }

    @Test
    void testIndexSeekExactWithRangeByTemporal() throws Exception {
        this.testIndexSeekExactWithRange((Value)DateValue.epochDate((long)303L), (Value)DateValue.epochDate((long)101L), (Value)DateValue.epochDate((long)111L), (Value)DateValue.epochDate((long)222L), (Value)DateValue.epochDate((long)333L), (Value)DateValue.epochDate((long)444L), (Value)DateValue.epochDate((long)555L));
    }

    @Test
    void testIndexSeekExactWithRangeByBoolean() throws Exception {
        this.testIndexSeekExactWithRangeByBooleanType(BooleanValue.TRUE, BooleanValue.FALSE, BooleanValue.FALSE, BooleanValue.TRUE);
    }

    @Test
    void testIndexSeekExactWithRangeByStringArray() throws Exception {
        this.testIndexSeekExactWithRange((Value)Values.stringArray((String[])new String[]{"a", "c"}), (Value)Values.stringArray((String[])new String[]{"b", "c"}), (Value)Values.stringArray((String[])new String[]{"Anabelle", "c"}), (Value)Values.stringArray((String[])new String[]{"Anna", "c"}), (Value)Values.stringArray((String[])new String[]{"Bob", "c"}), (Value)Values.stringArray((String[])new String[]{"Harriet", "c"}), (Value)Values.stringArray((String[])new String[]{"William", "c"}));
    }

    @Test
    void testIndexSeekExactWithRangeByNumberArray() throws Exception {
        this.testIndexSeekExactWithRange((Value)Values.longArray((long[])new long[]{333L, 9000L}), (Value)Values.longArray((long[])new long[]{101L, 900L}), (Value)Values.longArray((long[])new long[]{111L, 900L}), (Value)Values.longArray((long[])new long[]{222L, 900L}), (Value)Values.longArray((long[])new long[]{333L, 900L}), (Value)Values.longArray((long[])new long[]{444L, 900L}), (Value)Values.longArray((long[])new long[]{555L, 900L}));
    }

    @Test
    void testIndexSeekExactWithRangeByBooleanArray() throws Exception {
        this.testIndexSeekExactWithRange((Value)Values.booleanArray((boolean[])new boolean[]{true, true}), (Value)Values.booleanArray((boolean[])new boolean[]{false, false}), (Value)Values.booleanArray((boolean[])new boolean[]{false, false}), (Value)Values.booleanArray((boolean[])new boolean[]{false, true}), (Value)Values.booleanArray((boolean[])new boolean[]{true, false}), (Value)Values.booleanArray((boolean[])new boolean[]{true, true}), (Value)Values.booleanArray((boolean[])new boolean[]{true, true, true}));
    }

    @Test
    void testIndexSeekExactWithRangeByTemporalArray() throws Exception {
        this.testIndexSeekExactWithRange((Value)CompositeIndexAccessorCompatibility.dateArray(303, 900), (Value)CompositeIndexAccessorCompatibility.dateArray(101, 900), (Value)CompositeIndexAccessorCompatibility.dateArray(111, 900), (Value)CompositeIndexAccessorCompatibility.dateArray(222, 900), (Value)CompositeIndexAccessorCompatibility.dateArray(333, 900), (Value)CompositeIndexAccessorCompatibility.dateArray(444, 900), (Value)CompositeIndexAccessorCompatibility.dateArray(555, 900));
    }

    @Test
    void testIndexSeekExactWithRangeBySpatial() throws Exception {
        this.testIndexSeekExactWithBoundingBox((Value)Values.intValue((int)100), (Value)Values.intValue((int)10), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{-10.0, -10.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{-1.0, -1.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{0.0, 0.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{1.0, 1.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{10.0, 10.0}));
    }

    private void testIndexSeekExactWithRange(Value base1, Value base2, Value obj1, Value obj2, Value obj3, Value obj4, Value obj5) throws Exception {
        Assumptions.assumeTrue((boolean)this.testSuite.supportsGranularCompositeQueries(), (String)"Assume support for granular composite queries");
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor, base1, obj1), CompositeIndexAccessorCompatibility.add(2L, this.descriptor, base1, obj2), CompositeIndexAccessorCompatibility.add(3L, this.descriptor, base1, obj3), CompositeIndexAccessorCompatibility.add(4L, this.descriptor, base1, obj4), CompositeIndexAccessorCompatibility.add(5L, this.descriptor, base1, obj5), CompositeIndexAccessorCompatibility.add(6L, this.descriptor, base2, obj1), CompositeIndexAccessorCompatibility.add(7L, this.descriptor, base2, obj2), CompositeIndexAccessorCompatibility.add(8L, this.descriptor, base2, obj3), CompositeIndexAccessorCompatibility.add(9L, this.descriptor, base2, obj4), CompositeIndexAccessorCompatibility.add(10L, this.descriptor, base2, obj5)));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.range((int)1, (Value)obj2, (boolean)true, (Value)obj4, (boolean)false)})).containsExactly((Object[])new Long[]{2L, 3L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.range((int)1, (Value)obj4, (boolean)true, null, (boolean)false)})).containsExactly((Object[])new Long[]{4L, 5L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.range((int)1, (Value)obj4, (boolean)false, null, (boolean)true)})).containsExactly((Object[])new Long[]{5L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.range((int)1, (Value)obj5, (boolean)false, (Value)obj2, (boolean)true)})).isEmpty();
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.range((int)1, null, (boolean)false, (Value)obj3, (boolean)false)})).containsExactly((Object[])new Long[]{1L, 2L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.range((int)1, null, (boolean)true, (Value)obj3, (boolean)true)})).containsExactly((Object[])new Long[]{1L, 2L, 3L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.range((int)1, (Value)obj1, (boolean)false, (Value)obj2, (boolean)true)})).containsExactly((Object[])new Long[]{2L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.range((int)1, (Value)obj1, (boolean)false, (Value)obj3, (boolean)false)})).containsExactly((Object[])new Long[]{2L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.range((int)1, (Value)obj2, (boolean)true, (Value)obj4, (boolean)false)})).containsExactly((Object[])new Long[]{7L, 8L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.range((int)1, (Value)obj4, (boolean)true, null, (boolean)false)})).containsExactly((Object[])new Long[]{9L, 10L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.range((int)1, (Value)obj4, (boolean)false, null, (boolean)true)})).containsExactly((Object[])new Long[]{10L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.range((int)1, (Value)obj5, (boolean)false, (Value)obj2, (boolean)true)})).isEmpty();
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.range((int)1, null, (boolean)false, (Value)obj3, (boolean)false)})).containsExactly((Object[])new Long[]{6L, 7L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.range((int)1, null, (boolean)true, (Value)obj3, (boolean)true)})).containsExactly((Object[])new Long[]{6L, 7L, 8L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.range((int)1, (Value)obj1, (boolean)false, (Value)obj2, (boolean)true)})).containsExactly((Object[])new Long[]{7L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.range((int)1, (Value)obj1, (boolean)false, (Value)obj3, (boolean)false)})).containsExactly((Object[])new Long[]{7L});
    }

    private void testIndexSeekExactWithBoundingBox(Value base1, Value base2, PointValue obj1, PointValue obj2, PointValue obj3, PointValue obj4, PointValue obj5) throws Exception {
        Assumptions.assumeTrue((boolean)this.testSuite.supportsGranularCompositeQueries(), (String)"Assume support for granular composite queries");
        Assumptions.assumeTrue((boolean)this.testSuite.supportsSpatial(), (String)"Assume support for spacial value types");
        Assumptions.assumeTrue((boolean)this.testSuite.supportsBoundingBoxQueries(), (String)"Assume support for bounding box queries");
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor, base1, (Value)obj1), CompositeIndexAccessorCompatibility.add(2L, this.descriptor, base1, (Value)obj2), CompositeIndexAccessorCompatibility.add(3L, this.descriptor, base1, (Value)obj3), CompositeIndexAccessorCompatibility.add(4L, this.descriptor, base1, (Value)obj4), CompositeIndexAccessorCompatibility.add(5L, this.descriptor, base1, (Value)obj5), CompositeIndexAccessorCompatibility.add(6L, this.descriptor, base2, (Value)obj1), CompositeIndexAccessorCompatibility.add(7L, this.descriptor, base2, (Value)obj2), CompositeIndexAccessorCompatibility.add(8L, this.descriptor, base2, (Value)obj3), CompositeIndexAccessorCompatibility.add(9L, this.descriptor, base2, (Value)obj4), CompositeIndexAccessorCompatibility.add(10L, this.descriptor, base2, (Value)obj5)));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.boundingBox((int)1, (PointValue)obj2, (PointValue)obj4)})).containsExactly((Object[])new Long[]{2L, 3L, 4L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.boundingBox((int)1, (PointValue)obj5, (PointValue)obj2)})).isEmpty();
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.boundingBox((int)1, (PointValue)obj1, (PointValue)obj2)})).containsExactly((Object[])new Long[]{1L, 2L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.boundingBox((int)1, (PointValue)obj1, (PointValue)obj3)})).containsExactly((Object[])new Long[]{1L, 2L, 3L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.boundingBox((int)1, (PointValue)obj2, (PointValue)obj4)})).containsExactly((Object[])new Long[]{7L, 8L, 9L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.boundingBox((int)1, (PointValue)obj5, (PointValue)obj2)})).isEmpty();
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.boundingBox((int)1, (PointValue)obj1, (PointValue)obj2)})).containsExactly((Object[])new Long[]{6L, 7L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.boundingBox((int)1, (PointValue)obj1, (PointValue)obj3)})).containsExactly((Object[])new Long[]{6L, 7L, 8L});
    }

    private void testIndexSeekExactWithRangeByBooleanType(BooleanValue base1, BooleanValue base2, BooleanValue obj1, BooleanValue obj2) throws Exception {
        Assumptions.assumeTrue((boolean)this.testSuite.supportsBooleanRangeQueries(), (String)"Assume support for boolean range queries");
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor, (Value)base1, (Value)obj1), CompositeIndexAccessorCompatibility.add(2L, this.descriptor, (Value)base1, (Value)obj2), CompositeIndexAccessorCompatibility.add(3L, this.descriptor, (Value)base2, (Value)obj1), CompositeIndexAccessorCompatibility.add(4L, this.descriptor, (Value)base2, (Value)obj2)));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.range((int)1, (Value)obj1, (boolean)true, (Value)obj2, (boolean)true)})).containsExactly((Object[])new Long[]{1L, 2L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.range((int)1, (Value)obj1, (boolean)false, (Value)obj2, (boolean)true)})).containsExactly((Object[])new Long[]{2L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.range((int)1, (Value)obj1, (boolean)true, (Value)obj2, (boolean)false)})).containsExactly((Object[])new Long[]{1L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.range((int)1, (Value)obj1, (boolean)false, (Value)obj2, (boolean)false)})).isEmpty();
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.range((int)1, null, (boolean)true, (Value)obj2, (boolean)true)})).containsExactly((Object[])new Long[]{1L, 2L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.range((int)1, (Value)obj1, (boolean)true, null, (boolean)true)})).containsExactly((Object[])new Long[]{1L, 2L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base1), PropertyIndexQuery.range((int)1, (Value)obj2, (boolean)true, (Value)obj1, (boolean)true)})).isEmpty();
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.range((int)1, (Value)obj1, (boolean)true, (Value)obj2, (boolean)true)})).containsExactly((Object[])new Long[]{3L, 4L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.range((int)1, (Value)obj1, (boolean)false, (Value)obj2, (boolean)true)})).containsExactly((Object[])new Long[]{4L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.range((int)1, (Value)obj1, (boolean)true, (Value)obj2, (boolean)false)})).containsExactly((Object[])new Long[]{3L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.range((int)1, (Value)obj1, (boolean)false, (Value)obj2, (boolean)false)})).isEmpty();
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.range((int)1, null, (boolean)true, (Value)obj2, (boolean)true)})).containsExactly((Object[])new Long[]{3L, 4L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.range((int)1, (Value)obj1, (boolean)true, null, (boolean)true)})).containsExactly((Object[])new Long[]{3L, 4L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)base2), PropertyIndexQuery.range((int)1, (Value)obj2, (boolean)true, (Value)obj1, (boolean)true)})).isEmpty();
    }

    @Test
    void testIndexSeekExactWithPrefixRangeByString() throws Exception {
        Assumptions.assumeTrue((boolean)this.testSuite.supportsGranularCompositeQueries(), (String)"Assume support for granular composite queries");
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor, "a", "a"), CompositeIndexAccessorCompatibility.add(2L, this.descriptor, "a", "A"), CompositeIndexAccessorCompatibility.add(3L, this.descriptor, "a", "apa"), CompositeIndexAccessorCompatibility.add(4L, this.descriptor, "a", "apA"), CompositeIndexAccessorCompatibility.add(5L, this.descriptor, "a", "b"), CompositeIndexAccessorCompatibility.add(6L, this.descriptor, "b", "a"), CompositeIndexAccessorCompatibility.add(7L, this.descriptor, "b", "A"), CompositeIndexAccessorCompatibility.add(8L, this.descriptor, "b", "apa"), CompositeIndexAccessorCompatibility.add(9L, this.descriptor, "b", "apA"), CompositeIndexAccessorCompatibility.add(10L, this.descriptor, "b", "b")));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)"a"), PropertyIndexQuery.stringPrefix((int)1, (TextValue)Values.stringValue((String)"a"))})).containsExactly((Object[])new Long[]{1L, 3L, 4L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)"a"), PropertyIndexQuery.stringPrefix((int)1, (TextValue)Values.stringValue((String)"A"))})).containsExactly((Object[])new Long[]{2L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)"a"), PropertyIndexQuery.stringPrefix((int)1, (TextValue)Values.stringValue((String)"ba"))})).isEmpty();
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)"a"), PropertyIndexQuery.stringPrefix((int)1, (TextValue)Values.stringValue((String)""))})).containsExactly((Object[])new Long[]{1L, 2L, 3L, 4L, 5L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)"b"), PropertyIndexQuery.stringPrefix((int)1, (TextValue)Values.stringValue((String)"a"))})).containsExactly((Object[])new Long[]{6L, 8L, 9L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)"b"), PropertyIndexQuery.stringPrefix((int)1, (TextValue)Values.stringValue((String)"A"))})).containsExactly((Object[])new Long[]{7L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)"b"), PropertyIndexQuery.stringPrefix((int)1, (TextValue)Values.stringValue((String)"ba"))})).isEmpty();
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)"b"), PropertyIndexQuery.stringPrefix((int)1, (TextValue)Values.stringValue((String)""))})).containsExactly((Object[])new Long[]{6L, 7L, 8L, 9L, 10L});
    }

    @Test
    void testIndexSeekPrefixRangeWithExistsByString() throws Exception {
        Assumptions.assumeTrue((boolean)this.testSuite.supportsGranularCompositeQueries(), (String)"Assume support for granular composite queries");
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor, "a", 1), CompositeIndexAccessorCompatibility.add(2L, this.descriptor, "A", DateValue.epochDate((long)2L)), CompositeIndexAccessorCompatibility.add(3L, this.descriptor, "apa", "..."), CompositeIndexAccessorCompatibility.add(4L, this.descriptor, "apA", "someString"), CompositeIndexAccessorCompatibility.add(5L, this.descriptor, "b", true), CompositeIndexAccessorCompatibility.add(6L, this.descriptor, "a", 100), CompositeIndexAccessorCompatibility.add(7L, this.descriptor, "A", DateValue.epochDate((long)200L)), CompositeIndexAccessorCompatibility.add(8L, this.descriptor, "apa", "!!!"), CompositeIndexAccessorCompatibility.add(9L, this.descriptor, "apA", "someOtherString"), CompositeIndexAccessorCompatibility.add(10L, this.descriptor, "b", false)));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)0, (TextValue)Values.stringValue((String)"a")), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{1L, 3L, 4L, 6L, 8L, 9L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)0, (TextValue)Values.stringValue((String)"A")), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{2L, 7L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)0, (TextValue)Values.stringValue((String)"ba")), PropertyIndexQuery.exists((int)1)})).isEmpty();
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)0, (TextValue)Values.stringValue((String)"")), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L});
    }

    @Test
    void testIndexSeekExactWithExistsByString() throws Exception {
        this.testIndexSeekExactWithExists("a", "b");
    }

    @Test
    void testIndexSeekExactWithExistsByNumber() throws Exception {
        this.testIndexSeekExactWithExists(303, 101);
    }

    @Test
    void testIndexSeekExactWithExistsByTemporal() throws Exception {
        this.testIndexSeekExactWithExists((Value)DateValue.epochDate((long)303L), (Value)DateValue.epochDate((long)101L));
    }

    @Test
    void testIndexSeekExactWithExistsByBoolean() throws Exception {
        this.testIndexSeekExactWithExists(true, false);
    }

    @Test
    void testIndexSeekExactWithExistsByStringArray() throws Exception {
        this.testIndexSeekExactWithExists(new String[]{"a", "c"}, new String[]{"b", "c"});
    }

    @Test
    void testIndexSeekExactWithExistsByNumberArray() throws Exception {
        this.testIndexSeekExactWithExists(new long[]{303L, 900L}, new long[]{101L, 900L});
    }

    @Test
    void testIndexSeekExactWithExistsByBooleanArray() throws Exception {
        this.testIndexSeekExactWithExists(new boolean[]{true, true}, new boolean[]{false, true});
    }

    @Test
    void testIndexSeekExactWithExistsByTemporalArray() throws Exception {
        this.testIndexSeekExactWithExists((Value)CompositeIndexAccessorCompatibility.dateArray(303, 900), (Value)CompositeIndexAccessorCompatibility.dateArray(101, 900));
    }

    @Test
    void testIndexSeekExactWithExistsBySpatial() throws Exception {
        this.testIndexSeekExactWithExists((Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{100.0, 90.0}), (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{0.0, 0.0}));
    }

    @Test
    void testIndexSeekExactWithExistsBySpatialArray() throws Exception {
        this.testIndexSeekExactWithExists((Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{100.0, 100.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{101.0, 101.0})}), (Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{0.0, 0.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{1.0, 1.0})}));
    }

    private void testIndexSeekExactWithExists(Object a, Object b) throws Exception {
        this.testIndexSeekExactWithExists(Values.of((Object)a), Values.of((Object)b));
    }

    private void testIndexSeekExactWithExists(Value a, Value b) throws Exception {
        Assumptions.assumeTrue((boolean)this.testSuite.supportsGranularCompositeQueries(), (String)"Assume support for granular composite queries");
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor, a, Values.of((Object)1)), CompositeIndexAccessorCompatibility.add(2L, this.descriptor, b, Values.of((Object)"abv")), CompositeIndexAccessorCompatibility.add(3L, this.descriptor, a, Values.of((Object)false))));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)a), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{1L, 3L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)b), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{2L});
    }

    @Test
    void testIndexSeekRangeWithExistsByString() throws Exception {
        this.testIndexSeekRangeWithExists("Anabelle", "Anna", "Bob", "Harriet", "William");
    }

    @Test
    void testIndexSeekRangeWithExistsByNumber() throws Exception {
        this.testIndexSeekRangeWithExists(-5, 0, 5.5, 10.0, 100.0);
    }

    @Test
    void testIndexSeekRangeWithExistsByTemporal() throws Exception {
        DateTimeValue d1 = DateTimeValue.datetime((long)9999L, (long)100L, (ZoneId)ZoneId.of("+18:00"));
        DateTimeValue d2 = DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("UTC"));
        DateTimeValue d3 = DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("+01:00"));
        DateTimeValue d4 = DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("Europe/Stockholm"));
        DateTimeValue d5 = DateTimeValue.datetime((long)10000L, (long)100L, (ZoneId)ZoneId.of("+03:00"));
        this.testIndexSeekRangeWithExists((Value)d1, (Value)d2, (Value)d3, (Value)d4, (Value)d5);
    }

    @Test
    void testIndexSeekRangeWithExistsByBoolean() throws Exception {
        Assumptions.assumeTrue((boolean)this.testSuite.supportsGranularCompositeQueries(), (String)"Assume support for granular composite queries");
        Assumptions.assumeTrue((boolean)this.testSuite.supportsBooleanRangeQueries(), (String)"Assume support for boolean range queries");
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor, false, "someString"), CompositeIndexAccessorCompatibility.add(2L, this.descriptor, true, 1000)));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)0, (Value)BooleanValue.FALSE, (boolean)true, (Value)BooleanValue.TRUE, (boolean)true), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{1L, 2L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)0, (Value)BooleanValue.FALSE, (boolean)false, (Value)BooleanValue.TRUE, (boolean)true), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{2L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)0, (Value)BooleanValue.FALSE, (boolean)true, (Value)BooleanValue.TRUE, (boolean)false), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{1L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)0, (Value)BooleanValue.FALSE, (boolean)false, (Value)BooleanValue.TRUE, (boolean)false), PropertyIndexQuery.exists((int)1)})).isEmpty();
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)0, null, (boolean)true, (Value)BooleanValue.TRUE, (boolean)true), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{1L, 2L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)0, (Value)BooleanValue.FALSE, (boolean)true, null, (boolean)true), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{1L, 2L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)0, (Value)BooleanValue.TRUE, (boolean)true, (Value)BooleanValue.FALSE, (boolean)true), PropertyIndexQuery.exists((int)1)})).isEmpty();
    }

    @Test
    void testIndexSeekRangeWithExistsByStringArray() throws Exception {
        this.testIndexSeekRangeWithExists(new String[]{"Anabelle", "Anabelle"}, new String[]{"Anabelle", "Anablo"}, new String[]{"Anna", "Anabelle"}, new String[]{"Anna", "Anablo"}, new String[]{"Bob"});
    }

    @Test
    void testIndexSeekRangeWithExistsByNumberArray() throws Exception {
        this.testIndexSeekRangeWithExists(new long[]{303L, 303L}, new long[]{303L, 404L}, new long[]{600L, 303L}, new long[]{600L, 404L}, new long[]{900L});
    }

    @Test
    void testIndexSeekRangeWithExistsByBooleanArray() throws Exception {
        this.testIndexSeekRangeWithExists(new boolean[]{false, false}, new boolean[]{false, true}, new boolean[]{true, false}, new boolean[]{true, true}, new boolean[]{true, true, false});
    }

    @Test
    void testIndexSeekRangeWithExistsByTemporalArray() throws Exception {
        this.testIndexSeekRangeWithExists((Value)CompositeIndexAccessorCompatibility.dateArray(303, 303), (Value)CompositeIndexAccessorCompatibility.dateArray(303, 404), (Value)CompositeIndexAccessorCompatibility.dateArray(404, 303), (Value)CompositeIndexAccessorCompatibility.dateArray(404, 404), (Value)CompositeIndexAccessorCompatibility.dateArray(404, 404, 303));
    }

    @Test
    void testIndexSeekRangeWithExistsBySpatial() throws Exception {
        this.testIndexSeekBoundingBoxWithExists(Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{0.0, 0.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{1.0, 1.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{2.0, 2.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{3.0, 3.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{4.0, 4.0}));
    }

    @Test
    void testExactMatchOnRandomCompositeValues() throws Exception {
        ValueType[] types = this.randomSetOfSupportedTypes();
        RandomValues randomValues = this.randomValues(2);
        ArrayList<ValueIndexEntryUpdate> updates = new ArrayList<ValueIndexEntryUpdate>();
        HashSet<ValueTuple> duplicateChecker = new HashSet<ValueTuple>();
        for (long id = 0L; id < 10000L; ++id) {
            ValueIndexEntryUpdate update;
            while (!duplicateChecker.add(ValueTuple.of((Value[])(update = CompositeIndexAccessorCompatibility.add(id, this.descriptor, randomValues.nextValueOfTypes(types), randomValues.nextValueOfTypes(types))).values()))) {
            }
            updates.add(update);
        }
        this.updateAndCommit(updates);
        InMemoryTokens tokenNameLookup = new InMemoryTokens();
        for (ValueIndexEntryUpdate update : updates) {
            List<Long> hits = this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)update.values()[0]), PropertyIndexQuery.exact((int)1, (Object)update.values()[1])});
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)hits.size(), (String)(update.describe((TokenNameLookup)tokenNameLookup) + " " + String.valueOf(hits)));
            Assertions.assertThat((Long)((Long)Iterables.single(hits))).isEqualTo(update.getEntityId());
        }
    }

    private void testIndexSeekRangeWithExists(Object obj1, Object obj2, Object obj3, Object obj4, Object obj5) throws Exception {
        this.testIndexSeekRangeWithExists(Values.of((Object)obj1), Values.of((Object)obj2), Values.of((Object)obj3), Values.of((Object)obj4), Values.of((Object)obj5));
    }

    private void testIndexSeekRangeWithExists(Value obj1, Value obj2, Value obj3, Value obj4, Value obj5) throws Exception {
        Assumptions.assumeTrue((boolean)this.testSuite.supportsGranularCompositeQueries(), (String)"Assume support for granular composite queries");
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor, obj1, Values.of((Object)100)), CompositeIndexAccessorCompatibility.add(2L, this.descriptor, obj2, Values.of((Object)"someString")), CompositeIndexAccessorCompatibility.add(3L, this.descriptor, obj3, Values.of((Object)DateValue.epochDate((long)300L))), CompositeIndexAccessorCompatibility.add(4L, this.descriptor, obj4, Values.of((Object)true)), CompositeIndexAccessorCompatibility.add(5L, this.descriptor, obj5, Values.of((Object)42))));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)0, (Value)obj2, (boolean)true, (Value)obj4, (boolean)false), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{2L, 3L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)0, (Value)obj4, (boolean)true, null, (boolean)false), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{4L, 5L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)0, (Value)obj4, (boolean)false, null, (boolean)true), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{5L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)0, (Value)obj5, (boolean)false, (Value)obj2, (boolean)true), PropertyIndexQuery.exists((int)1)})).isEmpty();
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)0, null, (boolean)false, (Value)obj3, (boolean)false), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{1L, 2L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)0, null, (boolean)true, (Value)obj3, (boolean)true), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{1L, 2L, 3L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)0, (Value)obj1, (boolean)false, (Value)obj2, (boolean)true), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{2L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.range((int)0, (Value)obj1, (boolean)false, (Value)obj3, (boolean)false), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{2L});
    }

    private void testIndexSeekBoundingBoxWithExists(PointValue obj1, PointValue obj2, PointValue obj3, PointValue obj4, PointValue obj5) throws Exception {
        Assumptions.assumeTrue((boolean)this.testSuite.supportsGranularCompositeQueries(), (String)"Assume support for granular composite queries");
        Assumptions.assumeTrue((boolean)this.testSuite.supportsSpatial(), (String)"Assume support for spacial value types");
        Assumptions.assumeTrue((boolean)this.testSuite.supportsBoundingBoxQueries(), (String)"Assume support for bounding box queries");
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor, (Value)obj1, Values.of((Object)100)), CompositeIndexAccessorCompatibility.add(2L, this.descriptor, (Value)obj2, Values.of((Object)"someString")), CompositeIndexAccessorCompatibility.add(3L, this.descriptor, (Value)obj3, Values.of((Object)DateValue.epochDate((long)300L))), CompositeIndexAccessorCompatibility.add(4L, this.descriptor, (Value)obj4, Values.of((Object)true)), CompositeIndexAccessorCompatibility.add(5L, this.descriptor, (Value)obj5, Values.of((Object)42))));
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.boundingBox((int)0, (PointValue)obj2, (PointValue)obj4), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{2L, 3L, 4L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.boundingBox((int)0, (PointValue)obj5, (PointValue)obj2), PropertyIndexQuery.exists((int)1)})).isEmpty();
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.boundingBox((int)0, (PointValue)obj1, (PointValue)obj2), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{1L, 2L});
        Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.boundingBox((int)0, (PointValue)obj1, (PointValue)obj3), PropertyIndexQuery.exists((int)1)})).containsExactly((Object[])new Long[]{1L, 2L, 3L});
    }

    @Test
    void shouldRangeSeekInOrderNumberAscending() throws Exception {
        Integer o0 = 0;
        Integer o1 = 1;
        Integer o2 = 2;
        Integer o3 = 3;
        Integer o4 = 4;
        Integer o5 = 5;
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderNumberDescending() throws Exception {
        Integer o0 = 0;
        Integer o1 = 1;
        Integer o2 = 2;
        Integer o3 = 3;
        Integer o4 = 4;
        Integer o5 = 5;
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderStringAscending() throws Exception {
        String o0 = "0";
        String o1 = "1";
        String o2 = "2";
        String o3 = "3";
        String o4 = "4";
        String o5 = "5";
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderStringDescending() throws Exception {
        String o0 = "0";
        String o1 = "1";
        String o2 = "2";
        String o3 = "3";
        String o4 = "4";
        String o5 = "5";
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingDate() throws Exception {
        LocalDate o0 = DateValue.epochDateRaw((long)0L);
        LocalDate o1 = DateValue.epochDateRaw((long)1L);
        LocalDate o2 = DateValue.epochDateRaw((long)2L);
        LocalDate o3 = DateValue.epochDateRaw((long)3L);
        LocalDate o4 = DateValue.epochDateRaw((long)4L);
        LocalDate o5 = DateValue.epochDateRaw((long)5L);
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingDate() throws Exception {
        LocalDate o0 = DateValue.epochDateRaw((long)0L);
        LocalDate o1 = DateValue.epochDateRaw((long)1L);
        LocalDate o2 = DateValue.epochDateRaw((long)2L);
        LocalDate o3 = DateValue.epochDateRaw((long)3L);
        LocalDate o4 = DateValue.epochDateRaw((long)4L);
        LocalDate o5 = DateValue.epochDateRaw((long)5L);
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingLocalTime() throws Exception {
        LocalTime o0 = LocalTimeValue.localTimeRaw((long)0L);
        LocalTime o1 = LocalTimeValue.localTimeRaw((long)1L);
        LocalTime o2 = LocalTimeValue.localTimeRaw((long)2L);
        LocalTime o3 = LocalTimeValue.localTimeRaw((long)3L);
        LocalTime o4 = LocalTimeValue.localTimeRaw((long)4L);
        LocalTime o5 = LocalTimeValue.localTimeRaw((long)5L);
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingLocalTime() throws Exception {
        LocalTime o0 = LocalTimeValue.localTimeRaw((long)0L);
        LocalTime o1 = LocalTimeValue.localTimeRaw((long)1L);
        LocalTime o2 = LocalTimeValue.localTimeRaw((long)2L);
        LocalTime o3 = LocalTimeValue.localTimeRaw((long)3L);
        LocalTime o4 = LocalTimeValue.localTimeRaw((long)4L);
        LocalTime o5 = LocalTimeValue.localTimeRaw((long)5L);
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingTime() throws Exception {
        OffsetTime o0 = TimeValue.timeRaw((long)0L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o1 = TimeValue.timeRaw((long)1L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o2 = TimeValue.timeRaw((long)2L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o3 = TimeValue.timeRaw((long)3L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o4 = TimeValue.timeRaw((long)4L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o5 = TimeValue.timeRaw((long)5L, (ZoneOffset)ZoneOffset.ofHours(0));
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingTime() throws Exception {
        OffsetTime o0 = TimeValue.timeRaw((long)0L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o1 = TimeValue.timeRaw((long)1L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o2 = TimeValue.timeRaw((long)2L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o3 = TimeValue.timeRaw((long)3L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o4 = TimeValue.timeRaw((long)4L, (ZoneOffset)ZoneOffset.ofHours(0));
        OffsetTime o5 = TimeValue.timeRaw((long)5L, (ZoneOffset)ZoneOffset.ofHours(0));
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingLocalDateTime() throws Exception {
        LocalDateTime o0 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)0L);
        LocalDateTime o1 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)1L);
        LocalDateTime o2 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)2L);
        LocalDateTime o3 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)3L);
        LocalDateTime o4 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)4L);
        LocalDateTime o5 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)5L);
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingLocalDateTime() throws Exception {
        LocalDateTime o0 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)0L);
        LocalDateTime o1 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)1L);
        LocalDateTime o2 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)2L);
        LocalDateTime o3 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)3L);
        LocalDateTime o4 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)4L);
        LocalDateTime o5 = LocalDateTimeValue.localDateTimeRaw((long)10L, (long)5L);
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingDateTime() throws Exception {
        ZonedDateTime o0 = DateTimeValue.datetimeRaw((long)1L, (long)0L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o1 = DateTimeValue.datetimeRaw((long)1L, (long)1L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o2 = DateTimeValue.datetimeRaw((long)1L, (long)2L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o3 = DateTimeValue.datetimeRaw((long)1L, (long)3L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o4 = DateTimeValue.datetimeRaw((long)1L, (long)4L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o5 = DateTimeValue.datetimeRaw((long)1L, (long)5L, (ZoneId)ZoneId.of("UTC"));
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingDateTime() throws Exception {
        ZonedDateTime o0 = DateTimeValue.datetimeRaw((long)1L, (long)0L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o1 = DateTimeValue.datetimeRaw((long)1L, (long)1L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o2 = DateTimeValue.datetimeRaw((long)1L, (long)2L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o3 = DateTimeValue.datetimeRaw((long)1L, (long)3L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o4 = DateTimeValue.datetimeRaw((long)1L, (long)4L, (ZoneId)ZoneId.of("UTC"));
        ZonedDateTime o5 = DateTimeValue.datetimeRaw((long)1L, (long)5L, (ZoneId)ZoneId.of("UTC"));
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingNumberArray() throws Exception {
        int[] o0 = new int[]{0};
        int[] o1 = new int[]{1};
        int[] o2 = new int[]{2};
        int[] o3 = new int[]{3};
        int[] o4 = new int[]{4};
        int[] o5 = new int[]{5};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingNumberArray() throws Exception {
        int[] o0 = new int[]{0};
        int[] o1 = new int[]{1};
        int[] o2 = new int[]{2};
        int[] o3 = new int[]{3};
        int[] o4 = new int[]{4};
        int[] o5 = new int[]{5};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingStringArray() throws Exception {
        String[] o0 = new String[]{"0"};
        String[] o1 = new String[]{"1"};
        String[] o2 = new String[]{"2"};
        String[] o3 = new String[]{"3"};
        String[] o4 = new String[]{"4"};
        String[] o5 = new String[]{"5"};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingStringArray() throws Exception {
        String[] o0 = new String[]{"0"};
        String[] o1 = new String[]{"1"};
        String[] o2 = new String[]{"2"};
        String[] o3 = new String[]{"3"};
        String[] o4 = new String[]{"4"};
        String[] o5 = new String[]{"5"};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingBooleanArray() throws Exception {
        boolean[] o0 = new boolean[]{false};
        boolean[] o1 = new boolean[]{false, false};
        boolean[] o2 = new boolean[]{false, true};
        boolean[] o3 = new boolean[]{true};
        boolean[] o4 = new boolean[]{true, false};
        boolean[] o5 = new boolean[]{true, true};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingBooleanArray() throws Exception {
        boolean[] o0 = new boolean[]{false};
        boolean[] o1 = new boolean[]{false, false};
        boolean[] o2 = new boolean[]{false, true};
        boolean[] o3 = new boolean[]{true};
        boolean[] o4 = new boolean[]{true, false};
        boolean[] o5 = new boolean[]{true, true};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingDateTimeArray() throws Exception {
        ZonedDateTime[] o0 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 0, ZoneId.of("UTC"))};
        ZonedDateTime[] o1 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 1, ZoneId.of("UTC"))};
        ZonedDateTime[] o2 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 2, ZoneId.of("UTC"))};
        ZonedDateTime[] o3 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 3, ZoneId.of("UTC"))};
        ZonedDateTime[] o4 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 4, ZoneId.of("UTC"))};
        ZonedDateTime[] o5 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 5, ZoneId.of("UTC"))};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingDateTimeArray() throws Exception {
        ZonedDateTime[] o0 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 0, ZoneId.of("UTC"))};
        ZonedDateTime[] o1 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 1, ZoneId.of("UTC"))};
        ZonedDateTime[] o2 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 2, ZoneId.of("UTC"))};
        ZonedDateTime[] o3 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 3, ZoneId.of("UTC"))};
        ZonedDateTime[] o4 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 4, ZoneId.of("UTC"))};
        ZonedDateTime[] o5 = new ZonedDateTime[]{ZonedDateTime.of(10, 10, 10, 10, 10, 10, 5, ZoneId.of("UTC"))};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingLocalDateTimeArray() throws Exception {
        LocalDateTime[] o0 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 0)};
        LocalDateTime[] o1 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 1)};
        LocalDateTime[] o2 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 2)};
        LocalDateTime[] o3 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 3)};
        LocalDateTime[] o4 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 4)};
        LocalDateTime[] o5 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 5)};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingLocalDateTimeArray() throws Exception {
        LocalDateTime[] o0 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 0)};
        LocalDateTime[] o1 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 1)};
        LocalDateTime[] o2 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 2)};
        LocalDateTime[] o3 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 3)};
        LocalDateTime[] o4 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 4)};
        LocalDateTime[] o5 = new LocalDateTime[]{LocalDateTime.of(10, 10, 10, 10, 10, 10, 5)};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingTimeArray() throws Exception {
        OffsetTime[] o0 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 0, ZoneOffset.ofHours(0))};
        OffsetTime[] o1 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 1, ZoneOffset.ofHours(0))};
        OffsetTime[] o2 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 2, ZoneOffset.ofHours(0))};
        OffsetTime[] o3 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 3, ZoneOffset.ofHours(0))};
        OffsetTime[] o4 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 4, ZoneOffset.ofHours(0))};
        OffsetTime[] o5 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 5, ZoneOffset.ofHours(0))};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingTimeArray() throws Exception {
        OffsetTime[] o0 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 0, ZoneOffset.ofHours(0))};
        OffsetTime[] o1 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 1, ZoneOffset.ofHours(0))};
        OffsetTime[] o2 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 2, ZoneOffset.ofHours(0))};
        OffsetTime[] o3 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 3, ZoneOffset.ofHours(0))};
        OffsetTime[] o4 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 4, ZoneOffset.ofHours(0))};
        OffsetTime[] o5 = new OffsetTime[]{OffsetTime.of(10, 10, 10, 5, ZoneOffset.ofHours(0))};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingDateArray() throws Exception {
        LocalDate[] o0 = new LocalDate[]{LocalDate.of(10, 10, 1)};
        LocalDate[] o1 = new LocalDate[]{LocalDate.of(10, 10, 2)};
        LocalDate[] o2 = new LocalDate[]{LocalDate.of(10, 10, 3)};
        LocalDate[] o3 = new LocalDate[]{LocalDate.of(10, 10, 4)};
        LocalDate[] o4 = new LocalDate[]{LocalDate.of(10, 10, 5)};
        LocalDate[] o5 = new LocalDate[]{LocalDate.of(10, 10, 6)};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingDateArray() throws Exception {
        LocalDate[] o0 = new LocalDate[]{LocalDate.of(10, 10, 1)};
        LocalDate[] o1 = new LocalDate[]{LocalDate.of(10, 10, 2)};
        LocalDate[] o2 = new LocalDate[]{LocalDate.of(10, 10, 3)};
        LocalDate[] o3 = new LocalDate[]{LocalDate.of(10, 10, 4)};
        LocalDate[] o4 = new LocalDate[]{LocalDate.of(10, 10, 5)};
        LocalDate[] o5 = new LocalDate[]{LocalDate.of(10, 10, 6)};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderAscendingLocalTimeArray() throws Exception {
        LocalTime[] o0 = new LocalTime[]{LocalTime.of(10, 0)};
        LocalTime[] o1 = new LocalTime[]{LocalTime.of(10, 1)};
        LocalTime[] o2 = new LocalTime[]{LocalTime.of(10, 2)};
        LocalTime[] o3 = new LocalTime[]{LocalTime.of(10, 3)};
        LocalTime[] o4 = new LocalTime[]{LocalTime.of(10, 4)};
        LocalTime[] o5 = new LocalTime[]{LocalTime.of(10, 5)};
        this.shouldSeekInOrderExactWithRange(IndexOrder.ASCENDING, o0, o1, o2, o3, o4, o5);
    }

    @Test
    void shouldRangeSeekInOrderDescendingLocalTimeArray() throws Exception {
        LocalTime[] o0 = new LocalTime[]{LocalTime.of(10, 0)};
        LocalTime[] o1 = new LocalTime[]{LocalTime.of(10, 1)};
        LocalTime[] o2 = new LocalTime[]{LocalTime.of(10, 2)};
        LocalTime[] o3 = new LocalTime[]{LocalTime.of(10, 3)};
        LocalTime[] o4 = new LocalTime[]{LocalTime.of(10, 4)};
        LocalTime[] o5 = new LocalTime[]{LocalTime.of(10, 5)};
        this.shouldSeekInOrderExactWithRange(IndexOrder.DESCENDING, o0, o1, o2, o3, o4, o5);
    }

    private void shouldSeekInOrderExactWithRange(IndexOrder order, Object o0, Object o1, Object o2, Object o3, Object o4, Object o5) throws Exception {
        Integer baseValue = 1;
        PropertyIndexQuery.ExactPredicate exact = PropertyIndexQuery.exact((int)100, (Object)baseValue);
        PropertyIndexQuery.RangePredicate range = PropertyIndexQuery.range((int)200, (Value)Values.of((Object)o0), (boolean)true, (Value)Values.of((Object)o5), (boolean)true);
        if (order == IndexOrder.ASCENDING || order == IndexOrder.DESCENDING) {
            Assumptions.assumeTrue((boolean)this.descriptor.getCapability().supportsOrdering(), (String)("Assume support for order " + String.valueOf(order)));
        }
        this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor, baseValue, o0), CompositeIndexAccessorCompatibility.add(1L, this.descriptor, baseValue, o5), CompositeIndexAccessorCompatibility.add(1L, this.descriptor, baseValue, o1), CompositeIndexAccessorCompatibility.add(1L, this.descriptor, baseValue, o4), CompositeIndexAccessorCompatibility.add(1L, this.descriptor, baseValue, o2), CompositeIndexAccessorCompatibility.add(1L, this.descriptor, baseValue, o3)));
        try (SimpleEntityValueClient client = new SimpleEntityValueClient();
             AutoCloseable ignored = this.query(client, order, new PropertyIndexQuery[]{exact, range});){
            List<Long> seenIds = CompositeIndexAccessorCompatibility.assertClientReturnValuesInOrder(client, order);
            Assertions.assertThat((int)seenIds.size()).isEqualTo(6);
        }
    }

    @Test
    void mustThrowOnIllegalCompositeQueriesAndMustNotThrowOnLegalQueries() throws Exception {
        Assumptions.assumeTrue((boolean)this.testSuite.supportsGranularCompositeQueries(), (String)"Assume support for granular composite queries");
        Value someValue = Values.of((Object)true);
        TextValue someString = Values.stringValue((String)"");
        PropertyIndexQuery.AllEntriesPredicate allEntries = PropertyIndexQuery.allEntries();
        PropertyIndexQuery.ExactPredicate firstExact = PropertyIndexQuery.exact((int)100, (Object)someValue);
        PropertyIndexQuery.RangePredicate firstRange = PropertyIndexQuery.range((int)100, (Value)someValue, (boolean)true, (Value)someValue, (boolean)true);
        PropertyIndexQuery.StringPrefixPredicate firstPrefix = PropertyIndexQuery.stringPrefix((int)100, (TextValue)someString);
        PropertyIndexQuery.ExistsPredicate firstExist = PropertyIndexQuery.exists((int)100);
        PropertyIndexQuery.StringSuffixPredicate firstSuffix = PropertyIndexQuery.stringSuffix((int)100, (TextValue)someString);
        PropertyIndexQuery.StringContainsPredicate firstContains = PropertyIndexQuery.stringContains((int)100, (TextValue)someString);
        PropertyIndexQuery.ExactPredicate secondExact = PropertyIndexQuery.exact((int)200, (Object)someValue);
        PropertyIndexQuery.RangePredicate secondRange = PropertyIndexQuery.range((int)200, (Value)someValue, (boolean)true, (Value)someValue, (boolean)true);
        PropertyIndexQuery.ExistsPredicate secondExist = PropertyIndexQuery.exists((int)200);
        PropertyIndexQuery.StringPrefixPredicate secondPrefix = PropertyIndexQuery.stringPrefix((int)100, (TextValue)someString);
        PropertyIndexQuery.StringSuffixPredicate secondSuffix = PropertyIndexQuery.stringSuffix((int)100, (TextValue)someString);
        PropertyIndexQuery.StringContainsPredicate secondContains = PropertyIndexQuery.stringContains((int)100, (TextValue)someString);
        List<Pair> queries = Arrays.asList(Pair.of((Object)new PropertyIndexQuery[]{allEntries, allEntries}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{allEntries, secondExist}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{allEntries, secondExact}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{allEntries, secondRange}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{allEntries, secondPrefix}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{allEntries, secondSuffix}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{allEntries, secondContains}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstExist, allEntries}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstExist, secondExist}, (Object)true), Pair.of((Object)new PropertyIndexQuery[]{firstExist, secondExact}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstExist, secondRange}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstExist, secondPrefix}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstExist, secondSuffix}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstExist, secondContains}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstExact, allEntries}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstExact, secondExist}, (Object)true), Pair.of((Object)new PropertyIndexQuery[]{firstExact, secondExact}, (Object)true), Pair.of((Object)new PropertyIndexQuery[]{firstExact, secondRange}, (Object)true), Pair.of((Object)new PropertyIndexQuery[]{firstExact, secondPrefix}, (Object)true), Pair.of((Object)new PropertyIndexQuery[]{firstExact, secondSuffix}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstExact, secondContains}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstRange, allEntries}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstRange, secondExist}, (Object)true), Pair.of((Object)new PropertyIndexQuery[]{firstRange, secondExact}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstRange, secondRange}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstRange, secondPrefix}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstRange, secondSuffix}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstRange, secondContains}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstPrefix, allEntries}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstPrefix, secondExist}, (Object)true), Pair.of((Object)new PropertyIndexQuery[]{firstPrefix, secondExact}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstPrefix, secondRange}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstPrefix, secondPrefix}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstPrefix, secondSuffix}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstPrefix, secondContains}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstSuffix, allEntries}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstSuffix, secondExist}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstSuffix, secondExact}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstSuffix, secondRange}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstSuffix, secondPrefix}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstSuffix, secondSuffix}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstSuffix, secondContains}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstContains, allEntries}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstContains, secondExist}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstContains, secondExact}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstContains, secondRange}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstContains, secondPrefix}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstContains, secondSuffix}, (Object)false), Pair.of((Object)new PropertyIndexQuery[]{firstContains, secondContains}, (Object)false));
        try (SimpleEntityValueClient client = new SimpleEntityValueClient();
             ValueIndexReader reader = this.accessor.newValueReader(IndexUsageTracking.NO_USAGE_TRACKING);){
            for (Pair pair : queries) {
                PropertyIndexQuery[] theQuery = (PropertyIndexQuery[])pair.first();
                Boolean legal = (Boolean)pair.other();
                if (legal.booleanValue()) {
                    reader.query((IndexProgressor.EntityValueClient)client, QueryContext.NULL_CONTEXT, CursorContext.NULL_CONTEXT, IndexQueryConstraints.unconstrained(), theQuery);
                    continue;
                }
                AbstractThrowableAssert exceptionAssert = (AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> reader.query((IndexProgressor.EntityValueClient)client, QueryContext.NULL_CONTEXT, CursorContext.NULL_CONTEXT, IndexQueryConstraints.unconstrained(), theQuery)).isInstanceOf(IndexNotApplicableKernelException.class);
                if (!this.testSuite.supportsContainsAndEndsWithQueries() && this.hasContainsOrEndsWithQuery(theQuery)) {
                    exceptionAssert.hasMessageContaining("Tried to query index with illegal query.");
                    continue;
                }
                exceptionAssert.hasMessageContaining("Tried to query index with illegal composite query.");
            }
        }
    }

    private boolean hasContainsOrEndsWithQuery(PropertyIndexQuery ... query) {
        for (PropertyIndexQuery predicate : query) {
            switch (predicate.type()) {
                case STRING_CONTAINS: 
                case STRING_SUFFIX: {
                    return true;
                }
            }
        }
        return false;
    }

    @Test
    void shouldUpdateEntries() throws Exception {
        ValueType[] valueTypes = this.testSuite.supportedValueTypes();
        RandomValues randomValues = this.randomValues(2);
        long entityId = this.random.nextLong(1000000000L);
        for (ValueType valueType : valueTypes) {
            Value[] newValue;
            Value[] value = new Value[]{randomValues.nextValueOfType(valueType), randomValues.nextValueOfType(valueType)};
            this.updateAndCommit(Collections.singletonList(IndexEntryUpdate.add((long)entityId, (IndexDescriptor)this.descriptor, (Value[])value)));
            org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(entityId), this.query(CompositeIndexAccessorCompatibility.exactQuery(value)));
            do {
                newValue = new Value[]{randomValues.nextValueOfType(valueType), randomValues.nextValueOfType(valueType)};
            } while (ValueTuple.of((Value[])value).equals((Object)ValueTuple.of((Value[])newValue)));
            this.updateAndCommit(Collections.singletonList(IndexEntryUpdate.change((long)entityId, (IndexDescriptor)this.descriptor, (Value[])value, (Value[])newValue)));
            org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), this.query(CompositeIndexAccessorCompatibility.exactQuery(value)));
            org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(entityId), this.query(CompositeIndexAccessorCompatibility.exactQuery(newValue)));
        }
    }

    @Test
    void shouldRemoveEntries() throws Exception {
        ValueType[] valueTypes = this.testSuite.supportedValueTypes();
        RandomValues randomValues = this.randomValues(2);
        long entityId = this.random.nextLong(1000000000L);
        for (ValueType valueType : valueTypes) {
            Value[] value = new Value[]{randomValues.nextValueOfType(valueType), randomValues.nextValueOfType(valueType)};
            this.updateAndCommit(Collections.singletonList(IndexEntryUpdate.add((long)entityId, (IndexDescriptor)this.descriptor, (Value[])value)));
            org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(entityId), this.query(CompositeIndexAccessorCompatibility.exactQuery(value)));
            this.updateAndCommit(Collections.singletonList(IndexEntryUpdate.remove((long)entityId, (IndexDescriptor)this.descriptor, (Value[])value)));
            org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), this.query(CompositeIndexAccessorCompatibility.exactQuery(value)));
        }
    }

    private static PropertyIndexQuery[] exactQuery(Value[] values) {
        return (PropertyIndexQuery[])Stream.of(values).map(v -> PropertyIndexQuery.exact((int)0, (Object)v)).toArray(PropertyIndexQuery[]::new);
    }

    private static ArrayValue dateArray(int ... epochDays) {
        LocalDate[] localDates = new LocalDate[epochDays.length];
        for (int i = 0; i < epochDays.length; ++i) {
            localDates[i] = LocalDate.ofEpochDay(epochDays[i]);
        }
        return Values.dateArray((LocalDate[])localDates);
    }

    private static ValueIndexEntryUpdate add(long nodeId, IndexDescriptor indexDescriptor, Object value1, Object value2) {
        return CompositeIndexAccessorCompatibility.add(nodeId, indexDescriptor, Values.of((Object)value1), Values.of((Object)value2));
    }

    private static ValueIndexEntryUpdate add(long nodeId, IndexDescriptor indexDescriptor, Value value1, Value value2) {
        return IndexEntryUpdate.add((long)nodeId, (IndexDescriptor)indexDescriptor, (Value[])new Value[]{value1, value2});
    }

    static abstract class Unique
    extends CompositeIndexAccessorCompatibility {
        Unique(PropertyIndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1000, (int[])new int[]{100, 200})));
        }

        @Test
        void closingAnOnlineIndexUpdaterMustNotThrowEvenIfItHasBeenFedConflictingData() throws Exception {
            this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor, "a", "a"), CompositeIndexAccessorCompatibility.add(2L, this.descriptor, "a", "a")));
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)"a"), PropertyIndexQuery.exact((int)1, (Object)"a")})).containsExactly((Object[])new Long[]{1L, 2L});
        }
    }

    static abstract class General
    extends CompositeIndexAccessorCompatibility {
        General(PropertyIndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1000, (int[])new int[]{100, 200})));
        }

        @Test
        void testDuplicatesInIndexSeekByString() throws Exception {
            String value = "a";
            this.testDuplicatesInIndexSeek(value);
        }

        @Test
        void testDuplicatesInIndexSeekByNumber() throws Exception {
            this.testDuplicatesInIndexSeek(333);
        }

        @Test
        void testDuplicatesInIndexSeekByPoint() throws Exception {
            Assumptions.assumeTrue((boolean)this.testSuite.supportsSpatial(), (String)"Assume support for spatial");
            this.testDuplicatesInIndexSeek((Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{12.6, 56.7}));
        }

        @Test
        void testDuplicatesInIndexSeekByBoolean() throws Exception {
            this.testDuplicatesInIndexSeek(true);
        }

        @Test
        void testDuplicatesInIndexSeekByTemporal() throws Exception {
            this.testDuplicatesInIndexSeek(LocalDate.ofEpochDay(303L));
        }

        @Test
        void testDuplicatesInIndexSeekByStringArray() throws Exception {
            this.testDuplicatesInIndexSeek(new String[]{"anabelle", "anabollo"});
        }

        @Test
        void testDuplicatesInIndexSeekByNumberArray() throws Exception {
            this.testDuplicatesInIndexSeek(new long[]{303L, 606L});
        }

        @Test
        void testDuplicatesInIndexSeekByBooleanArray() throws Exception {
            this.testDuplicatesInIndexSeek(new boolean[]{true, false});
        }

        @Test
        void testDuplicatesInIndexSeekByTemporalArray() throws Exception {
            this.testDuplicatesInIndexSeek((Value)CompositeIndexAccessorCompatibility.dateArray(303, 606));
        }

        @Test
        void testDuplicatesInIndexSeekByPointArray() throws Exception {
            Assumptions.assumeTrue((boolean)this.testSuite.supportsSpatial(), (String)"Assume support for spatial");
            this.testDuplicatesInIndexSeek((Value)Values.pointArray((PointValue[])new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{12.6, 56.7}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{12.6, 56.7})}));
        }

        private void testDuplicatesInIndexSeek(Object value) throws Exception {
            this.testDuplicatesInIndexSeek(Values.of((Object)value));
        }

        private void testDuplicatesInIndexSeek(Value value) throws Exception {
            this.updateAndCommit(Arrays.asList(CompositeIndexAccessorCompatibility.add(1L, this.descriptor, value, value), CompositeIndexAccessorCompatibility.add(2L, this.descriptor, value, value)));
            Assertions.assertThat(this.query(new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)0, (Object)value), PropertyIndexQuery.exact((int)1, (Object)value)})).containsExactly((Object[])new Long[]{1L, 2L});
        }
    }
}

