/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.counts;

import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.EphemeralNeo4jLayoutExtension;
import org.neo4j.test.extension.Inject;

@EphemeralNeo4jLayoutExtension
class RebuildCountsTest {
    private static final int ALIENS = 16;
    private static final int HUMANS = 16;
    private static final Label ALIEN = Label.label((String)"Alien");
    private static final Label HUMAN = Label.label((String)"Human");
    @Inject
    private EphemeralFileSystemAbstraction fileSystem;
    @Inject
    private RecordDatabaseLayout databaseLayout;
    private final AssertableLogProvider userLogProvider = new AssertableLogProvider();
    private final AssertableLogProvider internalLogProvider = new AssertableLogProvider();
    private GraphDatabaseService db;
    private DatabaseManagementService managementService;

    RebuildCountsTest() {
    }

    @BeforeEach
    void before() {
        this.restart((FileSystemAbstraction)this.fileSystem);
    }

    @AfterEach
    void after() {
        this.doCleanShutdown();
    }

    @Test
    void shouldRebuildMissingCountsStoreOnStart() throws IOException, TransactionFailureException {
        this.createAliensAndHumans();
        FileSystemAbstraction fs = this.shutdown();
        this.deleteCounts(fs);
        this.restart(fs);
        Kernel kernel = (Kernel)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(Kernel.class);
        try (KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            Assertions.assertEquals((long)32L, (long)tx.dataRead().countsForNode(-1));
            Assertions.assertEquals((long)16L, (long)tx.dataRead().countsForNode(this.labelId(ALIEN)));
            Assertions.assertEquals((long)16L, (long)tx.dataRead().countsForNode(this.labelId(HUMAN)));
        }
        this.assertRebuildLogged();
    }

    @Test
    void shouldRebuildMissingCountsStoreAfterRecovery() throws IOException, TransactionFailureException {
        this.createAliensAndHumans();
        this.rotateLog();
        this.deleteHumans();
        FileSystemAbstraction fs = this.crash();
        this.deleteCounts(fs);
        this.restart(fs);
        Kernel kernel = (Kernel)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(Kernel.class);
        try (KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            Assertions.assertEquals((long)16L, (long)tx.dataRead().countsForNode(-1));
            Assertions.assertEquals((long)16L, (long)tx.dataRead().countsForNode(this.labelId(ALIEN)));
            Assertions.assertEquals((long)0L, (long)tx.dataRead().countsForNode(this.labelId(HUMAN)));
        }
        this.assertRebuildLogged();
    }

    private void createAliensAndHumans() {
        try (Transaction tx = this.db.beginTx();){
            int i;
            for (i = 0; i < 16; ++i) {
                tx.createNode(new Label[]{ALIEN});
            }
            for (i = 0; i < 16; ++i) {
                tx.createNode(new Label[]{HUMAN});
            }
            tx.commit();
        }
    }

    private void deleteHumans() {
        try (Transaction tx = this.db.beginTx();){
            try (ResourceIterator humans = tx.findNodes(HUMAN);){
                while (humans.hasNext()) {
                    ((Node)humans.next()).delete();
                }
            }
            tx.commit();
        }
    }

    private int labelId(Label alien) {
        try (Transaction tx = this.db.beginTx();){
            int n = ((InternalTransaction)tx).kernelTransaction().tokenRead().nodeLabel(alien.name());
            return n;
        }
    }

    private void deleteCounts(FileSystemAbstraction snapshot) throws IOException {
        snapshot.deleteFile(this.databaseLayout.countStore());
    }

    private FileSystemAbstraction shutdown() {
        this.doCleanShutdown();
        return this.fileSystem.snapshot();
    }

    private void rotateLog() throws IOException {
        ((CheckPointer)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
    }

    private FileSystemAbstraction crash() {
        return this.fileSystem.snapshot();
    }

    private void restart(FileSystemAbstraction fs) {
        if (this.db != null) {
            this.managementService.shutdown();
        }
        this.managementService = new TestDatabaseManagementServiceBuilder((DatabaseLayout)this.databaseLayout).setUserLogProvider((LogProvider)this.userLogProvider).setInternalLogProvider((InternalLogProvider)this.internalLogProvider).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(fs)).setConfig(GraphDatabaseSettings.index_background_sampling_enabled, (Object)false).build();
        this.db = this.managementService.database("neo4j");
    }

    private void doCleanShutdown() {
        try {
            this.managementService.shutdown();
        }
        finally {
            this.db = null;
        }
    }

    private void assertRebuildLogged() {
        LogAssertions.assertThat((AssertableLogProvider)this.internalLogProvider).forClass(MetaDataStore.class).forLevel(AssertableLogProvider.Level.WARN).containsMessages(new String[]{"Missing counts store, rebuilding it.", "Counts store rebuild completed."});
    }
}

