/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.service.Services;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
public abstract class ExtensionFactoryContractTest {
    @Inject
    private TestDirectory target;
    private final Class<? extends ExtensionFactory<?>> extClass;
    private final String key;
    protected DatabaseManagementService managementService;

    protected ExtensionFactoryContractTest(String key, Class<? extends ExtensionFactory<?>> extClass) {
        this.extClass = extClass;
        this.key = key;
    }

    protected GraphDatabaseAPI graphDb() {
        this.managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        return (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    @Test
    void extensionShouldHavePublicNoArgConstructor() {
        ExtensionFactory<?> instance = this.newInstance();
        Assertions.assertNotNull(instance);
    }

    @Test
    void shouldBeAbleToLoadExtensionAsAServiceProvider() {
        ExtensionFactory<?> instance = this.loadInstance();
        Assertions.assertNotNull(instance, (String)"Could not load the kernel extension with the provided key");
        Assertions.assertSame(instance.getClass(), this.extClass, (String)"Class of the loaded instance is a subclass of the extension class");
    }

    @Test
    void differentInstancesShouldHaveEqualHashCodesAndBeEqual() {
        ExtensionFactory<?> one = this.newInstance();
        ExtensionFactory<?> two = this.newInstance();
        Assertions.assertEquals((int)one.hashCode(), (int)two.hashCode(), (String)"new instances have different hash codes");
        Assertions.assertEquals(one, two, (String)"new instances are not equals");
        one = this.loadInstance();
        two = this.loadInstance();
        Assertions.assertEquals((int)one.hashCode(), (int)two.hashCode(), (String)"loaded instances have different hash codes");
        Assertions.assertEquals(one, two, (String)"loaded instances are not equals");
        one = this.loadInstance();
        two = this.newInstance();
        Assertions.assertEquals((int)one.hashCode(), (int)two.hashCode(), (String)"loaded instance and new instance have different hash codes");
        Assertions.assertEquals(one, two, (String)"loaded instance and new instance are not equals");
    }

    private ExtensionFactory<?> newInstance() {
        try {
            return this.extClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception cause) {
            throw new IllegalArgumentException("Could not instantiate extension class", cause);
        }
    }

    private ExtensionFactory<?> loadInstance() {
        return this.extClass.cast(Services.loadOrFail(ExtensionFactory.class, (String)this.key));
    }
}

