/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl;

import org.junit.jupiter.api.TestInstance;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ImpermanentDbmsExtension(configurationCallback="configureDb")
public abstract class AbstractNeo4jTestCase {
    @Inject
    private DatabaseManagementService managementService;
    @Inject
    private GraphDatabaseAPI graphDb;

    @ExtensionCallback
    void configureDb(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.db_format, (Object)FormatFamily.ALIGNED.name());
    }

    protected GraphDatabaseService getGraphDb() {
        return this.graphDb;
    }

    protected DatabaseManagementService getManagementService() {
        return this.managementService;
    }

    protected GraphDatabaseAPI getGraphDbAPI() {
        return this.graphDb;
    }

    protected String createNode() {
        String nodeId;
        try (Transaction transaction = this.graphDb.beginTx();){
            nodeId = transaction.createNode().getElementId();
            transaction.commit();
        }
        return nodeId;
    }

    protected IdGenerator getIdGenerator(IdType idType) {
        return ((IdGeneratorFactory)this.graphDb.getDependencyResolver().resolveDependency(IdGeneratorFactory.class)).get(idType);
    }

    protected long propertyRecordsInUse() {
        return AbstractNeo4jTestCase.numberOfRecordsInUse(this.propertyStore());
    }

    private static <RECORD extends AbstractBaseRecord> int numberOfRecordsInUse(RecordStore<RECORD> store) {
        int inUse = 0;
        try (PageCursor cursor = store.openPageCursorForReading(0L, CursorContext.NULL_CONTEXT);){
            IdGenerator idGenerator = store.getIdGenerator();
            for (long id = (long)store.getNumberOfReservedLowIds(); id < idGenerator.getHighId(); ++id) {
                AbstractBaseRecord record = store.getRecordByCursor(id, store.newRecord(), RecordLoad.FORCE, cursor, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                if (!record.inUse()) continue;
                ++inUse;
            }
        }
        return inUse;
    }

    protected static <RECORD extends AbstractBaseRecord> long lastUsedRecordId(RecordStore<RECORD> store) {
        long usedIds = store.getIdGenerator().getHighId();
        try (PageCursor cursor = store.openPageCursorForReading(usedIds, CursorContext.NULL_CONTEXT);){
            for (long id = usedIds; id > (long)store.getNumberOfReservedLowIds(); --id) {
                AbstractBaseRecord record = store.getRecordByCursor(id, store.newRecord(), RecordLoad.FORCE, cursor, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                if (!record.inUse()) continue;
                long l = id;
                return l;
            }
        }
        return 0L;
    }

    protected long dynamicStringRecordsInUse() {
        return AbstractNeo4jTestCase.numberOfRecordsInUse(this.propertyStore().getStringStore());
    }

    protected long dynamicArrayRecordsInUse() {
        return AbstractNeo4jTestCase.numberOfRecordsInUse(this.propertyStore().getArrayStore());
    }

    protected StoreCursors createStoreCursors() {
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.graphDb.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        return storageEngine.createStorageCursors(CursorContext.NULL_CONTEXT);
    }

    protected NeoStores neoStores() {
        return ((RecordStorageEngine)this.graphDb.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
    }

    protected PropertyStore propertyStore() {
        return this.neoStores().getPropertyStore();
    }

    protected NodeStore nodeStore() {
        return this.neoStores().getNodeStore();
    }
}

