/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

class PropertyTransactionStateTest {
    private GraphDatabaseService db;
    private DatabaseManagementService managementService;

    PropertyTransactionStateTest() {
    }

    @BeforeEach
    void setUp() {
        this.managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        this.db = this.managementService.database("neo4j");
    }

    @AfterEach
    void shutDown() {
        this.managementService.shutdown();
    }

    @Test
    void testUpdateDoubleArrayProperty() {
        String nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            nodeId = node.getElementId();
            node.setProperty("foo", (Object)new double[]{0.0, 0.0, 0.0, 0.0});
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.getNodeByElementId(nodeId);
            for (int i = 0; i < 100; ++i) {
                double[] data = (double[])node.getProperty("foo");
                data[2] = i;
                data[3] = i;
                node.setProperty("foo", (Object)data);
                Assertions.assertArrayEquals((double[])new double[]{0.0, 0.0, i, i}, (double[])((double[])node.getProperty("foo")), (double)0.1);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void testStringPropertyUpdate() {
        String nodeId;
        Node node;
        String key = "foo";
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            nodeId = node.getElementId();
            node.setProperty(key, (Object)"one");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.getNodeByElementId(nodeId);
            node.setProperty(key, (Object)"one");
            node.setProperty(key, (Object)"two");
            Assertions.assertEquals((Object)"two", (Object)node.getProperty(key));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void testSetDoubleArrayProperty() {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            for (int i = 0; i < 100; ++i) {
                node.setProperty("foo", (Object)new double[]{0.0, 0.0, i, i});
                Assertions.assertArrayEquals((double[])new double[]{0.0, 0.0, i, i}, (double[])((double[])node.getProperty("foo")), (double)0.1);
            }
        }
    }
}

