/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class TransactionMemoryTrackerIT {
    @Inject
    private GraphDatabaseAPI db;

    TransactionMemoryTrackerIT() {
    }

    @Test
    void failToAllocateOnClosedTransaction() throws TransactionFailureException {
        try (Transaction transaction = this.db.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            kernelTransaction.closeTransaction();
            MemoryTracker memoryTracker = kernelTransaction.memoryTracker();
            Assertions.assertThrows(AssertionError.class, () -> memoryTracker.allocateHeap(1L));
            Assertions.assertThrows(AssertionError.class, () -> memoryTracker.allocateNative(1L));
        }
    }

    @Test
    void allocateOnOpenTransaction() {
        try (Transaction transaction = this.db.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            MemoryTracker memoryTracker = kernelTransaction.memoryTracker();
            Assertions.assertDoesNotThrow(() -> memoryTracker.allocateHeap(1L));
            Assertions.assertDoesNotThrow(() -> memoryTracker.allocateNative(1L));
            Assertions.assertDoesNotThrow(() -> memoryTracker.releaseNative(1L));
            Assertions.assertDoesNotThrow(() -> memoryTracker.releaseHeap(1L));
        }
    }
}

