/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;

class IndexIT
extends KernelIntegrationTest {
    private static final String LABEL = "Label";
    private static final String LABEL2 = "Label2";
    private static final String REL_TYPE = "RelType";
    private static final String REL_TYPE2 = "RelType2";
    private static final String PROPERTY_KEY = "prop";
    private static final String PROPERTY_KEY2 = "prop2";
    private int labelId;
    private int labelId2;
    private int relType;
    private int relType2;
    private int propertyKeyId;
    private int propertyKeyId2;
    private LabelSchemaDescriptor schema;
    private LabelSchemaDescriptor schema2;
    private ExecutorService executorService;

    IndexIT() {
    }

    @BeforeEach
    void createLabelAndProperty() throws Exception {
        TokenWrite tokenWrites = this.tokenWriteInNewTransaction();
        this.labelId = tokenWrites.labelGetOrCreateForName(LABEL);
        this.labelId2 = tokenWrites.labelGetOrCreateForName(LABEL2);
        this.relType = tokenWrites.relationshipTypeGetOrCreateForName(REL_TYPE);
        this.relType2 = tokenWrites.relationshipTypeGetOrCreateForName(REL_TYPE2);
        this.propertyKeyId = tokenWrites.propertyKeyGetOrCreateForName(PROPERTY_KEY);
        this.propertyKeyId2 = tokenWrites.propertyKeyGetOrCreateForName(PROPERTY_KEY2);
        this.schema = SchemaDescriptors.forLabel((int)this.labelId, (int[])new int[]{this.propertyKeyId});
        this.schema2 = SchemaDescriptors.forLabel((int)this.labelId, (int[])new int[]{this.propertyKeyId2});
        this.commit();
        this.executorService = Executors.newCachedThreadPool();
    }

    @AfterEach
    void tearDown() {
        this.executorService.shutdown();
    }

    @Test
    void createIndexForAnotherLabelWhileHoldingSharedLockOnOtherLabel() throws KernelException, ExecutionException, InterruptedException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int label2 = tokenWrite.labelGetOrCreateForName(LABEL2);
        this.commit();
        Write write = this.dataWriteInNewTransaction();
        long nodeId = write.nodeCreate();
        write.nodeAddLabel(nodeId, label2);
        try (Resource ignored = this.captureTransaction();){
            this.executorService.submit(() -> {
                try {
                    this.schemaWriteInNewTransaction().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)this.schema));
                    this.commit();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).get();
        }
    }

    @Test
    @Timeout(value=10L)
    void createIndexesForDifferentLabelsConcurrently() throws Throwable {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int label2 = tokenWrite.labelGetOrCreateForName(LABEL2);
        this.commit();
        LabelSchemaDescriptor anotherLabelDescriptor = SchemaDescriptors.forLabel((int)label2, (int[])new int[]{this.propertyKeyId});
        this.schemaWriteInNewTransaction().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)anotherLabelDescriptor).withName("my index"));
        Future<?> indexFuture = this.executorService.submit(IndexIT.createIndex(this.db, Label.label((String)LABEL), PROPERTY_KEY));
        indexFuture.get();
        this.commit();
    }

    @Test
    void addIndexRuleInATransaction() throws Exception {
        SchemaWrite schemaWriteOperations = this.schemaWriteInNewTransaction();
        IndexDescriptor expectedRule = schemaWriteOperations.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)this.schema).withName("my index"));
        this.commit();
        SchemaRead schemaRead = this.newTransaction().schemaRead();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{expectedRule}), (Object)Iterators.asSet((Iterator)schemaRead.indexesGetForLabel(this.labelId)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRule, (Object)Iterators.single((Iterator)schemaRead.index((SchemaDescriptor)this.schema)));
        this.commit();
    }

    @Test
    void committedAndTransactionalIndexRulesShouldBeMerged() throws Exception {
        SchemaWrite schemaWriteOperations = this.schemaWriteInNewTransaction();
        IndexDescriptor existingRule = schemaWriteOperations.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)this.schema).withName("my index"));
        this.commit();
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)this.labelId, (int[])new int[]{this.propertyKeyId2});
        IndexDescriptor addedRule = transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)schema).withName("my other index"));
        Set indexRulesInTx = Iterators.asSet((Iterator)transaction.schemaRead().indexesGetForLabel(this.labelId));
        this.commit();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{existingRule, addedRule}), (Object)indexRulesInTx);
    }

    @Test
    void rollBackIndexRuleShouldNotBeCommitted() throws Exception {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        schemaWrite.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)this.schema).withName("my index"));
        this.rollback();
        KernelTransaction transaction = this.newTransaction();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)Iterators.asSet((Iterator)transaction.schemaRead().indexesGetForLabel(this.labelId)));
        this.commit();
    }

    @Test
    void shouldBeAbleToRemoveAConstraintIndexWithoutOwner() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> this.kernel, this.indexingService, (InternalLogProvider)logProvider);
        IndexProviderDescriptor provider = AllIndexProviderDescriptors.RANGE_DESCRIPTOR;
        IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint name").withIndexProvider(provider);
        IndexDescriptor constraintIndex = creator.createConstraintIndex(prototype);
        KernelTransaction transaction = this.newTransaction();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)Iterators.asSet((Iterator)transaction.schemaRead().constraintsGetForLabel(this.labelId)));
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        schemaWrite.indexDrop(constraintIndex);
        this.commit();
        transaction = this.newTransaction();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)Iterators.asSet((Iterator)transaction.schemaRead().indexesGetForLabel(this.labelId)));
        this.commit();
    }

    @Test
    void shouldDisallowDroppingIndexThatDoesNotExist() throws Exception {
        SchemaWrite statement = this.schemaWriteInNewTransaction();
        IndexDescriptor index = statement.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)this.schema).withName("my index"));
        this.commit();
        statement = this.schemaWriteInNewTransaction();
        statement.indexDrop(index);
        this.commit();
        SchemaKernelException e = (SchemaKernelException)org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> {
            SchemaWrite statement = this.schemaWriteInNewTransaction();
            statement.indexDrop(index);
        });
        ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).containsSubsequence(new CharSequence[]{"Unable to drop index", "Index does not exist"})).contains(new CharSequence[]{"Index(", "id=", "name='my index'", "type='RANGE'", "schema=(:Label {prop})", "indexProvider='range-1.0'"});
        this.commit();
    }

    @Test
    void shouldDisallowDroppingIndexByNameThatDoesNotExist() throws KernelException {
        String indexName = "My fancy index";
        SchemaWrite statement = this.schemaWriteInNewTransaction();
        IndexDescriptor index = statement.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)this.schema).withName(indexName));
        this.commit();
        statement = this.schemaWriteInNewTransaction();
        statement.indexDrop(index);
        this.commit();
        statement = this.schemaWriteInNewTransaction();
        SchemaKernelException e = (SchemaKernelException)org.junit.jupiter.api.Assertions.assertThrows(DropIndexFailureException.class, () -> statement.indexDrop(indexName));
        Assertions.assertThat((Throwable)e).hasMessageContaining("Unable to drop index called `My fancy index`. There is no such index.");
        Assertions.assertThat((String)e.gqlStatus()).isEqualTo("50N10");
        Assertions.assertThat((String)e.statusDescription()).isEqualTo("error: general processing exception - index drop failed. Unable to drop 'My fancy index'.");
        Assertions.assertThat((Optional)e.cause()).isPresent();
        ErrorGqlStatusObject gqlCause = (ErrorGqlStatusObject)e.cause().get();
        Assertions.assertThat((String)gqlCause.gqlStatus()).isEqualTo("22N69");
        Assertions.assertThat((String)gqlCause.statusDescription()).isEqualTo("error: data exception - index does not exist. The index specified by 'My fancy index' does not exist.");
        Assertions.assertThat((Optional)gqlCause.cause()).isNotPresent();
        this.rollback();
    }

    @Test
    void shouldDisallowDroppingConstraintByNameThatDoesNotExist() throws KernelException {
        String constraintName = "my constraint";
        SchemaWrite statement = this.schemaWriteInNewTransaction();
        ConstraintDescriptor constraint = statement.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint name"));
        this.commit();
        statement = this.schemaWriteInNewTransaction();
        statement.constraintDrop(constraint, false);
        this.commit();
        statement = this.schemaWriteInNewTransaction();
        SchemaKernelException e = (SchemaKernelException)org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> statement.constraintDrop(constraintName, false));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Unable to drop constraint `my constraint`: No such constraint my constraint.", (Object)e.getMessage());
        this.rollback();
    }

    @Test
    void shouldDisallowDroppingIndexByNameThatBelongsToConstraint() throws KernelException {
        String constraintName = "my constraint";
        SchemaWrite statement = this.schemaWriteInNewTransaction();
        statement.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint name"));
        this.commit();
        statement = this.schemaWriteInNewTransaction();
        SchemaKernelException e = (SchemaKernelException)org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> statement.indexDrop(constraintName));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Unable to drop index called `my constraint`. There is no such index.", (Object)e.getMessage());
        this.rollback();
    }

    @Test
    void shouldFailToCreateIndexWhereAConstraintAlreadyExists() throws Exception {
        SchemaWrite statement = this.schemaWriteInNewTransaction();
        statement.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint name"));
        this.commit();
        SchemaKernelException e = (SchemaKernelException)org.junit.jupiter.api.Assertions.assertThrows(SchemaKernelException.class, () -> {
            SchemaWrite statement = this.schemaWriteInNewTransaction();
            statement.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)this.schema).withName("my index"));
            this.commit();
        });
        org.junit.jupiter.api.Assertions.assertEquals((Object)"There is a uniqueness constraint on (:Label {prop}), so an index is already created that matches this.", (Object)e.getMessage());
        this.commit();
    }

    @Test
    void shouldListConstraintIndexesInTheCoreAPI() throws Exception {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        long initialIndexCount = Iterators.count((Iterator)transaction.schemaRead().indexesGetAll());
        int labelId = transaction.tokenWrite().labelGetOrCreateForName("Label1");
        int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName("property1");
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyKeyId});
        transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("constraint name"));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            Set indexes = Iterables.asSet((Iterable)tx.schema().getIndexes());
            Assertions.assertThat((int)indexes.size()).isEqualTo(initialIndexCount + 1L);
            IndexDefinition index = tx.schema().getIndexByName("constraint name");
            Assertions.assertThat((Iterable)index.getLabels()).map(Label::name).containsOnly((Object[])new String[]{"Label1"});
            Assertions.assertThat((Iterable)index.getPropertyKeys()).containsOnly((Object[])new String[]{"property1"});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isConstraintIndex(), (String)"index should be a constraint index");
            IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((IndexDefinition)index).drop());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"Constraint indexes cannot be dropped directly, instead drop the owning uniqueness constraint.", (Object)e.getMessage());
        }
    }

    @Test
    void shouldListMultiTokenIndexesInTheCoreAPI() throws Exception {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        long initialIndexCount = Iterators.count((Iterator)transaction.schemaRead().indexesGetAll());
        FulltextSchemaDescriptor schema = SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])new int[]{this.labelId, this.labelId2}, (int[])new int[]{this.propertyKeyId});
        IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)AllIndexProviderDescriptors.FULLTEXT_DESCRIPTOR).withIndexType(IndexType.FULLTEXT).withName("multi token index");
        transaction.schemaWrite().indexCreate(prototype);
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            Set indexes = Iterables.asSet((Iterable)tx.schema().getIndexes());
            Assertions.assertThat((int)indexes.size()).isEqualTo(initialIndexCount + 1L);
            IndexDefinition index = tx.schema().getIndexByName("multi token index");
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((IndexDefinition)index).getRelationshipTypes());
            Assertions.assertThat((Iterable)index.getLabels()).containsOnly((Object[])new Label[]{Label.label((String)LABEL), Label.label((String)LABEL2)});
            Assertions.assertThat((Iterable)index.getPropertyKeys()).containsOnly((Object[])new String[]{PROPERTY_KEY});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)index.isConstraintIndex(), (String)"should not be a constraint index");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isMultiTokenIndex(), (String)"should be a multi-token index");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)index.isCompositeIndex(), (String)"should not be a composite index");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isNodeIndex(), (String)"should be a node index");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)index.isRelationshipIndex(), (String)"should not be a relationship index");
        }
    }

    @Test
    void shouldListCompositeIndexesInTheCoreAPI() throws Exception {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        long initialIndexCount = Iterators.count((Iterator)transaction.schemaRead().indexesGetAll());
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)this.labelId, (int[])new int[]{this.propertyKeyId, this.propertyKeyId2});
        transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)schema).withName("my index"));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            Set indexes = Iterables.asSet((Iterable)tx.schema().getIndexes());
            Assertions.assertThat((int)indexes.size()).isEqualTo(initialIndexCount + 1L);
            IndexDefinition index = tx.schema().getIndexByName("my index");
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((IndexDefinition)index).getRelationshipTypes());
            Assertions.assertThat((Iterable)index.getLabels()).containsOnly((Object[])new Label[]{Label.label((String)LABEL)});
            Assertions.assertThat((Iterable)index.getPropertyKeys()).containsOnly((Object[])new String[]{PROPERTY_KEY, PROPERTY_KEY2});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)index.isConstraintIndex(), (String)"should not be a constraint index");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)index.isMultiTokenIndex(), (String)"should not be a multi-token index");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isCompositeIndex(), (String)"should be a composite index");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isNodeIndex(), (String)"should be a node index");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)index.isRelationshipIndex(), (String)"should not be a relationship index");
        }
    }

    @Test
    void shouldListRelationshipIndexesInTheCoreAPI() throws Exception {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        long initialIndexCount = Iterators.count((Iterator)transaction.schemaRead().indexesGetAll());
        RelationTypeSchemaDescriptor schema = SchemaDescriptors.forRelType((int)this.relType, (int[])new int[]{this.propertyKeyId});
        transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)schema).withName("my index"));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            Set indexes = Iterables.asSet((Iterable)tx.schema().getIndexes());
            Assertions.assertThat((int)indexes.size()).isEqualTo(initialIndexCount + 1L);
            IndexDefinition index = tx.schema().getIndexByName("my index");
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((IndexDefinition)index).getLabels());
            Assertions.assertThat((Iterable)index.getRelationshipTypes()).containsOnly((Object[])new RelationshipType[]{RelationshipType.withName((String)REL_TYPE)});
            Assertions.assertThat((Iterable)index.getPropertyKeys()).containsOnly((Object[])new String[]{PROPERTY_KEY});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)index.isConstraintIndex(), (String)"should not be a constraint index");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)index.isMultiTokenIndex(), (String)"should not be a multi-token index");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)index.isCompositeIndex(), (String)"should not be a composite index");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)index.isNodeIndex(), (String)"should not be a node index");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isRelationshipIndex(), (String)"should be a relationship index");
        }
    }

    @Test
    void shouldListCompositeMultiTokenRelationshipIndexesInTheCoreAPI() throws Exception {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        long initialIndexCount = Iterators.count((Iterator)transaction.schemaRead().indexesGetAll());
        FulltextSchemaDescriptor schema = SchemaDescriptors.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{this.relType, this.relType2}, (int[])new int[]{this.propertyKeyId, this.propertyKeyId2});
        IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)AllIndexProviderDescriptors.FULLTEXT_DESCRIPTOR).withIndexType(IndexType.FULLTEXT).withName("index name");
        transaction.schemaWrite().indexCreate(prototype);
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            Set indexes = Iterables.asSet((Iterable)tx.schema().getIndexes());
            Assertions.assertThat((int)indexes.size()).isEqualTo(initialIndexCount + 1L);
            IndexDefinition index = tx.schema().getIndexByName("index name");
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((IndexDefinition)index).getLabels());
            Assertions.assertThat((Iterable)index.getRelationshipTypes()).containsOnly((Object[])new RelationshipType[]{RelationshipType.withName((String)REL_TYPE), RelationshipType.withName((String)REL_TYPE2)});
            Assertions.assertThat((Iterable)index.getPropertyKeys()).containsOnly((Object[])new String[]{PROPERTY_KEY, PROPERTY_KEY2});
            org.junit.jupiter.api.Assertions.assertFalse((boolean)index.isConstraintIndex(), (String)"should not be a constraint index");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isMultiTokenIndex(), (String)"should be a multi-token index");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isCompositeIndex(), (String)"should be a composite index");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)index.isNodeIndex(), (String)"should not be a node index");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isRelationshipIndex(), (String)"should be a relationship index");
        }
    }

    @Test
    void shouldListAll() throws Exception {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        IndexDescriptor index1 = schemaWrite.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)this.schema).withName("my index"));
        IndexBackedConstraintDescriptor constraint = schemaWrite.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema2).withName("constraint name")).asIndexBackedConstraint();
        this.commit();
        SchemaRead schemaRead = this.newTransaction().schemaRead();
        IndexDescriptor index2 = (IndexDescriptor)Iterators.single((Iterator)schemaRead.index(constraint.schema()));
        List indexes = Iterators.asList((Iterator)schemaRead.indexesGetAll());
        Assertions.assertThat((List)indexes).contains((Object[])new IndexDescriptor[]{index1, index2});
        this.commit();
    }

    private static Runnable createIndex(GraphDatabaseAPI db, Label label, String propertyKey) {
        return () -> {
            try (Transaction transaction = db.beginTx();){
                transaction.schema().indexFor(label).on(propertyKey).create();
                transaction.commit();
            }
            transaction = db.beginTx();
            try {
                transaction.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
                transaction.commit();
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        };
    }
}

