/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.ConsistencyCheckIncompleteException;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.test.Race;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.ValueType;

@ImpermanentDbmsExtension(configurationCallback="configure")
@ExtendWith(value={RandomExtension.class})
class ParallelIndexUpdatesIT {
    @Inject
    private TestDirectory directory;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseManagementService dbms;
    @Inject
    private GraphDatabaseService db;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private RandomSupport random;

    ParallelIndexUpdatesIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.parallel_index_updates_apply, (Object)true);
    }

    @Test
    void shouldApplyIndexUpdatesInParallelOnManyIndexes() throws ConsistencyCheckIncompleteException {
        int numTokens = 10;
        List<String> keys = IntStream.range(0, numTokens).mapToObj(i -> "p" + i).toList();
        List<Label> labels = IntStream.range(0, numTokens).mapToObj(i -> Label.label((String)("L" + i))).toList();
        List<RelationshipType> relationshipTypes = IntStream.range(0, numTokens).mapToObj(i -> RelationshipType.withName((String)("T" + i))).toList();
        this.createManyIndexes(keys, labels, relationshipTypes);
        this.createData(keys, labels, relationshipTypes);
        this.dbms.shutdown();
        ConsistencyCheckService.Result result = new ConsistencyCheckService(this.databaseLayout).with(this.fs).with(this.directory.file("report")).runFullConsistencyCheck();
        Assertions.assertThat((boolean)result.isSuccessful()).isTrue();
    }

    private void createData(List<String> keys, List<Label> labels, List<RelationshipType> relationshipTypes) {
        int numTransactionsPerThread = 1000;
        int numNodesPerTransaction = 10;
        Race race = new Race();
        race.addContestants(4, () -> {
            try (Transaction tx = this.db.beginTx();){
                int i;
                ArrayList<Node> nodes = new ArrayList<Node>();
                for (i = 0; i < numNodesPerTransaction; ++i) {
                    Node node = tx.createNode((Label[])this.random.selection((Object[])labels.toArray(new Label[0]), 1, labels.size(), false));
                    this.setRandomProperties(keys, (Entity)node);
                    nodes.add(node);
                }
                for (i = 0; i < numNodesPerTransaction; ++i) {
                    Node startNode = (Node)this.random.among(nodes);
                    Node endNode = (Node)this.random.among(nodes);
                    Relationship relationship = startNode.createRelationshipTo(endNode, (RelationshipType)this.random.among(relationshipTypes));
                    this.setRandomProperties(keys, (Entity)relationship);
                }
                tx.commit();
            }
        }, numTransactionsPerThread);
        race.goUnchecked();
    }

    private void setRandomProperties(List<String> keys, Entity entity) {
        Object[] valueTypes = new ValueType[]{ValueType.INT, ValueType.STRING, ValueType.DATE_TIME};
        for (String key : (String[])this.random.selection((Object[])keys.toArray(new String[0]), 1, keys.size(), false)) {
            entity.setProperty(key, this.random.nextValue((ValueType)this.random.among(valueTypes)).asObjectCopy());
        }
    }

    private void createManyIndexes(List<String> keys, List<Label> labels, List<RelationshipType> relationshipTypes) {
        int maxIndexes = keys.size() * labels.size() + keys.size() * relationshipTypes.size();
        int numIndexes = this.random.nextInt(maxIndexes / 2, maxIndexes);
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < numIndexes; ++i) {
                IndexCreator indexCreator = this.random.nextBoolean() ? tx.schema().indexFor((Label)this.random.among(labels)) : tx.schema().indexFor((RelationshipType)this.random.among(relationshipTypes));
                indexCreator = indexCreator.withName("MyIndex" + i).on((String)this.random.among(keys));
                try {
                    indexCreator.create();
                    continue;
                }
                catch (ConstraintViolationException constraintViolationException) {
                    // empty catch block
                }
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

