/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.conditions.Conditions;

class KernelIT
extends KernelIntegrationTest {
    KernelIT() {
    }

    @Test
    void mixingBeansApiWithKernelAPI() throws Exception {
        Transaction transaction = this.db.beginTx();
        KernelTransaction ktx = ((InternalTransaction)transaction).kernelTransaction();
        Node node = transaction.createNode();
        int labelId = ktx.tokenWrite().labelGetOrCreateForName("labello");
        ktx.dataWrite().nodeAddLabel(node.getId(), labelId);
        transaction.commit();
    }

    @Test
    void schemaStateShouldBeEvictedOnIndexComingOnline() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelIT.getOrCreateSchemaState(tx, "my key", "my state");
            tx.commit();
        }
        KernelIT.createIndex(this.newTransaction(LoginContext.AUTH_DISABLED));
        this.commit();
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Assert.assertEventually((String)"Schema state should have been updated", () -> this.schemaStateContains("my key"), (Condition)Conditions.FALSE, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test
    void schemaStateShouldBeEvictedOnIndexDropped() throws Exception {
        IndexDescriptor idx = KernelIT.createIndex(this.newTransaction(LoginContext.AUTH_DISABLED));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            KernelIT.getOrCreateSchemaState(tx, "my key", "some state");
            tx.commit();
        }
        this.schemaWriteInNewTransaction().indexDrop(idx);
        this.commit();
        Assertions.assertFalse((boolean)this.schemaStateContains("my key"));
    }

    @Test
    void txReturnsCorrectIdWhenCommitted() throws Exception {
        KernelIT.executeDummyTxs((GraphDatabaseService)this.db, 42);
        KernelTransaction tx = this.newTransaction(LoginContext.AUTH_DISABLED);
        tx.dataWrite().nodeCreate();
        long previousCommittedTxId = KernelIT.lastCommittedTxId(this.db);
        Assertions.assertEquals((long)(previousCommittedTxId + 1L), (long)this.commit());
        Assertions.assertFalse((boolean)tx.isOpen());
    }

    @Test
    void txReturnsCorrectIdWhenRolledBack() throws Exception {
        KernelIT.executeDummyTxs((GraphDatabaseService)this.db, 42);
        KernelTransaction tx = this.newTransaction(LoginContext.AUTH_DISABLED);
        tx.dataWrite().nodeCreate();
        Assertions.assertEquals((long)-1L, (long)tx.closeTransaction());
        Assertions.assertFalse((boolean)tx.isOpen());
    }

    @Test
    void txReturnsCorrectIdWhenMarkedForTermination() throws Exception {
        KernelIT.executeDummyTxs((GraphDatabaseService)this.db, 42);
        KernelTransaction tx = this.newTransaction(LoginContext.AUTH_DISABLED);
        tx.dataWrite().nodeCreate();
        tx.markForTermination((Status)Status.Transaction.Terminated);
        Assertions.assertEquals((long)-1L, (long)tx.closeTransaction());
        Assertions.assertFalse((boolean)tx.isOpen());
    }

    @Test
    void txReturnsCorrectIdWhenFailedAndMarkedForTermination() throws Exception {
        KernelIT.executeDummyTxs((GraphDatabaseService)this.db, 42);
        KernelTransaction tx = this.newTransaction(LoginContext.AUTH_DISABLED);
        tx.dataWrite().nodeCreate();
        tx.markForTermination((Status)Status.Transaction.Terminated);
        Assertions.assertEquals((long)-1L, (long)tx.closeTransaction());
        Assertions.assertFalse((boolean)tx.isOpen());
    }

    @Test
    void txReturnsCorrectIdWhenReadOnly() throws Exception {
        KernelIT.executeDummyTxs((GraphDatabaseService)this.db, 42);
        KernelTransaction tx = this.newTransaction();
        try (NodeCursor node = tx.cursors().allocateNodeCursor(tx.cursorContext());){
            tx.dataRead().singleNode(1L, node);
            node.next();
        }
        Assertions.assertEquals((long)0L, (long)this.commit());
        Assertions.assertFalse((boolean)tx.isOpen());
    }

    private static void executeDummyTxs(GraphDatabaseService db, int count) {
        for (int i = 0; i < count; ++i) {
            try (Transaction tx = db.beginTx();){
                tx.createNode();
                tx.commit();
                continue;
            }
        }
    }

    private static long lastCommittedTxId(GraphDatabaseAPI db) {
        TransactionIdStore txIdStore = (TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        return txIdStore.getLastCommittedTransactionId();
    }

    private static IndexDescriptor createIndex(KernelTransaction transaction) throws KernelException {
        TokenWrite tokenWrite = transaction.tokenWrite();
        SchemaWrite schemaWrite = transaction.schemaWrite();
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)tokenWrite.labelGetOrCreateForName("hello"), (int[])new int[]{tokenWrite.propertyKeyGetOrCreateForName("hepp")});
        return schemaWrite.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)schema));
    }

    private static void getOrCreateSchemaState(Transaction tx, String key, String maybeSetThisState) {
        KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
        ktx.schemaRead().schemaStateGetOrCreate((Object)key, s -> maybeSetThisState);
    }

    private boolean schemaStateContains(String key) {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            AtomicBoolean result = new AtomicBoolean(true);
            ktx.schemaRead().schemaStateGetOrCreate((Object)key, s -> {
                result.set(false);
                return null;
            });
            tx.commit();
            boolean bl = result.get();
            return bl;
        }
    }
}

