/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Collection;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.token.api.NamedToken;

class LabelIT
extends KernelIntegrationTest {
    LabelIT() {
    }

    @Test
    void shouldListAllLabels() throws Exception {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int label1Id = transaction.tokenWrite().labelGetOrCreateForName("label1");
        int label2Id = transaction.tokenWrite().labelGetOrCreateForName("label2");
        Iterator labelIdsBeforeCommit = transaction.tokenRead().labelsGetAllTokens();
        Assertions.assertThat((Collection)Iterators.asCollection((Iterator)labelIdsBeforeCommit)).contains((Object[])new NamedToken[]{new NamedToken("label1", label1Id), new NamedToken("label2", label2Id)});
        this.commit();
        transaction = this.newTransaction();
        Iterator labelIdsAfterCommit = transaction.tokenRead().labelsGetAllTokens();
        Assertions.assertThat((Collection)Iterators.asCollection((Iterator)labelIdsAfterCommit)).contains((Object[])new NamedToken[]{new NamedToken("label1", label1Id), new NamedToken("label2", label2Id)});
        this.commit();
    }
}

