/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThread;
import org.neo4j.test.extension.OtherThreadExtension;

@ImpermanentDbmsExtension
@ExtendWith(value={OtherThreadExtension.class})
public class UniquenessConstraintValidationConcurrencyIT {
    private static String TOKEN = "Token1";
    private static String KEY = "key1";
    private static String VALUE = "value1";
    private static String VALUE2 = "value2";
    @Inject
    private GraphDatabaseService database;
    @Inject
    private OtherThread otherThread;

    @ParameterizedTest
    @EnumSource(value=EntityControl.class)
    void shouldAllowConcurrentCreationOfNonConflictingData(EntityControl entityControl) throws Exception {
        this.createTestConstraint(entityControl);
        try (Transaction tx = this.database.beginTx();){
            entityControl.createEntityWithTokenAndProp(tx, VALUE);
            Assertions.assertTrue((boolean)((Boolean)this.otherThread.execute(this.createEntity(entityControl, VALUE2)).get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=EntityControl.class)
    void shouldPreventConcurrentCreationOfConflictingData(EntityControl entityControl) throws Exception {
        Future result;
        this.createTestConstraint(entityControl);
        try (Transaction tx = this.database.beginTx();){
            entityControl.createEntityWithTokenAndProp(tx, VALUE);
            try {
                result = this.otherThread.execute(this.createEntity(entityControl, VALUE));
            }
            finally {
                this.waitUntilWaiting();
            }
            tx.commit();
        }
        Assertions.assertFalse((boolean)((Boolean)result.get()), (String)"entity creation should fail");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=EntityControl.class)
    void shouldAllowOtherTransactionToCompleteIfFirstTransactionRollsBack(EntityControl entityControl) throws Exception {
        Future result;
        this.createTestConstraint(entityControl);
        try (Transaction tx = this.database.beginTx();){
            entityControl.createEntityWithTokenAndProp(tx, VALUE);
            try {
                result = this.otherThread.execute(this.createEntity(entityControl, VALUE));
            }
            finally {
                this.waitUntilWaiting();
            }
            tx.rollback();
        }
        Assertions.assertTrue((boolean)((Boolean)result.get()), (String)"entity creation should succeed");
    }

    @ParameterizedTest
    @EnumSource(value=EntityControl.class)
    void shouldFailPolitelyOnTooLargeKeyLength(EntityControl entityControl) throws Exception {
        int numChars = 40000;
        try (Transaction tx = this.database.beginTx();){
            entityControl.createEntityWithTokenAndProp(tx, "a".repeat(numChars));
            tx.commit();
        }
        AssertionsForClassTypes.assertThatThrownBy(() -> this.createTestConstraint(entityControl)).hasRootCauseInstanceOf(IllegalArgumentException.class).hasMessageContaining("Property value is too large to index");
    }

    private void createTestConstraint(EntityControl entityControl) {
        try (Transaction transaction = this.database.beginTx();){
            entityControl.constraint(transaction.schema()).create();
            transaction.commit();
        }
    }

    private void waitUntilWaiting() {
        try {
            this.otherThread.get().waitUntilWaiting();
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public Callable<Boolean> createEntity(EntityControl entityControl, String propertyValue) {
        return () -> {
            Boolean bl;
            block8: {
                Transaction tx = this.database.beginTx();
                try {
                    entityControl.createEntityWithTokenAndProp(tx, propertyValue);
                    tx.commit();
                    bl = true;
                    if (tx == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (tx != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ConstraintViolationException e) {
                        return false;
                    }
                }
                tx.close();
            }
            return bl;
        };
    }

    static enum EntityControl {
        NODE{

            @Override
            ConstraintCreator constraint(Schema schema) {
                return schema.constraintFor(Label.label((String)TOKEN)).assertPropertyIsUnique(KEY);
            }

            @Override
            void createEntityWithTokenAndProp(Transaction tx, String value) {
                tx.createNode(new Label[]{Label.label((String)TOKEN)}).setProperty(KEY, (Object)value);
            }
        }
        ,
        RELATIONSHIP{

            @Override
            ConstraintCreator constraint(Schema schema) {
                return schema.constraintFor(RelationshipType.withName((String)TOKEN)).assertPropertyIsUnique(KEY);
            }

            @Override
            void createEntityWithTokenAndProp(Transaction tx, String value) {
                Node node = tx.createNode();
                node.createRelationshipTo(node, RelationshipType.withName((String)TOKEN)).setProperty(KEY, (Object)value);
            }
        };


        abstract ConstraintCreator constraint(Schema var1);

        abstract void createEntityWithTokenAndProp(Transaction var1, String var2);
    }
}

