/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class UniquenessConstraintValidationIT
extends KernelIntegrationTest {
    private static String TOKEN = "Token1";
    private static String KEY = "key1";
    private static String VALUE = "value1";

    UniquenessConstraintValidationIT() {
    }

    private static long createLabeledNode(KernelTransaction transaction, String label) throws KernelException {
        long node = transaction.dataWrite().nodeCreate();
        int labelId = transaction.tokenWrite().labelGetOrCreateForName(label);
        transaction.dataWrite().nodeAddLabel(node, labelId);
        return node;
    }

    private static long createNode(KernelTransaction transaction, String key, Object value) throws KernelException {
        long node = transaction.dataWrite().nodeCreate();
        int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
        transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)value));
        return node;
    }

    private static long createLabeledNode(KernelTransaction transaction, String label, String key, Object value) throws KernelException {
        long node = UniquenessConstraintValidationIT.createLabeledNode(transaction, label);
        int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
        transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)value));
        return node;
    }

    private static long createRelationship(KernelTransaction transaction, String type, String key, Object value) throws KernelException {
        Write write = transaction.dataWrite();
        TokenWrite tokenWrite = transaction.tokenWrite();
        int typeId = tokenWrite.relationshipTypeGetOrCreateForName(type);
        long rel = write.relationshipCreate(write.nodeCreate(), typeId, write.nodeCreate());
        int propertyKeyId = tokenWrite.propertyKeyGetOrCreateForName(key);
        write.relationshipSetProperty(rel, propertyKeyId, Values.of((Object)value));
        return rel;
    }

    @ParameterizedTest
    @EnumSource(value=EntityControl.class)
    void shouldEnforceOnSetProperty(EntityControl entityControl) throws Exception {
        this.constrainedEntity(entityControl, TOKEN, KEY, VALUE);
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long entity = entityControl.createEntityWithToken(transaction, TOKEN);
        UniquePropertyValueValidationException e = (UniquePropertyValueValidationException)org.junit.jupiter.api.Assertions.assertThrows(UniquePropertyValueValidationException.class, () -> {
            int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(KEY);
            entityControl.setProperty(transaction.dataWrite(), entity, propertyKeyId, Values.of((Object)VALUE));
        });
        Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)transaction.tokenRead())).contains(new CharSequence[]{"`key1` = 'value1'"});
        this.commit();
    }

    @Test
    void roundingErrorsFromLongToDoubleShouldNotPreventTxFromCommitting() throws Exception {
        long propertyValue = 285414114323346805L;
        long firstNode = this.constrainedNode(TOKEN, KEY, propertyValue);
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long node = UniquenessConstraintValidationIT.createLabeledNode(transaction, TOKEN);
        org.junit.jupiter.api.Assertions.assertNotEquals((long)firstNode, (long)node);
        int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(KEY);
        transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)(++propertyValue)));
        this.commit();
    }

    @Test
    void shouldEnforceUniquenessConstraintOnAddLabelForNumberPropertyOnNodeNotFromTransaction() throws Exception {
        this.constrainedNode(TOKEN, KEY, 1);
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long node = UniquenessConstraintValidationIT.createNode(transaction, KEY, 1);
        this.commit();
        KernelTransaction transaction2 = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        UniquePropertyValueValidationException e = (UniquePropertyValueValidationException)org.junit.jupiter.api.Assertions.assertThrows(UniquePropertyValueValidationException.class, () -> {
            int label = transaction2.tokenWrite().labelGetOrCreateForName(TOKEN);
            transaction2.dataWrite().nodeAddLabel(node, label);
        });
        Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)transaction2.tokenRead())).contains(new CharSequence[]{"`key1` = 1"});
        this.commit();
    }

    @Test
    void shouldEnforceUniquenessConstraintOnAddLabelForStringProperty() throws Exception {
        this.constrainedNode(TOKEN, KEY, VALUE);
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long node = UniquenessConstraintValidationIT.createNode(transaction, KEY, VALUE);
        UniquePropertyValueValidationException e = (UniquePropertyValueValidationException)org.junit.jupiter.api.Assertions.assertThrows(UniquePropertyValueValidationException.class, () -> {
            int label = transaction.tokenWrite().labelGetOrCreateForName(TOKEN);
            transaction.dataWrite().nodeAddLabel(node, label);
        });
        Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)transaction.tokenRead())).contains(new CharSequence[]{"`key1` = 'value1'"});
        this.commit();
    }

    @ParameterizedTest
    @EnumSource(value=EntityControl.class)
    void shouldAllowRemoveAndAddConflictingDataInOneTransaction_DeleteEntity(EntityControl entityControl) throws Exception {
        long entity = this.constrainedEntity(entityControl, TOKEN, KEY, VALUE);
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        entityControl.deleteEntity(transaction.dataWrite(), entity);
        entityControl.createEntityWithTokenAndProp(transaction, TOKEN, KEY, Values.of((Object)VALUE));
        this.commit();
    }

    @Test
    void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveLabel() throws Exception {
        long node = this.constrainedNode(TOKEN, KEY, VALUE);
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int label = transaction.tokenWrite().labelGetOrCreateForName(TOKEN);
        transaction.dataWrite().nodeRemoveLabel(node, label);
        UniquenessConstraintValidationIT.createLabeledNode(transaction, TOKEN, KEY, VALUE);
        this.commit();
    }

    @ParameterizedTest
    @EnumSource(value=EntityControl.class)
    void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveProperty(EntityControl entityControl) throws Exception {
        long entity = this.constrainedEntity(entityControl, TOKEN, KEY, VALUE);
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int key = transaction.tokenRead().propertyKey(KEY);
        entityControl.removeProperty(transaction.dataWrite(), entity, key);
        entityControl.createEntityWithTokenAndProp(transaction, TOKEN, KEY, Values.of((Object)VALUE));
        this.commit();
    }

    @ParameterizedTest
    @EnumSource(value=EntityControl.class)
    void shouldAllowRemoveAndAddConflictingDataInOneTransaction_ChangeProperty(EntityControl entityControl) throws Exception {
        long entity = this.constrainedEntity(entityControl, TOKEN, KEY, VALUE);
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(KEY);
        entityControl.setProperty(transaction.dataWrite(), entity, propertyKeyId, Values.of((Object)"value2"));
        entityControl.createEntityWithTokenAndProp(transaction, TOKEN, KEY, Values.of((Object)VALUE));
        this.commit();
    }

    @ParameterizedTest
    @EnumSource(value=EntityControl.class)
    void shouldPreventConflictingDataInSameTransaction(EntityControl entityControl) throws Exception {
        this.constrainedEntity(entityControl, TOKEN, KEY, VALUE);
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        entityControl.createEntityWithTokenAndProp(transaction, TOKEN, KEY, Values.of((Object)"value2"));
        UniquePropertyValueValidationException e = (UniquePropertyValueValidationException)org.junit.jupiter.api.Assertions.assertThrows(UniquePropertyValueValidationException.class, () -> entityControl.createEntityWithTokenAndProp(transaction, TOKEN, KEY, Values.of((Object)"value2")));
        Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)transaction.tokenRead())).contains(new CharSequence[]{"`key1` = 'value2'"});
        this.commit();
    }

    @ParameterizedTest
    @EnumSource(value=EntityControl.class)
    void shouldAllowNoopPropertyUpdate(EntityControl entityControl) throws KernelException {
        long entity = this.constrainedEntity(entityControl, TOKEN, KEY, VALUE);
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int key = transaction.tokenWrite().propertyKeyGetOrCreateForName(KEY);
        entityControl.setProperty(transaction.dataWrite(), entity, key, Values.of((Object)VALUE));
        this.commit();
    }

    @Test
    void shouldAllowNoopLabelUpdate() throws KernelException {
        long node = this.constrainedNode(TOKEN, KEY, VALUE);
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int label = transaction.tokenWrite().labelGetOrCreateForName(TOKEN);
        transaction.dataWrite().nodeAddLabel(node, label);
        this.commit();
    }

    @ParameterizedTest
    @EnumSource(value=EntityControl.class)
    void shouldAllowCreationOfNonConflictingData(EntityControl entityControl) throws Exception {
        this.constrainedEntity(entityControl, TOKEN, KEY, VALUE);
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        UniquenessConstraintValidationIT.createNode(transaction, KEY, VALUE);
        entityControl.createEntityWithTokenAndProp(transaction, "Token2", KEY, Values.of((Object)VALUE));
        entityControl.createEntityWithTokenAndProp(transaction, TOKEN, KEY, Values.of((Object)"value2"));
        entityControl.createEntityWithTokenAndProp(transaction, TOKEN, "key2", Values.of((Object)VALUE));
        this.commit();
        transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        org.junit.jupiter.api.Assertions.assertEquals((int)(entityControl == EntityControl.NODE ? 5 : 4), (int)entityControl.countEntities(transaction), (String)"number of entities");
        this.rollback();
    }

    @Test
    void unrelatedNodesWithSamePropertyShouldNotInterfereWithUniquenessCheck() throws Exception {
        ConstraintDescriptor constraint = this.createNodeConstraint("Person", "id");
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long ourNode = UniquenessConstraintValidationIT.createLabeledNode(transaction, "Person", "id", 1);
        UniquenessConstraintValidationIT.createLabeledNode(transaction, "Item", "id", 2);
        this.commit();
        transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        TokenRead tokenRead = transaction.tokenRead();
        int propId = tokenRead.propertyKey("id");
        IndexDescriptor idx = transaction.schemaRead().indexGetForName(constraint.getName());
        UniquenessConstraintValidationIT.createLabeledNode(transaction, "Item", "id", 2);
        try (NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());){
            Assertions.assertThat((long)transaction.dataRead().lockingNodeUniqueIndexSeek(idx, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)propId, (Object)Values.of((Object)1))})).isEqualTo(ourNode);
        }
        this.commit();
    }

    @Test
    void unrelatedRelationshipWithSamePropertyShouldNotInterfereWithUniquenessCheck() throws Exception {
        ConstraintDescriptor constraint = this.createRelationshipConstraint("R", "id");
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long ourRelationship = UniquenessConstraintValidationIT.createRelationship(transaction, "R", "id", 1);
        UniquenessConstraintValidationIT.createRelationship(transaction, "OTHER", "id", 2);
        this.commit();
        transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        TokenRead tokenRead = transaction.tokenRead();
        int propId = tokenRead.propertyKey("id");
        IndexDescriptor idx = transaction.schemaRead().indexGetForName(constraint.getName());
        UniquenessConstraintValidationIT.createRelationship(transaction, "OTHER", "id", 2);
        try (RelationshipValueIndexCursor cursor = transaction.cursors().allocateRelationshipValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());){
            Assertions.assertThat((long)transaction.dataRead().lockingRelationshipUniqueIndexSeek(idx, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)propId, (Object)Values.of((Object)1))})).isEqualTo(ourRelationship);
        }
        this.commit();
    }

    @Test
    void addingUniqueNodeWithUnrelatedValueShouldNotAffectLookup() throws Exception {
        ConstraintDescriptor constraint = this.createNodeConstraint("Person", "id");
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long ourNode = UniquenessConstraintValidationIT.createLabeledNode(transaction, "Person", "id", 1);
        this.commit();
        transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        TokenRead tokenRead = transaction.tokenRead();
        int propId = tokenRead.propertyKey("id");
        IndexDescriptor idx = transaction.schemaRead().indexGetForName(constraint.getName());
        UniquenessConstraintValidationIT.createLabeledNode(transaction, "Person", "id", 2);
        try (NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());){
            Assertions.assertThat((long)transaction.dataRead().lockingNodeUniqueIndexSeek(idx, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)propId, (Object)Values.of((Object)1))})).isEqualTo(ourNode);
        }
        this.commit();
    }

    @Test
    void addingUniqueRelationshipWithUnrelatedValueShouldNotAffectLookup() throws Exception {
        ConstraintDescriptor constraint = this.createRelationshipConstraint("R", "id");
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long ourRelationship = UniquenessConstraintValidationIT.createRelationship(transaction, "R", "id", 1);
        this.commit();
        transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        TokenRead tokenRead = transaction.tokenRead();
        int propId = tokenRead.propertyKey("id");
        IndexDescriptor idx = transaction.schemaRead().indexGetForName(constraint.getName());
        UniquenessConstraintValidationIT.createRelationship(transaction, "R", "id", 2);
        try (RelationshipValueIndexCursor cursor = transaction.cursors().allocateRelationshipValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());){
            Assertions.assertThat((long)transaction.dataRead().lockingRelationshipUniqueIndexSeek(idx, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)propId, (Object)Values.of((Object)1))})).isEqualTo(ourRelationship);
        }
        this.commit();
    }

    private long constrainedEntity(EntityControl entityControl, String tokenName, String propertyKey, Object propertyValue) throws KernelException {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int token = entityControl.getOrCreateToken(transaction.tokenWrite(), tokenName);
        int key = transaction.tokenWrite().propertyKeyGetOrCreateForName(propertyKey);
        long node = entityControl.createEntityWithTokenAndProp(transaction.dataWrite(), token, key, Values.of((Object)propertyValue));
        this.commit();
        this.createConstraint(entityControl.schema(token, key));
        return node;
    }

    private long constrainedNode(String labelName, String propertyKey, Object propertyValue) throws KernelException {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int label = transaction.tokenWrite().labelGetOrCreateForName(labelName);
        long node = transaction.dataWrite().nodeCreate();
        transaction.dataWrite().nodeAddLabel(node, label);
        int key = transaction.tokenWrite().propertyKeyGetOrCreateForName(propertyKey);
        transaction.dataWrite().nodeSetProperty(node, key, Values.of((Object)propertyValue));
        this.commit();
        this.createConstraint((SchemaDescriptor)SchemaDescriptors.forLabel((int)label, (int[])new int[]{key}));
        return node;
    }

    private ConstraintDescriptor createConstraint(SchemaDescriptor schema) throws KernelException {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        ConstraintDescriptor constraint = schemaWrite.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)schema));
        this.commit();
        return constraint;
    }

    private ConstraintDescriptor createNodeConstraint(String label, String propertyKey) throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int labelId = tokenWrite.labelGetOrCreateForName(label);
        int propertyKeyId = tokenWrite.propertyKeyGetOrCreateForName(propertyKey);
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        ConstraintDescriptor constraint = schemaWrite.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyKeyId})));
        this.commit();
        return constraint;
    }

    private ConstraintDescriptor createRelationshipConstraint(String type, String propertyKey) throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int labelId = tokenWrite.relationshipTypeGetOrCreateForName(type);
        int propertyKeyId = tokenWrite.propertyKeyGetOrCreateForName(propertyKey);
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        ConstraintDescriptor constraint = schemaWrite.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)labelId, (int[])new int[]{propertyKeyId})));
        this.commit();
        return constraint;
    }

    static enum EntityControl {
        NODE{

            @Override
            int getOrCreateToken(TokenWrite tokenWrite, String tokenName) throws KernelException {
                return tokenWrite.labelGetOrCreateForName(tokenName);
            }

            @Override
            long createEntityWithToken(KernelTransaction tx, String tokenName) throws KernelException {
                int token = this.getOrCreateToken(tx.tokenWrite(), tokenName);
                Write write = tx.dataWrite();
                long node = write.nodeCreate();
                write.nodeAddLabel(node, token);
                return node;
            }

            @Override
            long createEntityWithTokenAndProp(Write write, int token, int propKey, Value value) throws KernelException {
                long node = write.nodeCreate();
                write.nodeAddLabel(node, token);
                write.nodeSetProperty(node, propKey, value);
                return node;
            }

            @Override
            long createEntityWithTokenAndProp(KernelTransaction tx, String token, String propKey, Value value) throws KernelException {
                int tok = tx.tokenWrite().labelGetOrCreateForName(token);
                int prop = tx.tokenWrite().propertyKeyGetOrCreateForName(propKey);
                return this.createEntityWithTokenAndProp(tx.dataWrite(), tok, prop, value);
            }

            @Override
            void setProperty(Write write, long entity, int propKey, Value value) throws KernelException {
                write.nodeSetProperty(entity, propKey, value);
            }

            @Override
            void removeProperty(Write write, long entity, int propKey) throws KernelException {
                write.nodeRemoveProperty(entity, propKey);
            }

            @Override
            void deleteEntity(Write write, long entity) {
                write.nodeDelete(entity);
            }

            @Override
            int countEntities(KernelTransaction tx) {
                return KernelIntegrationTest.countNodes(tx);
            }

            @Override
            SchemaDescriptor schema(int token, int propKey) {
                return SchemaDescriptors.forLabel((int)token, (int[])new int[]{propKey});
            }
        }
        ,
        RELATIONSHIP{

            @Override
            int getOrCreateToken(TokenWrite tokenWrite, String tokenName) throws KernelException {
                return tokenWrite.relationshipTypeGetOrCreateForName(tokenName);
            }

            @Override
            long createEntityWithToken(KernelTransaction tx, String tokenName) throws KernelException {
                int token = this.getOrCreateToken(tx.tokenWrite(), tokenName);
                Write write = tx.dataWrite();
                long node = write.nodeCreate();
                return write.relationshipCreate(node, token, node);
            }

            @Override
            long createEntityWithTokenAndProp(Write write, int token, int propKey, Value value) throws KernelException {
                long node = write.nodeCreate();
                long rel = write.relationshipCreate(node, token, node);
                write.relationshipSetProperty(rel, propKey, value);
                return rel;
            }

            @Override
            long createEntityWithTokenAndProp(KernelTransaction tx, String token, String propKey, Value value) throws KernelException {
                int tok = tx.tokenWrite().relationshipTypeGetOrCreateForName(token);
                int prop = tx.tokenWrite().propertyKeyGetOrCreateForName(propKey);
                return this.createEntityWithTokenAndProp(tx.dataWrite(), tok, prop, value);
            }

            @Override
            void setProperty(Write write, long entity, int propKey, Value value) throws KernelException {
                write.relationshipSetProperty(entity, propKey, value);
            }

            @Override
            void removeProperty(Write write, long entity, int propKey) throws KernelException {
                write.relationshipRemoveProperty(entity, propKey);
            }

            @Override
            void deleteEntity(Write write, long entity) {
                write.relationshipDelete(entity);
            }

            @Override
            int countEntities(KernelTransaction tx) {
                return KernelIntegrationTest.countRelationships(tx);
            }

            @Override
            SchemaDescriptor schema(int token, int propKey) {
                return SchemaDescriptors.forRelType((int)token, (int[])new int[]{propKey});
            }
        };


        abstract int getOrCreateToken(TokenWrite var1, String var2) throws KernelException;

        abstract long createEntityWithToken(KernelTransaction var1, String var2) throws KernelException;

        abstract long createEntityWithTokenAndProp(Write var1, int var2, int var3, Value var4) throws KernelException;

        abstract long createEntityWithTokenAndProp(KernelTransaction var1, String var2, String var3, Value var4) throws KernelException;

        abstract void setProperty(Write var1, long var2, int var4, Value var5) throws KernelException;

        abstract void removeProperty(Write var1, long var2, int var4) throws KernelException;

        abstract void deleteEntity(Write var1, long var2);

        abstract int countEntities(KernelTransaction var1);

        abstract SchemaDescriptor schema(int var1, int var2);
    }
}

