/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextRelationship;
import org.neo4j.kernel.impl.core.RelationshipReadOperationsTest;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;

public class ExecutionContextRelationshipReadOperationsTest
extends RelationshipReadOperationsTest {
    private final Map<Transaction, ExecutionContext> executionContexts = new HashMap<Transaction, ExecutionContext>();

    @AfterEach
    void afterEach() {
        this.executionContexts.values().forEach(ExecutionContext::complete);
        IOUtils.closeAllUnchecked(this.executionContexts.values());
    }

    @Override
    protected Relationship lookupRelationship(Transaction tx, String id) {
        ExecutionContext executionContext = this.getExecutionContext(tx);
        long internalId = executionContext.elementIdMapper().relationshipId(id);
        return new ExecutionContextRelationship(internalId, executionContext);
    }

    private ExecutionContext getExecutionContext(Transaction tx) {
        return this.executionContexts.computeIfAbsent(tx, t -> {
            KernelTransaction ktx = ((InternalTransaction)t).kernelTransaction();
            try (Statement statement = ktx.acquireStatement();){
                ExecutionContext executionContext = ktx.createExecutionContext();
                return executionContext;
            }
        });
    }
}

