/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorCounters;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.PageCacheTracerAssertions;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
abstract class NodeReadOperationsTest {
    private final String PROPERTY_KEY = "PROPERTY_KEY";
    @Inject
    private GraphDatabaseAPI db;

    NodeReadOperationsTest() {
    }

    @Test
    void testNodeRelationshipsLookup() {
        String rel4Id;
        String rel3Id;
        String rel2Id;
        String rel1Id;
        String node1Id;
        Node node1;
        RelationshipType outgoing1 = RelationshipType.withName((String)"outgoing-1");
        RelationshipType outgoing2 = RelationshipType.withName((String)"outgoing-2");
        RelationshipType incoming1 = RelationshipType.withName((String)"incoming-1");
        try (Transaction rx = this.db.beginTx();){
            node1 = rx.createNode();
            Node node2 = rx.createNode();
            Node node3 = rx.createNode();
            node1Id = node1.getElementId();
            rel1Id = node1.createRelationshipTo(node2, outgoing1).getElementId();
            rel2Id = node1.createRelationshipTo(node2, outgoing2).getElementId();
            rel3Id = node2.createRelationshipTo(node1, incoming1).getElementId();
            rel4Id = node1.createRelationshipTo(node3, outgoing1).getElementId();
            rx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            node1 = this.lookupNode(tx, node1Id);
            Assertions.assertThat(this.toIds((ResourceIterable<Relationship>)node1.getRelationships())).containsExactlyInAnyOrder((Object[])new String[]{rel1Id, rel2Id, rel3Id, rel4Id});
            Assertions.assertThat(this.toIds((ResourceIterable<Relationship>)node1.getRelationships(new RelationshipType[]{outgoing1}))).containsExactlyInAnyOrder((Object[])new String[]{rel1Id, rel4Id});
            Assertions.assertThat(this.toIds((ResourceIterable<Relationship>)node1.getRelationships(new RelationshipType[]{outgoing2}))).containsExactlyInAnyOrder((Object[])new String[]{rel2Id});
            Assertions.assertThat(this.toIds((ResourceIterable<Relationship>)node1.getRelationships(new RelationshipType[]{incoming1}))).containsExactlyInAnyOrder((Object[])new String[]{rel3Id});
            Assertions.assertThat(this.toIds((ResourceIterable<Relationship>)node1.getRelationships(Direction.OUTGOING))).containsExactlyInAnyOrder((Object[])new String[]{rel1Id, rel2Id, rel4Id});
            Assertions.assertThat(this.toIds((ResourceIterable<Relationship>)node1.getRelationships(Direction.INCOMING))).containsExactlyInAnyOrder((Object[])new String[]{rel3Id});
            Assertions.assertThat(this.toIds((ResourceIterable<Relationship>)node1.getRelationships(Direction.BOTH))).containsExactlyInAnyOrder((Object[])new String[]{rel1Id, rel2Id, rel3Id, rel4Id});
            Assertions.assertThat(this.toIds((ResourceIterable<Relationship>)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{outgoing1}))).containsExactlyInAnyOrder((Object[])new String[]{rel1Id, rel4Id});
            Assertions.assertThat(this.toIds((ResourceIterable<Relationship>)node1.getRelationships(Direction.INCOMING, new RelationshipType[]{outgoing1}))).isEmpty();
            Assertions.assertThat((boolean)node1.hasRelationship()).isTrue();
            Assertions.assertThat((boolean)node1.hasRelationship(Direction.OUTGOING, new RelationshipType[]{outgoing1})).isTrue();
            Assertions.assertThat((boolean)node1.hasRelationship(Direction.INCOMING, new RelationshipType[]{outgoing1})).isFalse();
            Assertions.assertThat((int)node1.getDegree()).isEqualTo(4);
            Assertions.assertThat((int)node1.getDegree(outgoing1)).isEqualTo(2);
            Assertions.assertThat((int)node1.getDegree(outgoing2)).isEqualTo(1);
            Assertions.assertThat((int)node1.getDegree(incoming1)).isEqualTo(1);
            Assertions.assertThat((int)node1.getDegree(Direction.OUTGOING)).isEqualTo(3);
            Assertions.assertThat((int)node1.getDegree(Direction.INCOMING)).isEqualTo(1);
            Assertions.assertThat((int)node1.getDegree(Direction.BOTH)).isEqualTo(4);
            Assertions.assertThat((int)node1.getDegree(outgoing1, Direction.OUTGOING)).isEqualTo(2);
            Assertions.assertThat((int)node1.getDegree(outgoing1, Direction.INCOMING)).isEqualTo(0);
            Assertions.assertThat((String)node1.getSingleRelationship(outgoing2, Direction.OUTGOING).getElementId()).isEqualTo(rel2Id);
            Assertions.assertThat((Object)node1.getSingleRelationship(incoming1, Direction.OUTGOING)).isNull();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> node1.getSingleRelationship(outgoing1, Direction.OUTGOING)).isInstanceOf(NotFoundException.class)).hasMessageContaining("More than one relationship[outgoing-1, OUTGOING] found for Node");
            Assertions.assertThat((Iterable)node1.getRelationshipTypes()).containsExactlyInAnyOrder((Object[])new RelationshipType[]{outgoing1, outgoing2, incoming1});
        }
    }

    @Test
    void testLabelLookup() {
        String nodeId;
        Node node;
        Label label1 = Label.label((String)"label-1");
        Label label2 = Label.label((String)"label-2");
        try (Transaction rx = this.db.beginTx();){
            node = rx.createNode();
            nodeId = node.getElementId();
            node.addLabel(label1);
            node.addLabel(label2);
            rx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            node = this.lookupNode(tx, nodeId);
            Assertions.assertThat((boolean)node.hasLabel(label1)).isTrue();
            Assertions.assertThat((boolean)node.hasLabel(label2)).isTrue();
            Assertions.assertThat((boolean)node.hasLabel(Label.label((String)"another"))).isFalse();
            Assertions.assertThat((Iterable)node.getLabels()).containsExactlyInAnyOrder((Object[])new Label[]{label1, label2});
        }
    }

    @Test
    void testPropertyLookup() {
        String nodeId;
        Node node;
        String prop1 = "prop1";
        String value1 = "value1";
        String prop2 = "prop2";
        String value2 = "value2";
        String prop3 = "prop3";
        String value3 = "value3";
        try (Transaction rx = this.db.beginTx();){
            node = rx.createNode();
            nodeId = node.getElementId();
            node.setProperty(prop1, (Object)value1);
            node.setProperty(prop2, (Object)value2);
            node.setProperty(prop3, (Object)value3);
            rx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            node = this.lookupNode(tx, nodeId);
            Assertions.assertThat((Map)node.getAllProperties()).containsExactlyInAnyOrderEntriesOf(Map.of(prop1, value1, prop2, value2, prop3, value3));
            Assertions.assertThat((Map)node.getProperties(new String[]{prop1, prop3})).containsExactlyInAnyOrderEntriesOf(Map.of(prop1, value1, prop3, value3));
            Assertions.assertThat((Map)node.getProperties(new String[]{prop1, "another", prop3})).containsExactlyInAnyOrderEntriesOf(Map.of(prop1, value1, prop3, value3));
            Assertions.assertThat((Object)node.getProperty(prop1)).isEqualTo((Object)value1);
            Assertions.assertThat((Object)node.getProperty(prop1, (Object)"default value")).isEqualTo((Object)value1);
            Assertions.assertThat((Object)node.getProperty("another", (Object)"default value")).isEqualTo((Object)"default value");
            Assertions.assertThat((boolean)node.hasProperty(prop1)).isTrue();
            Assertions.assertThat((boolean)node.hasProperty("another")).isFalse();
            Assertions.assertThat((Iterable)node.getPropertyKeys()).containsExactlyInAnyOrder((Object[])new String[]{prop1, prop2, prop3});
        }
    }

    @Test
    void shouldThrowHumaneExceptionsWhenPropertyDoesNotExistOnNode() {
        String nodeId;
        this.createNodeWith("PROPERTY_KEY");
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            nodeId = node.getElementId();
            tx.commit();
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (Transaction tx = this.db.beginTx();){
                Node node = this.lookupNode(tx, nodeId);
                node.getProperty("PROPERTY_KEY");
            }
        }).isInstanceOf(NotFoundException.class)).hasMessageContaining("No such property, 'PROPERTY_KEY");
    }

    @Test
    void shouldThrowHumaneExceptionsWhenPropertyKeyDoesNotExist() {
        String nodeId;
        try (Transaction tx = this.db.beginTx();){
            nodeId = tx.createNode().getElementId();
            tx.commit();
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (Transaction tx = this.db.beginTx();){
                Node node = this.lookupNode(tx, nodeId);
                node.getProperty("PROPERTY_KEY");
            }
        }).isInstanceOf(NotFoundException.class)).hasMessageContaining("No such property, 'PROPERTY_KEY");
    }

    @Test
    void traceNodePageCacheAccessOnDegreeCount() {
        String sourceId;
        Node source;
        try (Transaction tx = this.db.beginTx();){
            source = tx.createNode();
            RelationshipType relationshipType = RelationshipType.withName((String)"connection");
            NodeReadOperationsTest.createDenseNodeWithShortIncomingChain(tx, source, relationshipType);
            sourceId = source.getElementId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            source = this.lookupNode(tx, sourceId);
            PageCursorTracer cursorTracer = this.reportCursorEventsAndGetTracer(tx);
            source.getDegree(Direction.INCOMING);
            PageCacheTracerAssertions.assertThatTracing((GraphDatabaseAPI)this.db).record(PageCacheTracerAssertions.pins((long)2L).atMost(3L).noFaults().skipUnpins()).block(PageCacheTracerAssertions.pins((long)1L).atMost(2L).noFaults().skipUnpins()).spd(PageCacheTracerAssertions.pins((long)1L).atMost(2L).noFaults().skipUnpins()).matches((PageCursorCounters)cursorTracer);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void traceNodePageCacheAccessOnRelationshipTypeAndDegreeCount() {
        String sourceId;
        Node source;
        RelationshipType relationshipType = RelationshipType.withName((String)"connection");
        try (Transaction tx = this.db.beginTx();){
            source = tx.createNode();
            NodeReadOperationsTest.createDenseNodeWithShortIncomingChain(tx, source, relationshipType);
            sourceId = source.getElementId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            source = this.lookupNode(tx, sourceId);
            PageCursorTracer cursorTracer = this.reportCursorEventsAndGetTracer(tx);
            source.getDegree(relationshipType, Direction.INCOMING);
            PageCacheTracerAssertions.assertThatTracing((GraphDatabaseAPI)this.db).record(PageCacheTracerAssertions.pins((long)2L).atMost(3L).noFaults().skipUnpins()).block(PageCacheTracerAssertions.pins((long)1L).atMost(2L).noFaults().skipUnpins()).spd(PageCacheTracerAssertions.pins((long)1L).atMost(2L).noFaults().skipUnpins()).matches((PageCursorCounters)cursorTracer);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void traceNodePageCacheAccessOnRelationshipsAccess() {
        String targetId;
        RelationshipType relationshipType = RelationshipType.withName((String)"connection");
        try (Transaction tx = this.db.beginTx();){
            Node target = tx.createNode();
            for (int i = 0; i < 100; ++i) {
                tx.createNode().createRelationshipTo(target, relationshipType);
            }
            targetId = target.getElementId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Node source = this.lookupNode(tx, targetId);
            PageCursorTracer cursorTracer = this.reportCursorEventsAndGetTracer(tx);
            Assertions.assertThat((long)Iterables.count((Iterable)source.getRelationships(Direction.INCOMING, new RelationshipType[]{relationshipType}))).isGreaterThan(0L);
            PageCacheTracerAssertions.assertThatTracing((GraphDatabaseAPI)this.db).record(PageCacheTracerAssertions.pins((long)2L).atMost(3L).noFaults().skipUnpins()).block(PageCacheTracerAssertions.pins((long)1L).atMost(2L).noFaults().skipUnpins()).spd(PageCacheTracerAssertions.pins((long)1L).atMost(2L).noFaults().skipUnpins()).matches((PageCursorCounters)cursorTracer);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private List<String> toIds(ResourceIterable<Relationship> relationships) {
        try (ResourceIterable<Relationship> resourceIterable = relationships;){
            List<String> list = relationships.stream().map(Entity::getElementId).collect(Collectors.toList());
            return list;
        }
    }

    private void createNodeWith(String key) {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            node.setProperty(key, (Object)1);
            tx.commit();
        }
    }

    static void assertZeroTracer(CursorContext cursorContext) {
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.hits()).isZero();
        Assertions.assertThat((long)cursorTracer.unpins()).isZero();
        Assertions.assertThat((long)cursorTracer.pins()).isZero();
    }

    private static void createDenseNodeWithShortIncomingChain(Transaction tx, Node source, RelationshipType relationshipType) {
        for (int i = 0; i < 300; ++i) {
            source.createRelationshipTo(tx.createNode(), relationshipType);
        }
        tx.createNode().createRelationshipTo(source, relationshipType);
    }

    abstract PageCursorTracer reportCursorEventsAndGetTracer(Transaction var1);

    protected abstract Node lookupNode(Transaction var1, String var2);
}

