/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;

class TestIsolationBasic
extends AbstractNeo4jTestCase {
    TestIsolationBasic() {
    }

    @Test
    void testSimpleTransactionIsolation() throws Exception {
        Relationship txRel;
        Node txNode2;
        Node txNode;
        String r1Id;
        String n2Id;
        String n1Id;
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        try (Transaction tx = this.getGraphDb().beginTx();){
            Node n1 = tx.createNode();
            n1Id = n1.getElementId();
            Node n2 = tx.createNode();
            n2Id = n2.getElementId();
            r1Id = n1.createRelationshipTo(n2, RelationshipType.withName((String)"TEST")).getElementId();
            tx.commit();
        }
        String node1 = n1Id;
        String node2 = n2Id;
        String rel1 = r1Id;
        try (Transaction tx = this.getGraphDb().beginTx();){
            tx.getNodeByElementId(node1).setProperty("key", (Object)"old");
            tx.getRelationshipByElementId(rel1).setProperty("key", (Object)"old");
            tx.commit();
        }
        tx = this.getGraphDb().beginTx();
        try {
            Node txNode3 = tx.getNodeByElementId(node1);
            Node txNode22 = tx.getNodeByElementId(node2);
            Relationship txRel2 = tx.getRelationshipByElementId(rel1);
            TestIsolationBasic.assertPropertyEqual((Entity)txNode3, "key", "old");
            TestIsolationBasic.assertPropertyEqual((Entity)txRel2, "key", "old");
            TestIsolationBasic.assertRelationshipCount(txNode3, 1);
            TestIsolationBasic.assertRelationshipCount(txNode22, 1);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        AtomicReference t1Exception = new AtomicReference();
        Thread t1 = new Thread(() -> {
            try (Transaction tx = this.getGraphDb().beginTx();){
                Node txNode = tx.getNodeByElementId(node1);
                Node txNode2 = tx.getNodeByElementId(node2);
                Relationship txRel = tx.getRelationshipByElementId(rel1);
                txNode.setProperty("key", (Object)"new");
                txRel.setProperty("key", (Object)"new");
                txNode.createRelationshipTo(txNode2, RelationshipType.withName((String)"TEST"));
                TestIsolationBasic.assertPropertyEqual((Entity)txNode, "key", "new");
                TestIsolationBasic.assertPropertyEqual((Entity)txRel, "key", "new");
                TestIsolationBasic.assertRelationshipCount(txNode, 2);
                TestIsolationBasic.assertRelationshipCount(txNode2, 2);
                latch1.countDown();
                latch2.await();
                TestIsolationBasic.assertPropertyEqual((Entity)txNode, "key", "new");
                TestIsolationBasic.assertPropertyEqual((Entity)txRel, "key", "new");
                TestIsolationBasic.assertRelationshipCount(txNode, 2);
                TestIsolationBasic.assertRelationshipCount(txNode2, 2);
            }
            catch (Exception e) {
                Thread.interrupted();
                t1Exception.set(e);
            }
            finally {
                try (Transaction tx2 = this.getGraphDb().beginTx();){
                    Node txNode = tx2.getNodeByElementId(node1);
                    Node txNode2 = tx2.getNodeByElementId(node2);
                    Relationship txRel = tx2.getRelationshipByElementId(rel1);
                    TestIsolationBasic.assertPropertyEqual((Entity)txNode, "key", "old");
                    TestIsolationBasic.assertPropertyEqual((Entity)txRel, "key", "old");
                    TestIsolationBasic.assertRelationshipCount(txNode, 1);
                    TestIsolationBasic.assertRelationshipCount(txNode2, 1);
                }
                catch (Exception e) {
                    t1Exception.compareAndSet(null, e);
                }
            }
        });
        t1.start();
        latch1.await();
        try (Transaction tx = this.getGraphDb().beginTx();){
            txNode = tx.getNodeByElementId(node1);
            txNode2 = tx.getNodeByElementId(node2);
            txRel = tx.getRelationshipByElementId(rel1);
            TestIsolationBasic.assertPropertyEqual((Entity)txNode, "key", "old");
            TestIsolationBasic.assertPropertyEqual((Entity)txRel, "key", "old");
            TestIsolationBasic.assertRelationshipCount(txNode, 1);
            TestIsolationBasic.assertRelationshipCount(txNode2, 1);
        }
        latch2.countDown();
        t1.join();
        tx = this.getGraphDb().beginTx();
        try {
            txNode = tx.getNodeByElementId(node1);
            txNode2 = tx.getNodeByElementId(node2);
            txRel = tx.getRelationshipByElementId(rel1);
            TestIsolationBasic.assertPropertyEqual((Entity)txNode, "key", "old");
            TestIsolationBasic.assertPropertyEqual((Entity)txRel, "key", "old");
            TestIsolationBasic.assertRelationshipCount(txNode, 1);
            TestIsolationBasic.assertRelationshipCount(txNode2, 1);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        if (t1Exception.get() != null) {
            throw (Exception)t1Exception.get();
        }
        tx = this.getGraphDb().beginTx();
        try {
            txNode = tx.getNodeByElementId(node1);
            txNode2 = tx.getNodeByElementId(node2);
            Iterables.forEach((Iterable)txNode.getRelationships(), Entity::delete);
            txNode.delete();
            txNode2.delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static void assertPropertyEqual(Entity primitive, String key, String value) {
        Assertions.assertEquals((Object)value, (Object)primitive.getProperty(key));
    }

    private static void assertRelationshipCount(Node node, int count) {
        Assertions.assertEquals((int)count, (int)((int)Iterables.count((Iterable)node.getRelationships())));
    }
}

