/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;

class TestLengthyArrayPacking
extends AbstractNeo4jTestCase {
    private static final String SOME_MIXED_CHARS = "abc421#\u00a4\u00e5\u00e4\u00f6(/&\u20ac";
    private static final String SOME_LATIN_1_CHARS = "abcdefghijklmnopqrstuvwxyz";
    private final DynamicRecordCounter ARRAY_RECORD_COUNTER = new ArrayRecordCounter();
    private final DynamicRecordCounter STRING_RECORD_COUNTER = new StringRecordCounter();

    TestLengthyArrayPacking() {
    }

    @Test
    void bitPackingOfLengthyArrays() {
        Node node;
        long arrayRecordsBefore = this.dynamicArrayRecordsInUse();
        int[] arrayWhichUnpackedWouldFillTwoDynamicRecords = new int[40];
        String key = "the array";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            for (int i = 0; i < arrayWhichUnpackedWouldFillTwoDynamicRecords.length; ++i) {
                arrayWhichUnpackedWouldFillTwoDynamicRecords[i] = i * i;
            }
            node = transaction.createNode();
            node.setProperty(key, (Object)arrayWhichUnpackedWouldFillTwoDynamicRecords);
            transaction.commit();
        }
        Assertions.assertEquals((long)(arrayRecordsBefore + 1L), (long)this.dynamicArrayRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertArrayEquals((int[])arrayWhichUnpackedWouldFillTwoDynamicRecords, (int[])((int[])transaction.getNodeById(node.getId()).getProperty(key)));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void makeSureLongLatin1StringUsesOneBytePerChar() {
        String string = TestLengthyArrayPacking.stringOfLength(SOME_LATIN_1_CHARS, 239);
        this.makeSureRightAmountOfDynamicRecordsUsed(string, 2, this.STRING_RECORD_COUNTER);
    }

    @Test
    void makeSureLongUtf8StringUsesLessThanTwoBytesPerChar() {
        String string = TestLengthyArrayPacking.stringOfLength(SOME_MIXED_CHARS, 130);
        this.makeSureRightAmountOfDynamicRecordsUsed(string, 2, this.STRING_RECORD_COUNTER);
    }

    @Test
    void makeSureLongLatin1StringArrayUsesOneBytePerChar() {
        String[] stringArray = new String[5];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = TestLengthyArrayPacking.stringOfLength(SOME_LATIN_1_CHARS, 19);
        }
        this.makeSureRightAmountOfDynamicRecordsUsed(stringArray, 1, this.ARRAY_RECORD_COUNTER);
    }

    @Test
    void makeSureLongUtf8StringArrayUsesLessThanTwoBytePerChar() {
        String[] stringArray = new String[7];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = TestLengthyArrayPacking.stringOfLength(SOME_MIXED_CHARS, 20);
        }
        this.makeSureRightAmountOfDynamicRecordsUsed(stringArray, 2, this.ARRAY_RECORD_COUNTER);
    }

    private void makeSureRightAmountOfDynamicRecordsUsed(Object value, int expectedAddedDynamicRecords, DynamicRecordCounter recordCounter) {
        long stringRecordsBefore = recordCounter.count();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node = transaction.createNode();
            node.setProperty("name", value);
            transaction.commit();
        }
        long stringRecordsAfter = recordCounter.count();
        Assertions.assertEquals((long)(stringRecordsBefore + (long)expectedAddedDynamicRecords), (long)stringRecordsAfter);
    }

    private static String stringOfLength(String possibilities, int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(possibilities.charAt(i % possibilities.length()));
        }
        return builder.toString();
    }

    private class ArrayRecordCounter
    implements DynamicRecordCounter {
        private ArrayRecordCounter() {
        }

        @Override
        public long count() {
            return TestLengthyArrayPacking.this.dynamicArrayRecordsInUse();
        }
    }

    private static interface DynamicRecordCounter {
        public long count();
    }

    private class StringRecordCounter
    implements DynamicRecordCounter {
        private StringRecordCounter() {
        }

        @Override
        public long count() {
            return TestLengthyArrayPacking.this.dynamicStringRecordsInUse();
        }
    }
}

