/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;

class TestProperties
extends AbstractNeo4jTestCase {
    private static final int VALUE_RANGE_SPLIT = 20;

    TestProperties() {
    }

    @Test
    void addAndRemovePropertiesWithinOneTransaction() {
        String node = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeByElementId(node);
            txNode.setProperty("name", (Object)"oscar");
            txNode.setProperty("favourite_numbers", (Object)new Long[]{1L, 2L, 3L});
            txNode.setProperty("favourite_colors", (Object)new String[]{"blue", "red"});
            txNode.removeProperty("favourite_colors");
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertNotNull((Object)transaction.getNodeByElementId(node).getProperty("favourite_numbers", null));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void addAndRemovePropertiesWithinOneTransaction2() {
        String node = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeByElementId(node).setProperty("foo", (Object)"bar");
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Node txNode = transaction.getNodeByElementId(node);
            txNode.setProperty("foo2", (Object)"bar");
            txNode.removeProperty("foo");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertThrows(NotFoundException.class, () -> transaction.getNodeByElementId(node).getProperty("foo"));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void removeAndAddSameProperty() {
        Node txNode;
        String node = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeByElementId(node).setProperty("foo", (Object)"bar");
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeByElementId(node);
            txNode.removeProperty("foo");
            txNode.setProperty("foo", (Object)"bar");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertEquals((Object)"bar", (Object)transaction.getNodeByElementId(node).getProperty("foo"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeByElementId(node);
            txNode.setProperty("foo", (Object)"bar");
            txNode.removeProperty("foo");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertNull((Object)transaction.getNodeByElementId(node).getProperty("foo", null));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void removeSomeAndSetSome() {
        Node txNode;
        String node = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeByElementId(node).setProperty("remove me", (Object)"trash");
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeByElementId(node);
            txNode.removeProperty("remove me");
            txNode.setProperty("foo", (Object)"bar");
            txNode.setProperty("baz", (Object)17);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeByElementId(node);
            Assertions.assertEquals((Object)"bar", (Object)txNode.getProperty("foo"));
            Assertions.assertEquals((Object)17, (Object)txNode.getProperty("baz"));
            Assertions.assertNull((Object)txNode.getProperty("remove me", null));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void removeOneOfThree() {
        String node = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeByElementId(node);
            txNode.setProperty("1", (Object)1);
            txNode.setProperty("2", (Object)2);
            txNode.setProperty("3", (Object)3);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeByElementId(node).removeProperty("2");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertNull((Object)transaction.getNodeByElementId(node).getProperty("2", null));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testLongPropertyValues() {
        String n = this.createNode();
        this.setPropertyAndAssertIt(n, -134217728L);
        this.setPropertyAndAssertIt(n, -134217729L);
    }

    @Test
    void testIntPropertyValues() {
        String n = this.createNode();
        this.setPropertyAndAssertIt(n, -134217728);
        this.setPropertyAndAssertIt(n, -134217729);
    }

    @Test
    void booleanRange() {
        String node = this.createNode();
        this.setPropertyAndAssertIt(node, false);
        this.setPropertyAndAssertIt(node, true);
    }

    @Test
    void byteRange() {
        String node = this.createNode();
        int stride = 6;
        byte i = -128;
        while (i < 127) {
            this.setPropertyAndAssertIt(node, i);
            i = i > 0 && 127 - i < stride ? (byte)127 : (byte)(i + stride);
        }
    }

    @Test
    void charRange() {
        String node = this.createNode();
        int stride = 3276;
        char i = '\u0000';
        while (i < '\uffff') {
            this.setPropertyAndAssertIt(node, Character.valueOf(i));
            i = i > '\u0000' && 65535 - i < stride ? (char)65535 : (char)(i + stride);
        }
    }

    @Test
    void shortRange() {
        String node = this.createNode();
        int stride = 1638;
        short i = Short.MIN_VALUE;
        while (i < Short.MAX_VALUE) {
            this.setPropertyAndAssertIt(node, i);
            i = i > 0 && Short.MAX_VALUE - i < stride ? (short)Short.MAX_VALUE : (short)(i + stride);
        }
    }

    @Test
    void intRange() {
        String node = this.createNode();
        int stride = 0x6666666;
        int i = Integer.MIN_VALUE;
        while (i < Integer.MAX_VALUE) {
            this.setPropertyAndAssertIt(node, i);
            i = i > 0 && Integer.MAX_VALUE - i < stride ? Integer.MAX_VALUE : i + stride;
        }
    }

    @Test
    void longRange() {
        String node = this.createNode();
        long stride = 0x666666666666666L;
        long i = Long.MIN_VALUE;
        while (i < Long.MAX_VALUE) {
            this.setPropertyAndAssertIt(node, i);
            i = i > 0L && Long.MAX_VALUE - i < stride ? Long.MAX_VALUE : i + stride;
        }
    }

    @Test
    void floatRange() {
        String node = this.createNode();
        float stride = 16.0f;
        for (float i = Float.MIN_VALUE; i < Float.MAX_VALUE; i *= stride) {
            this.setPropertyAndAssertIt(node, Float.valueOf(i));
            this.setPropertyAndAssertIt(node, Float.valueOf(-i));
        }
    }

    @Test
    void doubleRange() {
        String node = this.createNode();
        double stride = 4194304.0;
        for (double i = Double.MIN_VALUE; i < Double.MAX_VALUE; i *= stride) {
            this.setPropertyAndAssertIt(node, i);
            this.setPropertyAndAssertIt(node, -i);
        }
    }

    private void setPropertyAndAssertIt(String nodeId, Object value) {
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeByElementId(nodeId);
            txNode.setProperty("key", value);
            Assertions.assertEquals((Object)value, (Object)txNode.getProperty("key"));
            transaction.commit();
        }
    }

    @Test
    void loadManyProperties() {
        String node = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeByElementId(node);
            for (int i = 0; i < 200; ++i) {
                txNode.setProperty("property " + i, (Object)"value");
            }
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertEquals((Object)"value", (Object)transaction.getNodeByElementId(node).getProperty("property 0"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void name() {
        String node = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeByElementId(node);
            txNode.setProperty("name", (Object)"yo");
            txNode.getProperty("name");
            transaction.commit();
        }
        try (Transaction tx = this.getGraphDb().beginTx();){
            tx.getNodeByElementId(node).getProperty("name");
            tx.commit();
        }
    }
}

