/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

class TestRelationship
extends AbstractNeo4jTestCase {
    private static final String key1 = "key1";
    private static final String key2 = "key2";
    private static final String key3 = "key3";

    TestRelationship() {
    }

    @Test
    void testSimple1() {
        Node node2;
        Node node1;
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            node1 = transaction.getNodeByElementId(node1Id);
            node2 = transaction.getNodeByElementId(node2Id);
            for (int i = 0; i < 3; ++i) {
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
            }
            TestRelationship.allGetRelationshipMethods(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods(node2, Direction.INCOMING);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeByElementId(node1Id);
            node2 = transaction.getNodeByElementId(node2Id);
            TestRelationship.allGetRelationshipMethods(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods(node2, Direction.INCOMING);
            TestRelationship.deleteFirst((ResourceIterable<Relationship>)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST}));
            TestRelationship.deleteFirst((ResourceIterable<Relationship>)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
            TestRelationship.deleteFirst((ResourceIterable<Relationship>)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST2}));
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
            TestRelationship.allGetRelationshipMethods(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods(node2, Direction.INCOMING);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeByElementId(node1Id);
            node2 = transaction.getNodeByElementId(node2Id);
            TestRelationship.allGetRelationshipMethods(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods(node2, Direction.INCOMING);
            Iterables.forEach((Iterable)node1.getRelationships(), Entity::delete);
            node1.delete();
            node2.delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testSimple2() {
        Node node2;
        Node node1;
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            node1 = transaction.getNodeByElementId(node1Id);
            node2 = transaction.getNodeByElementId(node2Id);
            for (int i = 0; i < 1; ++i) {
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
            }
            TestRelationship.allGetRelationshipMethods2(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods2(node2, Direction.INCOMING);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeByElementId(node1Id);
            node2 = transaction.getNodeByElementId(node2Id);
            TestRelationship.allGetRelationshipMethods2(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods2(node2, Direction.INCOMING);
            TestRelationship.deleteFirst((ResourceIterable<Relationship>)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST}));
            TestRelationship.deleteFirst((ResourceIterable<Relationship>)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
            TestRelationship.deleteFirst((ResourceIterable<Relationship>)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST2}));
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
            TestRelationship.allGetRelationshipMethods2(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods2(node2, Direction.INCOMING);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeByElementId(node1Id);
            node2 = transaction.getNodeByElementId(node2Id);
            TestRelationship.allGetRelationshipMethods2(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods2(node2, Direction.INCOMING);
            Iterables.forEach((Iterable)node1.getRelationships(), Entity::delete);
            node1.delete();
            node2.delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testSimple3() {
        Node node2;
        Node node1;
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            node1 = transaction.getNodeByElementId(node1Id);
            node2 = transaction.getNodeByElementId(node2Id);
            for (int i = 0; i < 2; ++i) {
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
            }
            TestRelationship.allGetRelationshipMethods3(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods3(node2, Direction.INCOMING);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeByElementId(node1Id);
            node2 = transaction.getNodeByElementId(node2Id);
            TestRelationship.allGetRelationshipMethods3(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods3(node2, Direction.INCOMING);
            TestRelationship.deleteFirst((ResourceIterable<Relationship>)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST}));
            TestRelationship.deleteAtIndex((ResourceIterable<Relationship>)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}), 1);
            TestRelationship.deleteFirst((ResourceIterable<Relationship>)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST2}));
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
            TestRelationship.allGetRelationshipMethods3(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods3(node2, Direction.INCOMING);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeByElementId(node1Id);
            node2 = transaction.getNodeByElementId(node2Id);
            TestRelationship.allGetRelationshipMethods3(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods3(node2, Direction.INCOMING);
            Iterables.forEach((Iterable)node1.getRelationships(), Entity::delete);
            node1.delete();
            node2.delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private static void allGetRelationshipMethods(Node node, Direction dir) {
        TestRelationship.countRelationships(9, (Iterable<Relationship>)node.getRelationships());
        TestRelationship.countRelationships(9, (Iterable<Relationship>)node.getRelationships(dir));
        TestRelationship.countRelationships(9, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(6, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2}));
        TestRelationship.countRelationships(6, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(6, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(3, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
        TestRelationship.countRelationships(3, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2}));
        TestRelationship.countRelationships(3, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(3, (Iterable<Relationship>)node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST}));
        TestRelationship.countRelationships(3, (Iterable<Relationship>)node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST2}));
        TestRelationship.countRelationships(3, (Iterable<Relationship>)node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
    }

    private static void allGetRelationshipMethods2(Node node, Direction dir) {
        TestRelationship.countRelationships(3, (Iterable<Relationship>)node.getRelationships());
        TestRelationship.countRelationships(3, (Iterable<Relationship>)node.getRelationships(dir));
        TestRelationship.countRelationships(3, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(2, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2}));
        TestRelationship.countRelationships(2, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(2, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(1, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
        TestRelationship.countRelationships(1, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2}));
        TestRelationship.countRelationships(1, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(1, (Iterable<Relationship>)node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST}));
        TestRelationship.countRelationships(1, (Iterable<Relationship>)node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST2}));
        TestRelationship.countRelationships(1, (Iterable<Relationship>)node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
    }

    private static void allGetRelationshipMethods3(Node node, Direction dir) {
        TestRelationship.countRelationships(6, (Iterable<Relationship>)node.getRelationships());
        TestRelationship.countRelationships(6, (Iterable<Relationship>)node.getRelationships(dir));
        TestRelationship.countRelationships(6, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(4, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2}));
        TestRelationship.countRelationships(4, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(4, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(2, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
        TestRelationship.countRelationships(2, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2}));
        TestRelationship.countRelationships(2, (Iterable<Relationship>)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(2, (Iterable<Relationship>)node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST}));
        TestRelationship.countRelationships(2, (Iterable<Relationship>)node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST2}));
        TestRelationship.countRelationships(2, (Iterable<Relationship>)node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
    }

    private static void countRelationships(int expectedCount, Iterable<Relationship> rels) {
        Assertions.assertEquals((int)expectedCount, (int)((int)Iterables.count(rels)));
    }

    private static void deleteFirst(ResourceIterable<Relationship> iterable) {
        TestRelationship.deleteAtIndex(iterable, 0);
    }

    private static void deleteAtIndex(ResourceIterable<Relationship> relationships, int index) {
        int pos = 0;
        try (ResourceIterable<Relationship> resourceIterable = relationships;){
            for (Relationship relationship : relationships) {
                if (pos == index) {
                    relationship.delete();
                    break;
                }
                ++pos;
            }
        }
    }

    @Test
    void testRelationshipCreateAndDelete() {
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            Relationship relationship = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Relationship[] relArray1 = TestRelationship.getRelationshipArray((Iterable<Relationship>)node1.getRelationships());
            Relationship[] relArray2 = TestRelationship.getRelationshipArray((Iterable<Relationship>)node2.getRelationships());
            Assertions.assertEquals((int)1, (int)relArray1.length);
            Assertions.assertEquals((Object)relationship, (Object)relArray1[0]);
            Assertions.assertEquals((int)1, (int)relArray2.length);
            Assertions.assertEquals((Object)relationship, (Object)relArray2[0]);
            relArray1 = TestRelationship.getRelationshipArray((Iterable<Relationship>)node1.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray1.length);
            Assertions.assertEquals((Object)relationship, (Object)relArray1[0]);
            relArray2 = TestRelationship.getRelationshipArray((Iterable<Relationship>)node2.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray2.length);
            Assertions.assertEquals((Object)relationship, (Object)relArray2[0]);
            relArray1 = TestRelationship.getRelationshipArray((Iterable<Relationship>)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray1.length);
            relArray2 = TestRelationship.getRelationshipArray((Iterable<Relationship>)node2.getRelationships(Direction.INCOMING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray2.length);
            relArray1 = TestRelationship.getRelationshipArray((Iterable<Relationship>)node1.getRelationships(Direction.INCOMING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)0, (int)relArray1.length);
            relArray2 = TestRelationship.getRelationshipArray((Iterable<Relationship>)node2.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)0, (int)relArray2.length);
            relationship.delete();
            node2.delete();
            node1.delete();
            transaction.commit();
        }
    }

    private static Relationship[] getRelationshipArray(Iterable<Relationship> relsIterable) {
        return (Relationship[])Iterables.asArray(Relationship.class, relsIterable);
    }

    @Test
    void testDeleteWithRelationship() {
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            node1.delete();
            node2.delete();
            Assertions.assertThrows(Exception.class, () -> ((Transaction)transaction).commit());
        }
    }

    @Test
    void testDeletedRelationship() {
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            Relationship relationship = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            relationship.delete();
            Assertions.assertThrows(Exception.class, () -> relationship.setProperty(key1, (Object)1));
            node1.delete();
            node2.delete();
            transaction.commit();
        }
    }

    @Test
    void testRelationshipAddPropertyWithNullKey() {
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Assertions.assertThrows(Exception.class, () -> rel1.setProperty(null, (Object)"bar"));
            transaction.commit();
        }
    }

    @Test
    void testRelationshipAddPropertyWithNullValue() {
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Assertions.assertThrows(Exception.class, () -> rel1.setProperty("foo", null));
        }
    }

    @Test
    void testRelationshipAddProperty() {
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Relationship rel2 = node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
            Integer int1 = 1;
            Integer int2 = 2;
            String string1 = "1";
            String string2 = "2";
            rel1.setProperty(key1, (Object)int1);
            rel2.setProperty(key1, (Object)string1);
            rel1.setProperty(key2, (Object)string2);
            rel2.setProperty(key2, (Object)int2);
            Assertions.assertTrue((boolean)rel1.hasProperty(key1));
            Assertions.assertTrue((boolean)rel2.hasProperty(key1));
            Assertions.assertTrue((boolean)rel1.hasProperty(key2));
            Assertions.assertTrue((boolean)rel2.hasProperty(key2));
            Assertions.assertFalse((boolean)rel1.hasProperty(key3));
            Assertions.assertFalse((boolean)rel2.hasProperty(key3));
            Assertions.assertEquals((Object)int1, (Object)rel1.getProperty(key1));
            Assertions.assertEquals((Object)string1, (Object)rel2.getProperty(key1));
            Assertions.assertEquals((Object)string2, (Object)rel1.getProperty(key2));
            Assertions.assertEquals((Object)int2, (Object)rel2.getProperty(key2));
        }
    }

    @Test
    void testRelationshipRemoveProperty() {
        Integer int1 = 1;
        Integer int2 = 2;
        String string1 = "1";
        String string2 = "2";
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Relationship rel2 = node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
            if (rel1.removeProperty(key1) != null) {
                Assertions.fail((String)"Remove of non existing property should return null");
            }
            rel1.setProperty(key1, (Object)int1);
            rel2.setProperty(key1, (Object)string1);
            rel1.setProperty(key2, (Object)string2);
            rel2.setProperty(key2, (Object)int2);
            Assertions.assertEquals((Object)int1, (Object)rel1.removeProperty(key1));
            Assertions.assertEquals((Object)string1, (Object)rel2.removeProperty(key1));
            if (rel2.removeProperty(key1) != null) {
                Assertions.fail((String)"Remove of non existing property should return null");
            }
            rel1.delete();
            rel2.delete();
            node1.delete();
            node2.delete();
            transaction.commit();
        }
    }

    @Test
    void testRelationshipChangeProperty() {
        Integer int1 = 1;
        Integer int2 = 2;
        String string1 = "1";
        String string2 = "2";
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Relationship rel2 = node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
            rel1.setProperty(key1, (Object)int1);
            rel2.setProperty(key1, (Object)string1);
            rel1.setProperty(key2, (Object)string2);
            rel2.setProperty(key2, (Object)int2);
            Assertions.assertThrows(IllegalArgumentException.class, () -> rel1.setProperty(null, null));
            rel2.setProperty(key1, (Object)int1);
            rel1.delete();
            rel2.delete();
            node2.delete();
            node1.delete();
            transaction.commit();
        }
    }

    @Test
    void testRelationshipChangeProperty2() {
        Integer int1 = 1;
        Integer int2 = 2;
        String string1 = "1";
        String string2 = "2";
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            rel1.setProperty(key1, (Object)int1);
            rel1.setProperty(key1, (Object)int2);
            Assertions.assertEquals((Object)int2, (Object)rel1.getProperty(key1));
            rel1.removeProperty(key1);
            rel1.setProperty(key1, (Object)string1);
            rel1.setProperty(key1, (Object)string2);
            Assertions.assertEquals((Object)string2, (Object)rel1.getProperty(key1));
            rel1.removeProperty(key1);
            rel1.setProperty(key1, (Object)true);
            rel1.setProperty(key1, (Object)false);
            Assertions.assertEquals((Object)false, (Object)rel1.getProperty(key1));
            rel1.removeProperty(key1);
            rel1.delete();
            node2.delete();
            node1.delete();
            transaction.commit();
        }
    }

    @Test
    void testRelGetProperties() {
        Integer int1 = 1;
        Integer int2 = 2;
        String string = "3";
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Assertions.assertThrows(NotFoundException.class, () -> rel1.getProperty(key1));
            Assertions.assertThrows(IllegalArgumentException.class, () -> rel1.getProperty(null));
            Assertions.assertFalse((boolean)rel1.hasProperty(key1));
            Assertions.assertFalse((boolean)rel1.hasProperty(null));
            rel1.setProperty(key1, (Object)int1);
            rel1.setProperty(key2, (Object)int2);
            rel1.setProperty(key3, (Object)string);
            Assertions.assertTrue((boolean)rel1.hasProperty(key1));
            Assertions.assertTrue((boolean)rel1.hasProperty(key2));
            Assertions.assertTrue((boolean)rel1.hasProperty(key3));
            Map properties = rel1.getAllProperties();
            Assertions.assertEquals(properties.get(key1), (Object)int1);
            Assertions.assertEquals(properties.get(key2), (Object)int2);
            Assertions.assertEquals(properties.get(key3), (Object)string);
            properties = rel1.getProperties(new String[]{key1, key2});
            Assertions.assertEquals(properties.get(key1), (Object)int1);
            Assertions.assertEquals(properties.get(key2), (Object)int2);
            Assertions.assertFalse((boolean)properties.containsKey(key3));
            properties = node1.getProperties(new String[0]);
            Assertions.assertTrue((boolean)properties.isEmpty());
            Assertions.assertThrows(NullPointerException.class, () -> node1.getProperties((String[])null));
            Assertions.assertThrows(NullPointerException.class, () -> {
                String[] names = new String[]{null};
                node1.getProperties(names);
                Assertions.fail();
            });
            Assertions.assertDoesNotThrow(() -> rel1.removeProperty(key3), (String)"Remove of property failed.");
            Assertions.assertFalse((boolean)rel1.hasProperty(key3));
            Assertions.assertFalse((boolean)rel1.hasProperty(null));
            rel1.delete();
            node2.delete();
            node1.delete();
            transaction.commit();
        }
    }

    @Test
    void testDirectedRelationship() {
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            Relationship rel2 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Relationship rel3 = node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
            Node[] nodes = rel2.getNodes();
            Assertions.assertEquals((int)2, (int)nodes.length);
            Assertions.assertTrue((nodes[0].equals((Object)node1) && nodes[1].equals((Object)node2) ? 1 : 0) != 0);
            nodes = rel3.getNodes();
            Assertions.assertEquals((int)2, (int)nodes.length);
            Assertions.assertTrue((nodes[0].equals((Object)node2) && nodes[1].equals((Object)node1) ? 1 : 0) != 0);
            Assertions.assertEquals((Object)node1, (Object)rel2.getStartNode());
            Assertions.assertEquals((Object)node2, (Object)rel2.getEndNode());
            Assertions.assertEquals((Object)node2, (Object)rel3.getStartNode());
            Assertions.assertEquals((Object)node1, (Object)rel3.getEndNode());
            Relationship[] relArray = TestRelationship.getRelationshipArray((Iterable<Relationship>)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray.length);
            Assertions.assertEquals((Object)rel2, (Object)relArray[0]);
            relArray = TestRelationship.getRelationshipArray((Iterable<Relationship>)node1.getRelationships(Direction.INCOMING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray.length);
            Assertions.assertEquals((Object)rel3, (Object)relArray[0]);
            relArray = TestRelationship.getRelationshipArray((Iterable<Relationship>)node2.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray.length);
            Assertions.assertEquals((Object)rel3, (Object)relArray[0]);
            relArray = TestRelationship.getRelationshipArray((Iterable<Relationship>)node2.getRelationships(Direction.INCOMING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray.length);
            Assertions.assertEquals((Object)rel2, (Object)relArray[0]);
            rel2.delete();
            rel3.delete();
            node1.delete();
            node2.delete();
            transaction.commit();
        }
    }

    @Test
    void testRollbackDeleteRelationship() {
        String rel1Id;
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            rel1Id = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST).getElementId();
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeByElementId(node1Id).delete();
            transaction.getRelationshipByElementId(rel1Id).delete();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeByElementId(node1Id).delete();
            transaction.getNodeByElementId(node2Id).delete();
            transaction.getRelationshipByElementId(rel1Id).delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testCreateRelationshipWithCommits() {
        Node n2;
        Node n1;
        String n1Id = this.createNode();
        String n2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            n1 = transaction.getNodeByElementId(n1Id);
            n2 = transaction.getNodeByElementId(n2Id);
            n1.createRelationshipTo(n2, (RelationshipType)MyRelTypes.TEST);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            n1 = transaction.getNodeByElementId(n1Id);
            n2 = transaction.getNodeByElementId(n2Id);
            Relationship[] relArray = TestRelationship.getRelationshipArray((Iterable<Relationship>)n1.getRelationships());
            Assertions.assertEquals((int)1, (int)relArray.length);
            relArray = TestRelationship.getRelationshipArray((Iterable<Relationship>)n1.getRelationships());
            relArray[0].delete();
            n1.delete();
            n2.delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testAddPropertyThenDelete() {
        String relId;
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            relId = rel.getElementId();
            rel.setProperty("test", (Object)"test");
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Relationship rel = transaction.getRelationshipByElementId(relId);
            rel.setProperty("test2", (Object)"test2");
            rel.delete();
            transaction.getNodeByElementId(node1Id).delete();
            transaction.getNodeByElementId(node2Id).delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testRelationshipIsType() {
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Assertions.assertTrue((boolean)rel.isType((RelationshipType)MyRelTypes.TEST));
            Assertions.assertTrue((boolean)rel.isType(() -> MyRelTypes.TEST.name()));
            Assertions.assertFalse((boolean)rel.isType((RelationshipType)MyRelTypes.TEST_TRAVERSAL));
            rel.delete();
            node1.delete();
            node2.delete();
            transaction.commit();
        }
    }

    @Test
    void testChangeProperty() {
        Relationship rel;
        String relId;
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            Relationship rel2 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            relId = rel2.getElementId();
            rel2.setProperty("test", (Object)"test1");
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            rel = transaction.getRelationshipByElementId(relId);
            rel.setProperty("test", (Object)"test2");
            rel.removeProperty("test");
            rel.setProperty("test", (Object)"test3");
            Assertions.assertEquals((Object)"test3", (Object)rel.getProperty("test"));
            rel.removeProperty("test");
            rel.setProperty("test", (Object)"test4");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            rel = transaction.getRelationshipByElementId(relId);
            Assertions.assertEquals((Object)"test4", (Object)rel.getProperty("test"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testChangeProperty2() {
        Relationship rel;
        String relId;
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            Relationship rel2 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            relId = rel2.getElementId();
            rel2.setProperty("test", (Object)"test1");
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            rel = transaction.getRelationshipByElementId(relId);
            rel.removeProperty("test");
            rel.setProperty("test", (Object)"test3");
            Assertions.assertEquals((Object)"test3", (Object)rel.getProperty("test"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            rel = transaction.getRelationshipByElementId(relId);
            Assertions.assertEquals((Object)"test3", (Object)rel.getProperty("test"));
            rel.removeProperty("test");
            rel.setProperty("test", (Object)"test4");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            rel = transaction.getRelationshipByElementId(relId);
            Assertions.assertEquals((Object)"test4", (Object)rel.getProperty("test"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void makeSureLazyLoadingRelationshipsWorksEvenIfOtherIteratorAlsoLoadsInTheSameIteration() {
        Node neighbor;
        int k;
        RelationshipType innie;
        Node hub;
        int numEdges = 100;
        String[] nodes = new String[256];
        try (Transaction transaction = this.getGraphDb().beginTx();){
            for (int numNodes = 0; numNodes < nodes.length; ++numNodes) {
                nodes[numNodes] = transaction.createNode().getElementId();
            }
            transaction.commit();
        }
        int nextID = 7;
        String hubId = nodes[4];
        try (Transaction transaction = this.getGraphDb().beginTx();){
            hub = transaction.getNodeByElementId(hubId);
            RelationshipType outtie = RelationshipType.withName((String)"outtie");
            innie = RelationshipType.withName((String)"innie");
            for (k = 0; k < numEdges; ++k) {
                neighbor = transaction.getNodeByElementId(nodes[nextID]);
                nextID += 7;
                if ((nextID &= 0xFF) == 0) {
                    nextID = 1;
                }
                hub.createRelationshipTo(neighbor, outtie);
            }
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            hub = transaction.getNodeByElementId(hubId);
            for (k = 0; k < numEdges; ++k) {
                neighbor = transaction.getNodeByElementId(nodes[nextID]);
                nextID += 7;
                if ((nextID &= 0xFF) == 0) {
                    nextID = 1;
                }
                neighbor.createRelationshipTo(hub, innie);
            }
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            int count;
            hub = transaction.getNodeByElementId(hubId);
            try (Stream stream = hub.getRelationships().stream();){
                count = stream.map(r -> Iterables.count((Iterable)hub.getRelationships())).mapToInt(Long::intValue).sum();
                Assertions.assertEquals((int)40000, (int)count);
            }
            stream = hub.getRelationships().stream();
            try {
                count = stream.map(r -> Iterables.count((Iterable)hub.getRelationships())).mapToInt(Long::intValue).sum();
                Assertions.assertEquals((int)40000, (int)count);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void createRelationshipAfterClearedCache() {
        int i;
        Node node2;
        Node node1;
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        int expectedCount = 0;
        try (Transaction transaction = this.getGraphDb().beginTx();){
            node1 = transaction.getNodeByElementId(node1Id);
            node2 = transaction.getNodeByElementId(node2Id);
            for (i = 0; i < 150; ++i) {
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
                ++expectedCount;
            }
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeByElementId(node1Id);
            node2 = transaction.getNodeByElementId(node2Id);
            for (i = 0; i < 50; ++i) {
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
                ++expectedCount;
            }
            Assertions.assertEquals((long)expectedCount, (long)Iterables.count((Iterable)node1.getRelationships()));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeByElementId(node1Id);
            Assertions.assertEquals((long)expectedCount, (long)Iterables.count((Iterable)node1.getRelationships()));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void getAllRelationships() {
        HashSet existingRelationships = new HashSet();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Iterables.addAll(existingRelationships, (Iterable)transaction.getAllRelationships());
            transaction.commit();
        }
        HashSet<Relationship> createdRelationships = new HashSet<Relationship>();
        String nodeId = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node = transaction.getNodeByElementId(nodeId);
            for (int i = 0; i < 100; ++i) {
                createdRelationships.add(node.createRelationshipTo(transaction.createNode(), (RelationshipType)MyRelTypes.TEST));
            }
            transaction.commit();
        }
        HashSet allRelationships = new HashSet();
        allRelationships.addAll(existingRelationships);
        allRelationships.addAll(createdRelationships);
        try (Transaction transaction = this.getGraphDb().beginTx();
             ResourceIterable allRelationships1 = transaction.getAllRelationships();){
            int count = 0;
            for (Relationship rel : allRelationships1) {
                Assertions.assertTrue((boolean)allRelationships.contains(rel), (String)("Unexpected rel " + String.valueOf(rel) + ", expected one of " + String.valueOf(allRelationships)));
                ++count;
            }
            Assertions.assertEquals((int)allRelationships.size(), (int)count);
            transaction.commit();
        }
    }

    @Test
    void createAndClearCacheBeforeCommit() {
        String nodeId = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node = transaction.getNodeByElementId(nodeId);
            node.createRelationshipTo(transaction.createNode(), (RelationshipType)MyRelTypes.TEST);
            Assertions.assertEquals((long)1L, (long)Iterables.count((Iterable)node.getRelationships()));
            transaction.commit();
        }
    }

    @Test
    void setPropertyAndClearCacheBeforeCommit() {
        String nodeId = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node = transaction.getNodeByElementId(nodeId);
            node.setProperty("name", (Object)"Test");
            Assertions.assertEquals((Object)"Test", (Object)node.getProperty("name"));
            transaction.commit();
        }
    }

    @Test
    void shouldNotGetTheSameRelationshipMoreThanOnceWhenAskingForTheSameTypeMultipleTimes() {
        String nodeId = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node = transaction.getNodeByElementId(nodeId);
            node.createRelationshipTo(transaction.createNode(), RelationshipType.withName((String)"FOO"));
            long relationships = Iterables.count((Iterable)node.getRelationships(new RelationshipType[]{RelationshipType.withName((String)"FOO"), RelationshipType.withName((String)"FOO")}));
            Assertions.assertEquals((long)1L, (long)relationships);
            transaction.commit();
        }
    }

    @Test
    void shouldLoadAllRelationships() {
        long two;
        long one;
        String nodeId;
        GraphDatabaseAPI db = this.getGraphDbAPI();
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode();
            nodeId = node.getElementId();
            for (int i = 0; i < 112; ++i) {
                node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
                tx.createNode().createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            }
            tx.commit();
        }
        try (Transaction tx = db.beginTx();){
            Node node = tx.getNodeByElementId(nodeId);
            one = Iterables.count((Iterable)node.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST}));
            two = Iterables.count((Iterable)node.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST}));
            tx.commit();
        }
        Assertions.assertEquals((long)two, (long)one);
    }

    @Test
    void deletionOfSameRelationshipTwiceInOneTransactionShouldNotRollbackIt() {
        String relationshipId;
        GraphDatabaseService db = this.getGraphDb();
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            relationshipId = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST).getElementId();
            transaction.commit();
        }
        try (Transaction tx = db.beginTx();){
            Relationship relationship = tx.getRelationshipByElementId(relationshipId);
            relationship.delete();
            Assertions.assertThrows(NotFoundException.class, () -> ((Relationship)relationship).delete());
            tx.commit();
        }
        tx = db.beginTx();
        try {
            Assertions.assertThrows(NotFoundException.class, () -> tx.getRelationshipByElementId(relationshipId));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void deletionOfAlreadyDeletedRelationshipShouldThrow() {
        String relId;
        GraphDatabaseService db = this.getGraphDb();
        String node1Id = this.createNode();
        String node2Id = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeByElementId(node1Id);
            Node node2 = transaction.getNodeByElementId(node2Id);
            relId = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST).getElementId();
            transaction.commit();
        }
        try (Transaction tx = db.beginTx();){
            tx.getRelationshipByElementId(relId).delete();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            Assertions.assertThrows(NotFoundException.class, () -> tx.getRelationshipByElementId(relId).delete());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

