/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class TestShortStringProperties {
    private static final String LONG_STRING = "this is a really long string, believe me!";
    @Inject
    private GraphDatabaseService graphdb;

    TestShortStringProperties() {
    }

    @Test
    void canAddMultipleShortStringsToTheSameNode() {
        String nodeId;
        try (Transaction transaction = this.graphdb.beginTx();){
            Node node = transaction.createNode();
            nodeId = node.getElementId();
            node.setProperty("key", (Object)"value");
            node.setProperty("reverse", (Object)"esrever");
            transaction.commit();
        }
        transaction = this.graphdb.beginTx();
        try {
            Node n = transaction.getNodeByElementId(nodeId);
            Assertions.assertEquals((Object)"value", (Object)n.getProperty("key"));
            Assertions.assertEquals((Object)"esrever", (Object)n.getProperty("reverse"));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void canAddShortStringToRelationship() {
        String relId;
        try (Transaction transaction = this.graphdb.beginTx();){
            Relationship rel = transaction.createNode().createRelationshipTo(transaction.createNode(), RelationshipType.withName((String)"REL_TYPE"));
            relId = rel.getElementId();
            rel.setProperty("type", (Object)"dimsedut");
            transaction.commit();
        }
        transaction = this.graphdb.beginTx();
        try {
            Relationship r = transaction.getRelationshipByElementId(relId);
            Assertions.assertEquals((Object)"dimsedut", (Object)r.getProperty("type"));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void canUpdateShortStringInplace() {
        Node n;
        String nodeId;
        try (Transaction transaction = this.graphdb.beginTx();){
            Node node = transaction.createNode();
            nodeId = node.getElementId();
            node.setProperty("key", (Object)"value");
            transaction.commit();
        }
        transaction = this.graphdb.beginTx();
        try {
            n = transaction.getNodeByElementId(nodeId);
            Assertions.assertEquals((Object)"value", (Object)n.getProperty("key"));
            n.setProperty("key", (Object)"other");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.graphdb.beginTx();
        try {
            n = transaction.getNodeByElementId(nodeId);
            Assertions.assertEquals((Object)"other", (Object)n.getProperty("key"));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void canReplaceLongStringWithShortString() {
        String nodeId;
        Node node;
        try (Transaction transaction = this.graphdb.beginTx();){
            node = transaction.createNode();
            nodeId = node.getElementId();
            node.setProperty("key", (Object)LONG_STRING);
            transaction.commit();
        }
        transaction = this.graphdb.beginTx();
        try {
            node = transaction.getNodeByElementId(nodeId);
            Assertions.assertEquals((Object)LONG_STRING, (Object)node.getProperty("key"));
            node.setProperty("key", (Object)"value");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.graphdb.beginTx();
        try {
            Node n = transaction.getNodeByElementId(nodeId);
            Assertions.assertEquals((Object)"value", (Object)n.getProperty("key"));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void canReplaceShortStringWithLongString() {
        String nodeId;
        Node node;
        try (Transaction transaction = this.graphdb.beginTx();){
            node = transaction.createNode();
            nodeId = node.getElementId();
            node.setProperty("key", (Object)"value");
            transaction.commit();
        }
        transaction = this.graphdb.beginTx();
        try {
            node = transaction.getNodeByElementId(nodeId);
            Assertions.assertEquals((Object)"value", (Object)node.getProperty("key"));
            node.setProperty("key", (Object)LONG_STRING);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.graphdb.beginTx();
        try {
            Node n = transaction.getNodeByElementId(nodeId);
            Assertions.assertEquals((Object)LONG_STRING, (Object)n.getProperty("key"));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void canRemoveShortStringProperty() {
        String nodeId;
        Node node;
        try (Transaction transaction = this.graphdb.beginTx();){
            node = transaction.createNode();
            nodeId = node.getElementId();
            node.setProperty("key", (Object)"value");
            transaction.commit();
        }
        transaction = this.graphdb.beginTx();
        try {
            node = transaction.getNodeByElementId(nodeId);
            Assertions.assertEquals((Object)"value", (Object)node.getProperty("key"));
            node.removeProperty("key");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.graphdb.beginTx();
        try {
            Node n = transaction.getNodeByElementId(nodeId);
            Assertions.assertFalse((boolean)n.hasProperty("key"));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }
}

