/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.StringSearchMode;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class RequireTransactionIT {
    @Inject
    private GraphDatabaseAPI databaseAPI;
    private Transaction transaction;

    RequireTransactionIT() {
    }

    @BeforeEach
    void setUp() {
        this.transaction = this.databaseAPI.beginTx();
    }

    @AfterEach
    void tearDown() {
        if (this.transaction != null) {
            this.transaction.close();
        }
    }

    @Test
    void requireTransactionForNodeCreation() {
        Executable executable = () -> ((Transaction)this.transaction).createNode();
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodeCreationWithLabels() {
        Executable executable = () -> this.transaction.createNode(new Label[]{Label.label((String)"label")});
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodeLookupById() {
        Node node;
        try (Transaction tx = this.databaseAPI.beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        Executable executable = () -> this.transaction.getNodeById(node.getId());
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForRelationshipLookupById() {
        Relationship relationship;
        try (Transaction tx = this.databaseAPI.beginTx();){
            relationship = tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"type"));
            tx.commit();
        }
        Executable executable = () -> this.transaction.getRelationshipById(relationship.getId());
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForBidirectionalTraversal() {
        Executable executable = () -> this.transaction.bidirectionalTraversalDescription();
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForTraversal() {
        Executable executable = () -> this.transaction.traversalDescription();
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForQueryExecution() {
        Executable executable = () -> this.transaction.execute("MATCH (n) RETURN count(n)");
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForQueryExecutionWithParameters() {
        Executable executable = () -> this.transaction.execute("MATCH (n) RETURN count(n)", Collections.emptyMap());
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForAllUsedLabelsLookup() {
        Executable executable = () -> this.transaction.getAllLabelsInUse();
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForAllUsedRelationshipTypesLookup() {
        Executable executable = () -> this.transaction.getAllRelationshipTypesInUse();
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForAllLabelsLookup() {
        Executable executable = () -> this.transaction.getAllLabels();
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForAllRelationshipTypesLookup() {
        Executable executable = () -> this.transaction.getAllRelationshipTypes();
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForAllPropertyKeysLookup() {
        Executable executable = () -> this.transaction.getAllPropertyKeys();
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodeLookupByLabelPropertyTemplate() {
        Executable executable = () -> this.transaction.findNodes(Label.label((String)"label"), "a", "aa", StringSearchMode.CONTAINS);
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodeLookupByLabelPropertyValues() {
        Executable executable = () -> this.transaction.findNodes(Label.label((String)"label"), Map.of("a", "b", "c", "d"));
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodeLookupByLabelPropertyValuesPairs3() {
        Executable executable = () -> this.transaction.findNodes(Label.label((String)"label"), "a", (Object)"b", "c", (Object)"d", "e", (Object)"f");
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodeLookupByLabelPropertyValuesPairs2() {
        Executable executable = () -> this.transaction.findNodes(Label.label((String)"label"), "a", (Object)"b", "c", (Object)"d");
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodeLookupByLabelPropertyValuesPair() {
        Executable executable = () -> this.transaction.findNode(Label.label((String)"label"), "a", (Object)"b");
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodesLookupByLabelPropertyValuesPair() {
        Executable executable = () -> this.transaction.findNodes(Label.label((String)"label"), "a", (Object)"b");
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForNodeLookupByLabel() {
        Executable executable = () -> this.transaction.findNodes(Label.label((String)"label"));
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForRelationshipsLookupByTypePropertyTemplate() {
        Executable executable = () -> this.transaction.findRelationships(RelationshipType.withName((String)"type"), "a", "aa", StringSearchMode.CONTAINS);
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForRelationshipsLookupByTypePropertyValues() {
        Executable executable = () -> this.transaction.findRelationships(RelationshipType.withName((String)"type"), Map.of("a", "b", "c", "d"));
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForRelationshipsLookupByTypePropertyValuesPairs3() {
        Executable executable = () -> this.transaction.findRelationships(RelationshipType.withName((String)"type"), "a", (Object)"b", "c", (Object)"d", "e", (Object)"f");
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForRelationshipsLookupByTypePropertyValuesPairs2() {
        Executable executable = () -> this.transaction.findRelationships(RelationshipType.withName((String)"type"), "a", (Object)"b", "c", (Object)"d");
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForRelationshipLookupByTypePropertyValuesPair() {
        Executable executable = () -> this.transaction.findRelationship(RelationshipType.withName((String)"type"), "a", (Object)"b");
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForRelationshipsLookupByTypePropertyValuesPair() {
        Executable executable = () -> this.transaction.findRelationships(RelationshipType.withName((String)"type"), "a", (Object)"b");
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForRelationshipLookupByType() {
        Executable executable = () -> this.transaction.findRelationships(RelationshipType.withName((String)"type"));
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void terminateCanBeCalledOnAnyTransaction() {
        this.transaction.terminate();
        this.transaction.close();
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.terminate());
    }

    @Test
    void closeCanBeCalledOnAnyTransaction() {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.close());
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.close());
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.close());
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.close());
    }

    @Test
    void requireTransactionForRollback() {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.rollback());
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.rollback());
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.rollback());
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.transaction.rollback());
    }

    @Test
    void requireTransactionForCommit() {
        Executable executable = () -> this.transaction.commit();
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForAllNodesLookup() {
        Executable executable = () -> this.transaction.getAllNodes().close();
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForAllRelationshipsLookup() {
        Executable executable = () -> this.transaction.getAllRelationships().close();
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForWriteLockAcquisition() {
        Node node;
        try (Transaction tx = this.databaseAPI.beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        Executable executable = () -> this.transaction.acquireWriteLock((Entity)node);
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForReadLockAcquisition() {
        Node node;
        try (Transaction tx = this.databaseAPI.beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        Executable executable = () -> this.transaction.acquireReadLock((Entity)node);
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    @Test
    void requireTransactionForSchemaAccess() {
        Executable executable = () -> this.transaction.schema();
        RequireTransactionIT.checkTransactionRequirement(this.transaction, executable);
    }

    private static void checkTransactionRequirement(Transaction transaction, Executable executable) {
        try (Transaction transaction2 = transaction;){
            RequireTransactionIT.checkDoesNotThrow(executable);
        }
        RequireTransactionIT.checkThrowNotInTransaction(executable);
    }

    static void checkDoesNotThrow(Executable executable) {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow((Executable)executable);
    }

    static void checkThrowNotInTransaction(Executable executable) {
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, (Executable)executable);
        Assertions.assertThat((Throwable)ExceptionUtils.getRootCause((Throwable)e)).isInstanceOf(NotInTransactionException.class);
    }
}

