/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.schema.IndexOrder;

class IndexReadAsserts {
    IndexReadAsserts() {
    }

    static void assertNodes(NodeIndexCursor node, MutableLongSet uniqueIds, long ... expected) {
        uniqueIds.clear();
        int expectedIdCount = expected.length;
        while (expectedIdCount-- > 0) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)("at least " + expected.length + " nodes"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)uniqueIds.add(node.nodeReference()));
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)node.next(), (String)("no more than " + expected.length + " nodes"));
        org.junit.jupiter.api.Assertions.assertEquals((int)expected.length, (int)uniqueIds.size(), (String)"all nodes are unique");
        for (long expectedNode : expected) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)uniqueIds.contains(expectedNode), (String)("expected node " + expectedNode));
        }
    }

    static void assertNodeCount(NodeIndexCursor node, int expectedCount, MutableLongSet uniqueIds) {
        uniqueIds.clear();
        for (int i = 0; i < expectedCount; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)("at least " + expectedCount + " nodes"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)uniqueIds.add(node.nodeReference()));
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)node.next(), (String)("no more than " + expectedCount + " nodes"));
    }

    static void assertRelationships(RelationshipIndexCursor edge, MutableLongSet uniqueIds, long ... expected) {
        uniqueIds.clear();
        int expectedIdCount = expected.length;
        while (expectedIdCount-- > 0) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)edge.next(), (String)("at least " + expected.length + " relationships"));
            long ref = edge.relationshipReference();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)uniqueIds.add(ref), (String)("The cursor found a duplicate edge: " + ref));
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)edge.next(), (String)("no more than " + expected.length + " relationships"));
        org.junit.jupiter.api.Assertions.assertEquals((int)expected.length, (int)uniqueIds.size(), (String)"all relationships are unique");
        for (long expectedRelationship : expected) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)uniqueIds.contains(expectedRelationship), (String)("expected relationship " + expectedRelationship));
        }
    }

    static void assertRelationships(RelationshipIndexCursor edge, MutableLongSet uniqueIds, IndexOrder order, long ... expected) {
        uniqueIds.clear();
        long previousId = -1L;
        int expectedIdCount = expected.length;
        while (expectedIdCount-- > 0) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)edge.next(), (String)("at least " + expected.length + " relationships"));
            long currentId = edge.relationshipReference();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)uniqueIds.add(currentId));
            IndexReadAsserts.checkRelationshipOrder(order, previousId, currentId);
            previousId = currentId;
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)edge.next(), (String)("no more than " + expected.length + " relationships"));
        org.junit.jupiter.api.Assertions.assertEquals((int)expected.length, (int)uniqueIds.size(), (String)"all relationships are unique");
        for (long expectedRelationship : expected) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)uniqueIds.contains(expectedRelationship), (String)("expected relationship " + expectedRelationship));
        }
    }

    static void assertRelationshipCount(RelationshipIndexCursor edge, int edges, MutableLongSet uniqueIds) {
        for (int i = 0; i < edges; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)edge.next(), (String)("at least " + edges + " relationships"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)uniqueIds.add(edge.relationshipReference()));
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)edge.next(), (String)("no more than " + edges + " relationships"));
    }

    static void checkRelationshipOrder(IndexOrder expectedOrder, long previousId, long currentId) {
        if (previousId != -1L) {
            switch (expectedOrder) {
                case ASCENDING: {
                    Assertions.assertThat((long)previousId).isLessThan(currentId);
                    break;
                }
                case DESCENDING: {
                    Assertions.assertThat((long)previousId).isGreaterThan(currentId);
                    break;
                }
            }
        }
    }
}

